/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.impl.biome.WeightedBiomeEntry;
import net.minecraft.class_1959;
import net.minecraft.class_3756;
import net.minecraft.class_5321;

public final class WeightedBiomePicker {
    private double currentTotal = 0.0;
    private final List<WeightedBiomeEntry> entries = new ArrayList<WeightedBiomeEntry>();

    WeightedBiomePicker() {
    }

    void addBiome(class_5321<class_1959> biome, double weight) {
        this.currentTotal += weight;
        this.entries.add(new WeightedBiomeEntry(biome, weight, this.currentTotal));
    }

    double getCurrentWeightTotal() {
        return this.currentTotal;
    }

    public class_5321<class_1959> pickFromNoise(class_3756 sampler, double x, double y, double z) {
        double target = Math.abs(sampler.method_33658(x, y, z)) * this.getCurrentWeightTotal();
        return this.search(target).biome();
    }

    WeightedBiomeEntry search(double target) {
        Preconditions.checkArgument((target <= this.currentTotal ? 1 : 0) != 0, (Object)"The provided target value for biome selection must be less than or equal to the weight total");
        Preconditions.checkArgument((target >= 0.0 ? 1 : 0) != 0, (Object)"The provided target value for biome selection cannot be negative");
        int low = 0;
        int high = this.entries.size() - 1;
        while (low < high) {
            int mid = high + low >>> 1;
            if (target < this.entries.get(mid).upperWeightBound()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return this.entries.get(low);
    }
}

