/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.impl.biome.WeightedBiomePicker;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_3756;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TheEndBiomeData {
    private static final Set<class_5321<class_1959>> THE_END_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_BIOMES_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_MIDLANDS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();
    private static final Map<class_5321<class_1959>, WeightedBiomePicker> END_BARRENS_MAP = new IdentityHashMap<class_5321<class_1959>, WeightedBiomePicker>();

    private TheEndBiomeData() {
    }

    public static void addEndBiomeReplacement(class_5321<class_1959> replaced, class_5321<class_1959> variant, double weight) {
        Preconditions.checkNotNull(replaced, (Object)"replaced biome is null");
        Preconditions.checkNotNull(variant, (Object)"variant biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BIOMES_MAP.computeIfAbsent(replaced, key -> new WeightedBiomePicker()).addBiome(variant, weight);
        TheEndBiomeData.clearBiomeSourceCache();
    }

    public static void addEndMidlandsReplacement(class_5321<class_1959> highlands, class_5321<class_1959> midlands, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands biome is null");
        Preconditions.checkNotNull(midlands, (Object)"midlands biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_MIDLANDS_MAP.computeIfAbsent(highlands, key -> new WeightedBiomePicker()).addBiome(midlands, weight);
        TheEndBiomeData.clearBiomeSourceCache();
    }

    public static void addEndBarrensReplacement(class_5321<class_1959> highlands, class_5321<class_1959> barrens, double weight) {
        Preconditions.checkNotNull(highlands, (Object)"highlands biome is null");
        Preconditions.checkNotNull(barrens, (Object)"midlands biome is null");
        Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (String)"Weight is less than or equal to 0.0 (got %s)", (Object)weight);
        END_BARRENS_MAP.computeIfAbsent(highlands, key -> new WeightedBiomePicker()).addBiome(barrens, weight);
        TheEndBiomeData.clearBiomeSourceCache();
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndBiomesMap() {
        return END_BIOMES_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndMidlandsMap() {
        return END_MIDLANDS_MAP;
    }

    public static Map<class_5321<class_1959>, WeightedBiomePicker> getEndBarrensMap() {
        return END_BARRENS_MAP;
    }

    public static boolean canGenerateInTheEnd(class_5321<class_1959> biome) {
        if (THE_END_BIOMES.isEmpty()) {
            for (class_1959 endBiome : new class_2169(class_5458.field_25933, 0L).method_28443()) {
                class_5458.field_25933.method_29113((Object)endBiome).ifPresent(THE_END_BIOMES::add);
            }
        }
        return THE_END_BIOMES.contains(biome);
    }

    private static void clearBiomeSourceCache() {
        THE_END_BIOMES.clear();
    }

    public static class_5321<class_1959> pickEndBiome(int biomeX, int biomeY, int biomeZ, class_3756 sampler, class_5321<class_1959> vanillaKey) {
        class_5321<class_1959> replacementKey;
        if (vanillaKey == class_1972.field_9447 || vanillaKey == class_1972.field_9465) {
            WeightedBiomePicker barrensPicker;
            WeightedBiomePicker midlandsPicker;
            WeightedBiomePicker highlandsPicker = TheEndBiomeData.getEndBiomesMap().get(class_1972.field_9442);
            class_5321<class_1959> highlandsKey = highlandsPicker.pickFromNoise(sampler, (double)biomeX / 64.0, 0.0, (double)biomeZ / 64.0);
            replacementKey = vanillaKey == class_1972.field_9447 ? ((midlandsPicker = TheEndBiomeData.getEndMidlandsMap().get(highlandsKey)) == null ? vanillaKey : midlandsPicker.pickFromNoise(sampler, (double)biomeX / 64.0, 0.0, (double)biomeZ / 64.0)) : ((barrensPicker = TheEndBiomeData.getEndBarrensMap().get(highlandsKey)) == null ? vanillaKey : barrensPicker.pickFromNoise(sampler, (double)biomeX / 64.0, 0.0, (double)biomeZ / 64.0));
        } else {
            WeightedBiomePicker picker = TheEndBiomeData.getEndBiomesMap().get(vanillaKey);
            replacementKey = picker.pickFromNoise(sampler, (double)biomeX / 64.0, 0.0, (double)biomeZ / 64.0);
        }
        return replacementKey;
    }

    static {
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9411, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9411, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9442, 1.0);
        END_BIOMES_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9457, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9457, 1.0);
        END_MIDLANDS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9447, 1.0);
        END_BARRENS_MAP.computeIfAbsent((class_5321<class_1959>)class_1972.field_9442, key -> new WeightedBiomePicker()).addBiome((class_5321<class_1959>)class_1972.field_9465, 1.0);
    }
}

