/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.biome;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_4766;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6544;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NetherBiomeData {
    private static final Set<class_5321<class_1959>> NETHER_BIOMES = new HashSet<class_5321<class_1959>>();
    private static final Map<class_5321<class_1959>, class_6544.class_4762> NETHER_BIOME_NOISE_POINTS = new HashMap<class_5321<class_1959>, class_6544.class_4762>();

    private NetherBiomeData() {
    }

    public static void addNetherBiome(class_5321<class_1959> biome, class_6544.class_4762 spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"MultiNoiseUtil.NoiseValuePoint is null");
        NETHER_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        NetherBiomeData.clearBiomeSourceCache();
    }

    public static Map<class_5321<class_1959>, class_6544.class_4762> getNetherBiomeNoisePoints() {
        return NETHER_BIOME_NOISE_POINTS;
    }

    public static boolean canGenerateInNether(class_5321<class_1959> biome) {
        if (NETHER_BIOMES.isEmpty()) {
            class_4766 source = class_4766.class_5305.field_24723.method_28469(class_5458.field_25933);
            for (class_1959 netherBiome : source.method_28443()) {
                class_5458.field_25933.method_29113((Object)netherBiome).ifPresent(NETHER_BIOMES::add);
            }
        }
        return NETHER_BIOMES.contains(biome);
    }

    private static void clearBiomeSourceCache() {
        NETHER_BIOMES.clear();
    }
}

