/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.world;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidTypeFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.fluid.world.IFluidBlockMixin;
import alexiil.mc.lib.attributes.fluid.world.IFluidVolumeDrainable;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3737;
import net.minecraft.class_4538;

public final class FluidWorldUtil {
    private static final Map<class_2248, IFluidVolumeDrainable> customDrainables = new IdentityHashMap<class_2248, IFluidVolumeDrainable>();

    public static void registerCustomDrainable(class_2248 block, IFluidVolumeDrainable drainer) {
        customDrainables.put(block, drainer);
    }

    public static FluidVolume drain(class_1936 world, class_2338 pos, Simulation simulation) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof IFluidVolumeDrainable) {
            return ((IFluidVolumeDrainable)block).tryDrainFluid(world, pos, state, simulation);
        }
        if (block instanceof class_3737 && state.method_28498((class_2769)class_2741.field_12508)) {
            if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                FluidVolume fluidVolume = FluidKeys.WATER.fromWorld((class_4538)world, pos);
                if (simulation == Simulation.ACTION) {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 3);
                }
                return fluidVolume;
            }
            return FluidVolumeUtil.EMPTY;
        }
        if (block instanceof class_2404 && state.method_28498((class_2769)class_2741.field_12538) && (Integer)state.method_11654((class_2769)class_2741.field_12538) == 0) {
            FluidKey fluidKey = FluidKeys.get((class_3611)((IFluidBlockMixin)block).__fluid());
            if (fluidKey == null) {
                return FluidVolumeUtil.EMPTY;
            }
            FluidVolume fluidVolume = fluidKey.fromWorld((class_4538)world, pos);
            if (simulation == Simulation.ACTION) {
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            }
            return fluidVolume;
        }
        IFluidVolumeDrainable drainer = customDrainables.get(block);
        if (drainer != null) {
            return drainer.tryDrainFluid(world, pos, state, simulation);
        }
        return FluidVolumeUtil.EMPTY;
    }

    public static FluidVolume fill(class_1936 world, class_2338 pos, FluidVolume volume, Simulation simulation) {
        class_3610 fluidState;
        if (volume.getAmount_F().isLessThan(FluidAmount.BUCKET)) {
            return volume;
        }
        class_3611 fluid = volume.getRawFluid();
        if (fluid == null) {
            return volume;
        }
        boolean success = false;
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (state.method_26215()) {
            if (simulation == Simulation.ACTION) {
                class_2680 fluidStillState = fluid.method_15785().method_15759();
                world.method_8652(pos, fluidStillState, 3);
            }
            success = true;
        } else if (block instanceof class_2402) {
            class_2402 fillable = (class_2402)block;
            success = simulation == Simulation.SIMULATE ? fillable.method_10310((class_1922)world, pos, state, fluid) : fillable.method_10311(world, pos, state, fluid.method_15785());
        } else if (block instanceof class_2404 && !(fluidState = world.method_8316(pos)).method_15771() && FluidWorldUtil.getStillFluid(fluidState.method_15772()) == fluid) {
            if (simulation == Simulation.ACTION) {
                world.method_8652(pos, fluid.method_15785().method_15759(), 3);
            }
            success = true;
        }
        if (success) {
            volume = volume.copy();
            volume.split(FluidAmount.BUCKET);
            return volume;
        }
        return volume;
    }

    private static class_3611 getStillFluid(class_3611 fluid) {
        if (fluid instanceof class_3609) {
            return ((class_3609)fluid).method_15751();
        }
        return fluid;
    }

    public static FluidExtractable createFluidDrainer(final class_1936 world, final class_2338 pos) {
        return new FluidExtractable(){

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                FluidVolume simulated = FluidWorldUtil.drain(world, pos, Simulation.SIMULATE);
                if (simulated.amount().isGreaterThan(maxAmount)) {
                    return FluidVolumeUtil.EMPTY;
                }
                if (simulation.isSimulate()) {
                    return simulated;
                }
                return FluidWorldUtil.drain(world, pos, Simulation.ACTION);
            }
        };
    }

    public static FluidInsertable createFluidPlacer(final class_1936 world, final class_2338 pos) {
        return new FluidInsertable(){

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return FluidWorldUtil.fill(world, pos, fluid, simulation);
            }

            @Override
            public FluidFilter getInsertionFilter() {
                return FluidTypeFilter.RAW_FLUID;
            }
        };
    }
}

