/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.fluid.volume.WeightedFluidKey;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public abstract class WeightedFluidVolume<T>
extends FluidVolume {
    private final WeightedFluidKey<T> key;
    private final Map<T, FluidAmount> values = new HashMap<T, FluidAmount>();

    public WeightedFluidVolume(WeightedFluidKey<T> key, T value, FluidAmount amount) {
        super(key, amount);
        this.key = key;
        this.values.put(value, FluidAmount.ONE);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public WeightedFluidVolume(WeightedFluidKey<T> key, T value, int amount) {
        this(key, value, FluidAmount.of1620(amount));
    }

    public WeightedFluidVolume(WeightedFluidKey<T> key, class_2487 tag) {
        super(key, tag);
        this.key = key;
        T _def = this.defaultValue();
        class_2499 list = tag.method_10554(this.saveName(), (int)new class_2487().method_10711());
        for (int i = 0; i < list.size(); ++i) {
            class_2487 ctag = list.method_10602(i);
            FluidAmount amount = ctag.method_10545("Amount") ? FluidAmount.of1620(ctag.method_10550("Amount")) : FluidAmount.fromNbt(ctag.method_10562("AmountF"));
            T value = this.readValue(ctag);
            if (value == null) {
                value = _def;
            }
            if (amount.isNegative() || amount.isOverflow()) {
                amount = FluidAmount.ZERO;
            }
            this.values.put(value, amount.roundedAdd(this.values.get(value)));
        }
        this.normalize();
    }

    public WeightedFluidVolume(WeightedFluidKey<T> key, JsonObject json, WeightedStringGetter<T> keyGetter) throws JsonSyntaxException {
        super(key, json);
        this.key = key;
        assert (this.areJsonValuesCompact()) : "areJsonValuesCompact is false! (wrong constructor)";
        JsonElement weights = json.get(this.saveName());
        if (weights != null) {
            if (!weights.isJsonObject()) {
                throw new JsonSyntaxException("Expected '" + this.saveName() + "' to be an object, but was " + weights);
            }
            for (Map.Entry entry : weights.getAsJsonObject().entrySet()) {
                T value = keyGetter.get((String)entry.getKey());
                if (value == null) {
                    throw new JsonSyntaxException("Unknown value '" + (String)entry.getKey() + "'");
                }
                FluidAmount amount = FluidVolume.parseAmount((JsonElement)entry.getValue());
                if (this.values.containsKey(value)) {
                    throw new JsonSyntaxException("Duplicate values for " + (String)entry.getKey());
                }
                this.values.put(value, amount);
            }
            this.normalize();
        }
    }

    public WeightedFluidVolume(WeightedFluidKey<T> key, JsonObject json, WeightedJsonGetter<T> keyGetter) throws JsonSyntaxException {
        super(key, json);
        this.key = key;
        assert (!this.areJsonValuesCompact()) : "areJsonValuesCompact is true! (wrong constructor)";
        JsonElement weights = json.get(this.saveName());
        if (weights != null) {
            if (!weights.isJsonArray()) {
                throw new JsonSyntaxException("Expected '" + this.saveName() + "' to be an array of objects, but was " + weights);
            }
            for (JsonElement elem : weights.getAsJsonArray()) {
                if (!elem.isJsonObject()) {
                    throw new JsonSyntaxException("Expected '" + this.saveName() + "' to be an array of objects, but found " + elem + " in the array!");
                }
                JsonObject obj = elem.getAsJsonObject();
                JsonElement value = obj.get("value");
                if (value == null) {
                    throw new JsonSyntaxException("Expected 'value', but got nothing!");
                }
                T val = keyGetter.fromJson(value);
                FluidAmount fa = FluidVolume.parseAmount(obj.get("amount"));
                if (this.values.containsKey(val)) {
                    throw new JsonSyntaxException("Duplicate values for " + value);
                }
                this.values.put(val, fa);
            }
            this.normalize();
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject json;
        block4: {
            json = super.toJson();
            if (this.values.isEmpty() || this.values.size() == 1 && this.values.keySet().iterator().next() == this.defaultValue()) break block4;
            if (this.areJsonValuesCompact()) {
                JsonObject weights = new JsonObject();
                json.add(this.saveName(), (JsonElement)weights);
                for (Map.Entry<T, FluidAmount> entry : this.values.entrySet()) {
                    weights.addProperty(this.toJson(entry.getKey()).getAsString(), entry.getValue().toParseableString());
                }
            } else {
                JsonArray weights = new JsonArray();
                json.add(this.saveName(), (JsonElement)weights);
                for (Map.Entry<T, FluidAmount> entry : this.values.entrySet()) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("amount", entry.getValue().toParseableString());
                    obj.add("value", this.toJson(entry.getKey()));
                    weights.add((JsonElement)obj);
                }
            }
        }
        return json;
    }

    @Override
    protected void toMcBufferInternal(class_2540 buffer) {
        super.toMcBufferInternal(buffer);
        this.writeValuesToMcBuffer(buffer, this.values);
    }

    @Override
    protected void fromMcBufferInternal(class_2540 buffer) {
        super.fromMcBufferInternal(buffer);
        this.readValuesFromMcBuffer(buffer, this.values);
    }

    protected final void normalize() {
        FluidAmount total = FluidAmount.ZERO;
        for (FluidAmount amount : this.values.values()) {
            total = total.roundedAdd(amount);
        }
        this.normalize(total);
    }

    private final void normalize(FluidAmount ctotal) {
        if (!ctotal.isPositive() || this.values.isEmpty()) {
            this.values.clear();
            return;
        }
        Iterator<Map.Entry<T, FluidAmount>> iterator = this.values.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, FluidAmount> entry = iterator.next();
            FluidAmount fa = entry.getValue();
            if ((fa = fa.roundedDiv(ctotal)).isPositive()) {
                entry.setValue(fa);
                continue;
            }
            iterator.remove();
        }
    }

    @Override
    public class_2487 toTag(class_2487 tag) {
        super.toTag(tag);
        class_2499 list = new class_2499();
        for (Map.Entry<T, FluidAmount> entry : this.values.entrySet()) {
            class_2487 ctag = new class_2487();
            ctag.method_10566("AmountF", (class_2520)entry.getValue().toNbt());
            this.writeValue(ctag, entry.getKey());
            list.add((Object)ctag);
        }
        tag.method_10566(this.saveName(), (class_2520)list);
        return tag;
    }

    protected abstract String saveName();

    protected final T defaultValue() {
        return this.key.defaultValue;
    }

    protected abstract T readValue(class_2487 var1);

    protected abstract void writeValue(class_2487 var1, T var2);

    protected abstract boolean areJsonValuesCompact();

    protected abstract JsonElement toJson(T var1);

    protected void writeValuesToMcBuffer(class_2540 buffer, Map<T, FluidAmount> map) {
        buffer.writeByte(Math.min(255, map.size()));
        Iterator<Map.Entry<T, FluidAmount>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, FluidAmount> entry = iterator.next();
            this.writeValueToMcBuffer(buffer, entry.getKey());
            if (!iterator.hasNext()) continue;
            entry.getValue().toMcBuffer(buffer);
        }
    }

    protected void readValuesFromMcBuffer(class_2540 buffer, Map<T, FluidAmount> map) {
        map.clear();
        short count = buffer.readUnsignedByte();
        FluidAmount total = FluidAmount.ZERO;
        for (int i = count - 1; i >= 0; --i) {
            T value = this.readValueFromMcBuffer(buffer);
            FluidAmount amt = i > 0 ? FluidAmount.fromMcBuffer(buffer) : FluidAmount.ONE.sub(total);
            if (!amt.isPositive()) continue;
            total = total.add(amt);
            map.put(value, amt);
        }
        this.normalize(total);
    }

    protected T readValueFromMcBuffer(class_2540 buffer) {
        return this.readValue(buffer.method_10798());
    }

    protected void writeValueToMcBuffer(class_2540 buffer, T value) {
        class_2487 holder = new class_2487();
        this.writeValue(holder, value);
        buffer.method_10794(holder);
    }

    protected class_2561 getTextFor(T value) {
        return new class_2585(Objects.toString(value));
    }

    @Override
    public WeightedFluidKey<T> getFluidKey() {
        return this.key;
    }

    public Map<T, FluidAmount> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    protected WeightedFluidVolume<T> copy0() {
        FluidVolume copy = this.key.withAmount(this.getAmount_F());
        ((WeightedFluidVolume)copy).values.clear();
        ((WeightedFluidVolume)copy).values.putAll(this.values);
        return copy;
    }

    @Override
    protected WeightedFluidVolume<T> split0(FluidAmount toTake, RoundingMode rounding) {
        FluidVolume split = this.key.withAmount(toTake);
        this.setAmount(this.getAmount_F().roundedSub(toTake, rounding));
        ((WeightedFluidVolume)split).values.clear();
        ((WeightedFluidVolume)split).values.putAll(this.values);
        return split;
    }

    @Override
    protected void mergeInternal(FluidVolume vol, FluidAmount.FluidMergeResult result) {
        WeightedFluidVolume other = (WeightedFluidVolume)vol;
        for (Map.Entry<T, FluidAmount> entry : this.values.entrySet()) {
            entry.setValue(entry.getValue().roundedMul(this.getAmount_F()));
        }
        for (Map.Entry<T, FluidAmount> entry : other.values.entrySet()) {
            Object oKey = this.key.valueClass.cast(entry.getKey());
            this.values.put(oKey, entry.getValue().roundedMul(other.getAmount_F()).roundedAdd(this.values.get(oKey)));
        }
        this.setAmount(result.merged);
        other.setAmount(result.excess);
        other.values.clear();
        this.normalize();
    }

    public void addAmount(T value, FluidAmount amount) {
        this.addAmount(value, amount, FluidAmount.FluidMergeRounding.DEFAULT);
    }

    public void addAmount(T value, FluidAmount amount, FluidAmount.FluidMergeRounding rounding) {
        if (amount == null || amount.isZero()) {
            return;
        }
        FluidAmount.FluidMergeResult result = FluidAmount.merge(this.getAmount_F(), amount, rounding);
        if (result.excess.equals(amount)) {
            return;
        }
        if (result.merged.isNegative()) {
            throw new IllegalArgumentException("Cannot negate " + amount + " from " + this.getAmount_F());
        }
        if (result.merged.isZero()) {
            this.setAmount(FluidAmount.ZERO);
            this.values.clear();
            return;
        }
        this.setAmount(result.merged);
        this.values.put(value, this.values.get(value).roundedAdd(amount.roundedDiv(this.getAmount_F()), rounding.rounding));
        this.normalize();
    }

    public void addAmounts(Map<T, FluidAmount> sources) {
        for (Map.Entry<T, FluidAmount> entry : sources.entrySet()) {
            this.addAmount(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public List<class_2561> getTooltipText(class_1836 ctx) {
        List<class_2561> list = super.getTooltipText(ctx);
        if (ctx.method_8035()) {
            for (Map.Entry<T, FluidAmount> entry : this.values.entrySet()) {
                class_2585 text = new class_2585(entry.getKey() + " of ");
                list.add((class_2561)text.method_10852(this.getTextFor(entry.getKey())).method_27692(class_124.field_1080));
            }
        }
        return list;
    }

    @FunctionalInterface
    public static interface WeightedStringGetter<T> {
        @Nullable
        public T get(String var1);
    }

    @FunctionalInterface
    public static interface WeightedJsonGetter<T> {
        public T fromJson(JsonElement var1) throws JsonSyntaxException;
    }
}

