/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.render.DefaultFluidVolumeRenderer;
import alexiil.mc.lib.attributes.fluid.render.FluidRenderFace;
import alexiil.mc.lib.attributes.fluid.render.FluidVolumeRenderer;
import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidProperty;
import alexiil.mc.lib.attributes.fluid.volume.FluidTemperature;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3576;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class FluidVolume {
    @Deprecated(since="0.6.0", forRemoval=true)
    public static final int BASE_UNIT = 1;
    @Deprecated(since="0.6.0", forRemoval=true)
    public static final int BUCKET = 1620;
    @Deprecated(since="0.6.0", forRemoval=true)
    public static final int BOTTLE = 540;
    static final String KEY_AMOUNT_1620INT = "Amount";
    static final String KEY_AMOUNT_LBA_FRACTION = "AmountF";
    public static final JsonDeserializer<FluidVolume> DESERIALIZER = (json, type, ctx) -> {
        if (json.isJsonNull()) {
            return FluidVolumeUtil.EMPTY;
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected " + json + " to be an object!");
        }
        return FluidVolume.fromJson(json.getAsJsonObject());
    };
    public final FluidKey fluidKey;
    private FluidAmount amount;
    private Object[] propertyValues;

    private FluidVolume(FluidKey key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        class_3611 rawFluid = key.getRawFluid();
        if (rawFluid instanceof class_3576 && key != FluidKeys.EMPTY) {
            throw new IllegalArgumentException("Different empty fluid!");
        }
        if (rawFluid instanceof class_3609 && rawFluid != ((class_3609)rawFluid).method_15751()) {
            throw new IllegalArgumentException("Only the still version of fluids are allowed!");
        }
        this.fluidKey = key;
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public FluidVolume(FluidKey key, int amount) {
        this(key, FluidAmount.of1620(amount));
    }

    public FluidVolume(FluidKey key, FluidAmount amount) {
        this(key);
        this.amount = amount;
        if (key.entry.isEmpty()) {
            if (!amount.isZero()) {
                throw new IllegalArgumentException("Empty Fluid Volume's must have an amount of 0!");
            }
        } else if (amount.isNegative()) {
            throw new IllegalArgumentException("Fluid Volume's must have an amount greater than 0!");
        }
    }

    public FluidVolume(FluidKey key, class_2487 tag) {
        this(key);
        if (key.entry.isEmpty()) {
            this.amount = FluidAmount.ZERO;
        } else {
            if (tag.method_10545(KEY_AMOUNT_1620INT)) {
                int readAmount = tag.method_10550(KEY_AMOUNT_1620INT);
                this.amount = FluidAmount.of1620(Math.max(1, readAmount));
            } else {
                this.amount = FluidAmount.fromNbt(tag.method_10562(KEY_AMOUNT_LBA_FRACTION));
                if (this.amount.isNegative()) {
                    this.amount = this.amount.negate();
                }
            }
            if (!key.properties.isEmpty()) {
                class_2487 properties = tag.method_10562("Properties");
                for (int index = key.properties.size() - 1; index >= 0; --index) {
                    Object value;
                    FluidProperty<?> property = key.properties.get(index);
                    class_2520 propTag = properties.method_10580(property.nbtKey);
                    if (propTag == null || (value = property.fromTag(propTag)) == null || value == property.defaultValue) continue;
                    this.putPropertyValue(property, value);
                }
            }
        }
    }

    public static FluidVolume fromTag(class_2487 tag) {
        if (tag.method_33133()) {
            return FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);
        }
        return FluidKey.fromTag(tag).readVolume(tag);
    }

    public final class_2487 toTag() {
        return this.toTag(new class_2487());
    }

    public class_2487 toTag(class_2487 tag) {
        if (this.isEmpty()) {
            return tag;
        }
        this.fluidKey.toTag(tag);
        tag.method_10566(KEY_AMOUNT_LBA_FRACTION, (class_2520)this.amount.toNbt());
        if (this.propertyValues != null) {
            class_2487 properties = new class_2487();
            for (int index = this.propertyValues.length - 1; index >= 0; --index) {
                FluidProperty<?> property;
                class_2520 propTag;
                Object value = this.propertyValues[index];
                if (value == null || (propTag = FluidVolume.propToTag(property = this.fluidKey.properties.get(index), value)) == null) continue;
                properties.method_10566(property.nbtKey, propTag);
            }
            if (!properties.method_33133()) {
                tag.method_10566("Properties", (class_2520)properties);
            }
        }
        return tag;
    }

    private static <T> class_2520 propToTag(FluidProperty<T> property, Object value) {
        return property.toTag(property.type.cast(value));
    }

    public FluidVolume(FluidKey key, JsonObject json) throws JsonSyntaxException {
        this(key);
        JsonElement ja;
        this.amount = key.entry.isEmpty() ? FluidAmount.ZERO : ((ja = json.get("amount")) == null ? FluidAmount.ZERO : FluidVolume.parseAmount(ja));
    }

    public static FluidAmount parseAmount(JsonElement elem) throws JsonSyntaxException {
        if (elem == null) {
            throw new JsonSyntaxException("Expected 'amount' to be a string, but was missing!");
        }
        return FluidAmount.fromJson(elem);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.fluidKey.toJson(json);
        if (!this.isEmpty()) {
            json.add("amount", this.amount.toJson());
        }
        return json;
    }

    public static FluidVolume fromJson(JsonObject json) throws JsonSyntaxException {
        try {
            return FluidKey.fromJsonInternal(json).readVolume(json);
        }
        catch (JsonSyntaxException jse) {
            throw new JsonSyntaxException("Not a valid fluid volume: " + json, (Throwable)jse);
        }
    }

    public final void toMcBuffer(class_2540 buffer) {
        if (this.isEmpty()) {
            FluidKeys.EMPTY.toMcBuffer(buffer);
        } else {
            this.fluidKey.toMcBuffer(buffer);
            this.toMcBufferInternal(buffer);
            this.writeProperties(buffer);
        }
    }

    protected void toMcBufferInternal(class_2540 buffer) {
        this.amount.toMcBuffer(buffer);
    }

    public static FluidVolume fromMcBuffer(class_2540 buffer) throws IOException {
        return FluidKey.fromMcBuffer(buffer).readVolume(buffer);
    }

    protected void fromMcBufferInternal(class_2540 buffer) {
    }

    final void writeProperties(class_2540 buffer) {
        if (!this.fluidKey.properties.isEmpty()) {
            int countPresent = 0;
            for (Object obj : this.propertyValues) {
                if (obj == null) continue;
                ++countPresent;
            }
            buffer.writeByte(countPresent);
            for (int i = this.propertyValues.length - 1; i >= 0; --i) {
                FluidProperty<?> prop = this.fluidKey.properties.get(i);
                Object val = this.propertyValues[i];
                if (val == null) continue;
                buffer.method_10814(prop.nbtKey);
                FluidVolume.writeProp(prop, val, buffer);
            }
        }
    }

    private static <T> void writeProp(FluidProperty<T> prop, Object value, class_2540 buffer) {
        prop.writeToBuffer(buffer, prop.type.cast(value));
    }

    final void readProperties(class_2540 buffer) {
        if (!this.fluidKey.properties.isEmpty()) {
            int count = buffer.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                String key = buffer.method_19772();
                int propIndex = this.fluidKey.propertyKeys.getInt((Object)key);
                if (propIndex < 0) {
                    throw new IllegalArgumentException("Unknown remote fluid property " + key + " for " + this.fluidKey);
                }
                this.readProp(buffer, this.fluidKey.properties.get(propIndex));
            }
        }
    }

    private <T> void readProp(class_2540 buffer, FluidProperty<T> prop) {
        prop.set(this, prop.readFromBuffer(buffer));
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidVolume create(FluidKey fluid, int amount) {
        return fluid.withAmount(amount);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidVolume create(class_3611 fluid, int amount) {
        return FluidKeys.get(fluid).withAmount(amount);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidVolume create(class_1842 potion, int amount) {
        return FluidKeys.get(potion).withAmount(amount);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.isEmpty() && obj instanceof FluidVolume) {
            return ((FluidVolume)obj).isEmpty();
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FluidVolume other = (FluidVolume)obj;
        if (other.isEmpty()) {
            return false;
        }
        return this.amount.equals(other.amount) && Objects.equals(this.fluidKey, other.fluidKey);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.fluidKey.hashCode() + 31 * this.amount.hashCode();
    }

    public String toString() {
        return this.fluidKey + " " + this.localizeAmount();
    }

    public String localizeAmount() {
        return this.fluidKey.unitSet.localizeAmount(this.getAmount_F());
    }

    public final String localizeAmount(FluidTooltipContext ctx) {
        return this.fluidKey.unitSet.localizeAmount(this.getAmount_F(), this.getName(), ctx);
    }

    public String localizeInTank(FluidAmount capacity) {
        return this.fluidKey.unitSet.localizeTank(this.getAmount_F(), capacity);
    }

    public final String localizeInTank(FluidAmount capacity, FluidTooltipContext ctx) {
        return this.fluidKey.unitSet.localizeTank(this.getAmount_F(), capacity, this.getName(), ctx);
    }

    @Deprecated(since="0.1.11", forRemoval=true)
    public static boolean areFullyEqual(FluidVolume a, FluidVolume b) {
        return Objects.equals(a, b);
    }

    public static boolean areEqualExceptAmounts(FluidVolume a, FluidVolume b) {
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        if (b.isEmpty()) {
            return false;
        }
        return a.getFluidKey().equals(b.getFluidKey());
    }

    public final boolean isEmpty() {
        return this.fluidKey == FluidKeys.EMPTY || this.amount.isZero();
    }

    public FluidKey getFluidKey() {
        return this.fluidKey;
    }

    @Nullable
    public class_3611 getRawFluid() {
        return this.getFluidKey().getRawFluid();
    }

    public final FluidVolume copy() {
        if (this.isEmpty()) {
            return FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);
        }
        FluidVolume copy = this.copy0();
        this.copyPropertiesInto(copy);
        return copy;
    }

    protected FluidVolume copy0() {
        return this.getFluidKey().withAmount(this.amount);
    }

    private final void copyPropertiesInto(FluidVolume dest) {
        dest.propertyValues = this.propertyValues == null ? null : Arrays.copyOf(this.propertyValues, this.propertyValues.length);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public final int getAmount() {
        return this.isEmpty() ? 0 : this.getRawAmount();
    }

    public final FluidAmount getAmount_F() {
        return this.amount();
    }

    public FluidAmount amount() {
        return this.isEmpty() ? FluidAmount.ZERO : this.getRawAmount_F();
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    protected final int getRawAmount() {
        return this.amount.as1620();
    }

    protected final FluidAmount getRawAmount_F() {
        return this.amount;
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    protected final void setAmount(int newAmount) {
        this.setAmount(FluidAmount.of1620(newAmount));
    }

    protected final void setAmount(FluidAmount newAmount) {
        if (newAmount.isNegative()) {
            throw new IllegalArgumentException("newAmount was less than 0! (was " + newAmount + ")");
        }
        this.amount = newAmount;
    }

    public FluidVolume withAmount(FluidAmount newAmount) {
        FluidVolume fv = this.copy();
        fv.setAmount(newAmount);
        return fv;
    }

    public FluidVolume multiplyAmount(int by) {
        return this.withAmount(this.getAmount_F().mul(by));
    }

    public static boolean mergeInto(FluidVolume source, FluidVolume target) {
        return FluidVolume.mergeInto(source, target, FluidAmount.FluidMergeRounding.DEFAULT, Simulation.SIMULATE);
    }

    public static boolean mergeInto(FluidVolume source, FluidVolume target, FluidAmount.FluidMergeRounding rounding) {
        return FluidVolume.mergeInto(source, target, rounding, Simulation.SIMULATE);
    }

    public static boolean mergeInto(FluidVolume source, FluidVolume target, FluidAmount.FluidMergeRounding rounding, Simulation simulation) {
        if (source.isEmpty() || target.isEmpty()) {
            return false;
        }
        if (source.getFluidKey() != target.getFluidKey()) {
            return false;
        }
        return source.merge(target, rounding, simulation);
    }

    @Nullable
    public static FluidVolume merge(FluidVolume a, FluidVolume b) {
        return FluidVolume.merge(a, b, FluidAmount.FluidMergeRounding.DEFAULT);
    }

    @Nullable
    public static FluidVolume merge(FluidVolume a, FluidVolume b, FluidAmount.FluidMergeRounding rounding) {
        if (a.isEmpty()) {
            if (b.isEmpty()) {
                return FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);
            }
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.merge(b, rounding, Simulation.ACTION)) {
            return a;
        }
        return null;
    }

    public final boolean canMerge(FluidVolume with) {
        if (this.isEmpty() || with.isEmpty()) {
            return false;
        }
        return this.merge(with, Simulation.SIMULATE);
    }

    public final boolean merge(FluidVolume other, Simulation simulation) {
        return this.merge(other, FluidAmount.FluidMergeRounding.ROUND_HALF_EVEN, simulation);
    }

    public final boolean merge(FluidVolume other, FluidAmount.FluidMergeRounding rounding, Simulation simulation) {
        if (this.isEmpty() || other.isEmpty()) {
            throw new IllegalArgumentException("Don't try to merge two empty fluids!");
        }
        if (this.getClass() != other.getClass() || !Objects.equals(this.fluidKey, other.fluidKey)) {
            return false;
        }
        if (simulation == Simulation.ACTION) {
            FluidAmount.FluidMergeResult merged = FluidAmount.merge(this.getAmount_F(), other.getAmount_F(), rounding);
            Object[] result = null;
            if (this.propertyValues != null || other.propertyValues != null) {
                int count = this.fluidKey.properties.size();
                for (int index = 0; index < count; ++index) {
                    Object valueOther;
                    Object value;
                    FluidProperty<?> prop = this.fluidKey.properties.get(index);
                    Object object = value = this.propertyValues != null ? this.propertyValues[index] : null;
                    if (value == null) {
                        value = prop.defaultValue;
                    }
                    Object object2 = valueOther = other.propertyValues != null ? other.propertyValues[index] : null;
                    if (valueOther == null) {
                        valueOther = prop.defaultValue;
                    }
                    if (value != valueOther) {
                        value = this.mergeGenericBypass(other, merged, prop, value, valueOther);
                    }
                    if (value == prop.defaultValue) continue;
                    if (result == null) {
                        result = new Object[count];
                    }
                    result[index] = value;
                }
            }
            this.propertyValues = result;
            this.merge0(other, rounding);
        }
        return true;
    }

    private <T> T mergeGenericBypass(FluidVolume other, FluidAmount.FluidMergeResult merged, FluidProperty<T> prop, Object value, Object valueOther) {
        Object valA = prop.type.cast(value);
        Object valB = prop.type.cast(valueOther);
        return prop.merge(this, other, merged.merged, valA, valB);
    }

    @Deprecated(since="0.7.0", forRemoval=true)
    protected void merge0(FluidVolume other, FluidAmount.FluidMergeRounding rounding) {
        this.mergeInternal(other, FluidAmount.merge(this.getAmount_F(), other.getAmount_F(), rounding));
    }

    protected void mergeInternal(FluidVolume other, FluidAmount.FluidMergeResult mergedAmounts) {
        this.setAmount(mergedAmounts.merged);
        other.setAmount(mergedAmounts.excess);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public final FluidVolume split(int toRemove) {
        return this.split(FluidAmount.of1620(toRemove));
    }

    public final FluidVolume split(FluidAmount toRemove) {
        return this.split(toRemove, RoundingMode.HALF_EVEN);
    }

    public final FluidVolume split(FluidAmount toRemove, RoundingMode rounding) {
        if (toRemove.isNegative()) {
            throw new IllegalArgumentException("Cannot split off a negative amount!");
        }
        if (toRemove.isZero() || this.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        if (toRemove.isGreaterThan(this.amount)) {
            toRemove = this.amount;
        }
        FluidVolume split = this.split0(toRemove, rounding);
        this.copyPropertiesInto(split);
        return split;
    }

    protected FluidVolume split0(FluidAmount toTake, RoundingMode rounding) {
        this.setAmount(this.getAmount_F().roundedSub(toTake, rounding));
        return this.getFluidKey().withAmount(toTake);
    }

    public final <T> T getProperty(FluidProperty<T> property) {
        int index = this.fluidKey.propertyKeys.getOrDefault(property, -1);
        if (index < 0) {
            throw new IllegalArgumentException("Unknown/unregistered property " + property + " for key " + this.fluidKey);
        }
        if (this.propertyValues == null || this.propertyValues.length <= index) {
            return property.defaultValue;
        }
        Object value = this.propertyValues[index];
        if (value == null) {
            return property.defaultValue;
        }
        if (property.type.isInstance(value)) {
            return property.type.cast(value);
        }
        throw new IllegalStateException("The value in the propertyValues array (" + value.getClass() + " wasn't an instance of the required " + property.type + ")");
    }

    private final <T> void putPropertyValue(FluidProperty<T> property, Object value) {
        this.setProperty(property, property.type.cast(value));
    }

    public final <T> void setProperty(FluidProperty<T> property, T value) {
        int index = this.fluidKey.propertyKeys.getOrDefault(property, -1);
        if (index < 0) {
            throw new IllegalArgumentException("Unknown/unregistered property " + property + " for key " + this.fluidKey);
        }
        if (value == null || value == property.defaultValue) {
            value = null;
            if (this.propertyValues == null) {
                return;
            }
            if (this.propertyValues.length < index + 1) {
                return;
            }
        } else if (this.propertyValues == null) {
            this.propertyValues = new Object[index + 1];
        } else if (this.propertyValues.length < index + 1) {
            this.propertyValues = Arrays.copyOf(this.propertyValues, index + 1);
        }
        this.propertyValues[index] = value;
    }

    public class_2960 getSprite() {
        return this.getFluidKey().spriteId;
    }

    public final class_2960 getStillSprite() {
        return this.getSprite();
    }

    public class_2960 getFlowingSprite() {
        return this.getFluidKey().flowingSpriteId;
    }

    public int getRenderColor() {
        FluidRenderHandler handler;
        class_3611 raw;
        if (this.fluidKey.useFallbackRenderColor && (raw = this.getRawFluid()) != null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && (handler = FluidRenderHandlerRegistry.INSTANCE.get(raw)) != null) {
            return handler.getFluidColor(null, null, raw.method_15785());
        }
        return this.getFluidKey().renderColor;
    }

    public class_2561 getName() {
        return this.getFluidKey().name;
    }

    @Deprecated(since="0.7.0", forRemoval=true)
    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTooltipText(class_1836 ctx) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add(this.getName());
        if (ctx.method_8035()) {
            FluidEntry entry = this.getFluidKey().entry;
            list.add((class_2561)new class_2585(entry.getRegistryInternalName()).method_27692(class_124.field_1063));
            list.add((class_2561)new class_2585(entry.getId().toString()).method_27692(class_124.field_1063));
        }
        return list;
    }

    public final List<class_2561> getFullTooltip() {
        return this.getFullTooltip(null, FluidTooltipContext.USE_CONFIG);
    }

    public final void addFullTooltip(List<class_2561> tooltip) {
        this.addFullTooltip(null, FluidTooltipContext.USE_CONFIG, tooltip);
    }

    public final List<class_2561> getFullTooltip(@Nullable FluidAmount capacity) {
        return this.getFullTooltip(capacity, FluidTooltipContext.USE_CONFIG);
    }

    public final void addFullTooltip(@Nullable FluidAmount capacity, List<class_2561> tooltip) {
        this.addFullTooltip(capacity, FluidTooltipContext.USE_CONFIG, tooltip);
    }

    public final List<class_2561> getFullTooltip(@Nullable FluidAmount capacity, FluidTooltipContext context) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.addFullTooltip(capacity, context, tooltip);
        return tooltip;
    }

    public final void addFullTooltip(@Nullable FluidAmount capacity, FluidTooltipContext context, List<class_2561> tooltip) {
        this.addTooltipNameAmount(capacity, context, tooltip);
        this.addTooltipExtras(context, tooltip);
        this.addTooltipTemperature(context, tooltip);
        this.addTooltipProperties(context, tooltip);
    }

    public final void addTooltipNameAmount(@Nullable FluidAmount capacity, FluidTooltipContext context, List<class_2561> tooltip) {
        class_2561 name = context.stripFluidColours(this.getName());
        if (context.shouldJoinNameWithAmount()) {
            if (capacity != null) {
                tooltip.add(this.fluidKey.unitSet.getTank(this.amount, capacity, name, context));
            } else {
                tooltip.add(this.fluidKey.unitSet.getAmount(this.amount, name, context));
            }
        } else {
            tooltip.add(name);
            if (capacity != null) {
                tooltip.add(this.fluidKey.unitSet.getTank(this.amount, capacity, context));
            } else {
                tooltip.add(this.fluidKey.unitSet.getAmount(this.amount, context));
            }
        }
    }

    public void addTooltipExtras(FluidTooltipContext context, List<class_2561> tooltip) {
        this.fluidKey.addTooltipExtras(context, tooltip);
    }

    public final void addTooltipTemperature(FluidTooltipContext context, List<class_2561> tooltip) {
        FluidTemperature temp = this.fluidKey.getTemperature();
        if (temp != null) {
            temp.addTemperatureToTooltip(this, context, tooltip);
        }
    }

    public final void addTooltipProperties(FluidTooltipContext context, List<class_2561> tooltip) {
        for (FluidProperty<?> prop : this.fluidKey.properties) {
            prop.addTooltipExtras(this, context, tooltip);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public FluidVolumeRenderer getRenderer() {
        return DefaultFluidVolumeRenderer.INSTANCE;
    }

    @Environment(value=EnvType.CLIENT)
    public final void render(List<FluidRenderFace> faces, class_4597 vcp, class_4587 matrices) {
        this.getRenderer().render(this, faces, vcp, matrices);
    }

    @Environment(value=EnvType.CLIENT)
    public final void renderGuiRect(double x0, double y0, double x1, double y1) {
        this.getRenderer().renderGuiRectangle(this, x0, y0, x1, y1);
    }
}

