/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidUnit;
import alexiil.mc.lib.attributes.fluid.volume.FluidUnitBase;
import java.util.NavigableSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.class_2561;

public final class FluidUnitSet
extends FluidUnitBase {
    final NavigableSet<FluidUnit> units = new TreeSet<FluidUnit>();

    public FluidUnitSet copy() {
        FluidUnitSet copy = new FluidUnitSet();
        copy.units.addAll(this.units);
        return copy;
    }

    public void copyFrom(FluidUnitSet other) {
        this.units.addAll(other.units);
    }

    public boolean addUnit(FluidUnit unit) {
        return this.units.add(unit);
    }

    public FluidUnit getSmallestUnit() {
        return (FluidUnit)this.units.last();
    }

    public FluidUnit getLargestUnit() {
        return (FluidUnit)this.units.first();
    }

    @Override
    public String localizeAmount(FluidAmount amount, boolean forceLastSingular, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        if (this.units.isEmpty()) {
            return FluidUnit.BUCKET.localizeAmount(amount, forceLastSingular, fluidName, ctx);
        }
        if (amount.isZero()) {
            return this.getSmallestUnit().localizeAmount(amount, forceLastSingular, fluidName, ctx);
        }
        int unitCount = this.units.size();
        if (unitCount == 1) {
            return this.getSmallestUnit().localizeAmount(amount, forceLastSingular, fluidName, ctx);
        }
        String amt = this.localizeAmountInner(amount, forceLastSingular, ctx, FluidUnit::localizeUnit, FluidUnit::localizeDirect);
        if (fluidName != null && ctx.shouldJoinNameWithAmount()) {
            return FluidUnit.localizeDirect(FluidUnit.KEY_NAME, amt, FluidUnit.textToString(fluidName));
        }
        return amt;
    }

    @Override
    public class_2561 getAmount(FluidAmount amount, boolean forceLastSingular, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        if (this.units.isEmpty()) {
            return FluidUnit.BUCKET.getAmount(amount, forceLastSingular, fluidName, ctx);
        }
        if (amount.isZero()) {
            return this.getSmallestUnit().getAmount(amount, forceLastSingular, fluidName, ctx);
        }
        int unitCount = this.units.size();
        if (unitCount == 1) {
            return this.getSmallestUnit().getAmount(amount, forceLastSingular, fluidName, ctx);
        }
        class_2561 amt = this.localizeAmountInner(amount, forceLastSingular, ctx, FluidUnit::getUnit, FluidUnit::getDirect);
        if (fluidName != null && ctx.shouldJoinNameWithAmount()) {
            return FluidUnit.getDirect(FluidUnit.KEY_NAME, amt, ctx.stripFluidColours(fluidName));
        }
        return amt;
    }

    private <T> T localizeAmountInner(FluidAmount amount, boolean forceLastSingular, FluidTooltipContext ctx, UnitLocalizer<T> unitLocale, CombiningLocalizer<T> combiningLocale) {
        int unitCount = this.units.size();
        int usedCount = 0;
        FluidUnit[] usedUnits = new FluidUnit[unitCount];
        String[] perUnitAmounts = new String[unitCount];
        boolean[] isUnitSingular = new boolean[unitCount];
        for (FluidUnit unit : this.units) {
            if (unit == this.units.last()) {
                usedUnits[usedCount] = unit;
                perUnitAmounts[usedCount] = unit.format(amount);
                isUnitSingular[usedCount] = amount.equals(unit.unitAmount);
                ++usedCount;
                break;
            }
            FluidAmount sub = amount.roundedDiv(unit.unitAmount);
            if (sub.whole == 0L) continue;
            usedUnits[usedCount] = unit;
            perUnitAmounts[usedCount] = Long.toString(sub.whole);
            isUnitSingular[usedCount] = sub.whole == 1L;
            amount = FluidAmount.of(sub.numerator, sub.denominator).checkedMul(unit.unitAmount);
            ++usedCount;
            if (sub.numerator != 0L) continue;
            break;
        }
        if (forceLastSingular) {
            isUnitSingular[usedCount - 1] = true;
        }
        switch (usedCount) {
            case 0: {
                assert (false) : "usedCount should never be zero!";
                return combiningLocale.localize("ERROR: usedCount should never be zero! (for " + amount + " of " + this + ")", new Object[0]);
            }
            case 1: {
                return combiningLocale.localize(FluidUnit.KEY_AMOUNT, perUnitAmounts[0], unitLocale.localize(usedUnits[0], isUnitSingular[0], ctx));
            }
            case 2: {
                String a1 = perUnitAmounts[0];
                T u1 = unitLocale.localize(usedUnits[0], isUnitSingular[0], ctx);
                String a2 = perUnitAmounts[1];
                T u2 = unitLocale.localize(usedUnits[1], isUnitSingular[1], ctx);
                return combiningLocale.localize(FluidUnit.KEY_MULTI_UNIT_2, a1, u1, a2, u2);
            }
            case 3: {
                String a1 = perUnitAmounts[0];
                T u1 = unitLocale.localize(usedUnits[0], isUnitSingular[0], ctx);
                String a2 = perUnitAmounts[1];
                T u2 = unitLocale.localize(usedUnits[1], isUnitSingular[1], ctx);
                String a3 = perUnitAmounts[2];
                T u3 = unitLocale.localize(usedUnits[2], isUnitSingular[2], ctx);
                return combiningLocale.localize(FluidUnit.KEY_MULTI_UNIT_3, a1, u1, a2, u2, a3, u3);
            }
            case 4: {
                String a1 = perUnitAmounts[0];
                T u1 = unitLocale.localize(usedUnits[0], isUnitSingular[0], ctx);
                String a2 = perUnitAmounts[1];
                T u2 = unitLocale.localize(usedUnits[1], isUnitSingular[1], ctx);
                String a3 = perUnitAmounts[2];
                T u3 = unitLocale.localize(usedUnits[2], isUnitSingular[2], ctx);
                String a4 = perUnitAmounts[3];
                T u4 = unitLocale.localize(usedUnits[3], isUnitSingular[3], ctx);
                return combiningLocale.localize(FluidUnit.KEY_MULTI_UNIT_4, a1, u1, a2, u2, a3, u3, a4, u4);
            }
        }
        assert (usedCount > 4);
        T unit = unitLocale.localize(usedUnits[0], isUnitSingular[0], ctx);
        T soFar = combiningLocale.localize(FluidUnit.KEY_AMOUNT, perUnitAmounts[0], unit);
        int end = usedCount - 1;
        for (int i = 1; i < end; ++i) {
            String a = perUnitAmounts[i];
            T u = unitLocale.localize(usedUnits[i], isUnitSingular[i], ctx);
            soFar = combiningLocale.localize(FluidUnit.KEY_MULTI_UNIT_COMBINER, soFar, a, u);
        }
        String endAmount = perUnitAmounts[end];
        T endUnit = unitLocale.localize(usedUnits[end], isUnitSingular[end], ctx);
        return combiningLocale.localize(FluidUnit.KEY_MULTI_UNIT_END, soFar, endAmount, endUnit);
    }

    @Override
    public String localizeEmptyTank(FluidAmount capacity, FluidTooltipContext ctx) {
        return FluidUnit.localizeDirect(FluidUnit.KEY_TANK_EMPTY.get(ctx), this.localizeAmount(capacity, true, ctx));
    }

    @Override
    public class_2561 getEmptyTank(FluidAmount capacity, FluidTooltipContext ctx) {
        return FluidUnit.getDirect(FluidUnit.KEY_TANK_EMPTY.get(ctx), this.getAmount(capacity, true, ctx));
    }

    @Override
    public String localizeFullTank(FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return FluidUnit.localizeDirect(FluidUnit.KEY_TANK_FULL.get(ctx), this.localizeAmount(capacity, true, fluidName, ctx));
    }

    @Override
    public class_2561 getFullTank(FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return FluidUnit.getDirect(FluidUnit.KEY_TANK_FULL.get(ctx), this.getAmount(capacity, true, fluidName, ctx));
    }

    @Override
    public String localizePartialTank(FluidAmount amount, FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        if (this.units.isEmpty()) {
            return FluidUnit.BUCKET.localizeTank(amount, capacity, ctx);
        }
        if (amount.isZero() && capacity.isZero() || this.units.size() == 1) {
            return this.getSmallestUnit().localizeTank(amount, capacity, ctx);
        }
        String key = FluidUnit.KEY_TANK_MULTI_UNIT.get(ctx);
        return FluidUnit.localizeDirect(key, this.localizeAmount(amount, ctx), this.localizeAmount(capacity, true, ctx));
    }

    @Override
    public class_2561 getPartialTank(FluidAmount amount, FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        if (this.units.isEmpty()) {
            return FluidUnit.BUCKET.getPartialTank(amount, capacity, ctx);
        }
        if (amount.isZero() && capacity.isZero() || this.units.size() == 1) {
            return this.getSmallestUnit().getPartialTank(amount, capacity, ctx);
        }
        String key = FluidUnit.KEY_TANK_MULTI_UNIT.get(ctx);
        return FluidUnit.getDirect(key, this.getAmount(amount, ctx), this.getAmount(capacity, true, ctx));
    }

    @Override
    public String localizeFlowRate(FluidAmount amountPerTick, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return this.getSmallestUnit().localizeFlowRate(amountPerTick, ctx);
    }

    @Override
    public class_2561 getFlowRate(FluidAmount amountPerTick, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return this.getSmallestUnit().getFlowRate(amountPerTick, ctx);
    }

    private static interface UnitLocalizer<T> {
        public T localize(FluidUnit var1, boolean var2, FluidTooltipContext var3);
    }

    private static interface CombiningLocalizer<T> {
        public T localize(String var1, Object ... var2);
    }
}

