/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidUnitBase;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public final class FluidUnit
extends FluidUnitBase
implements Comparable<FluidUnit> {
    public static final String LOCALE_KEY_PREFIX = "libblockattributes.fluid_unit.";
    public static final String LOCALE_KEY_SUFFIX_SINGLE = ".singular";
    public static final String LOCALE_KEY_SUFFIX_MULTIPLE = ".plural";
    public static final String LOCALE_KEY_SUFFIX_SYMBOL = ".symbol";
    public static final FluidUnit BUCKET = new FluidUnit(FluidAmount.BUCKET, "bucket");
    public static final FluidUnit BOTTLE = new FluidUnit(FluidAmount.BOTTLE, "bottle");
    static final String KEY_AMOUNT = FluidUnit.key("fluid.amount");
    static final String KEY_NAME = FluidUnit.key("fluid.name");
    static final LsLocaleKey KEY_FLOW_RATE = FluidUnit.duel("fluid.flow_rate");
    static final LsLocaleKey KEY_TANK_EMPTY = FluidUnit.duel("fluid.tank_empty");
    static final LsLocaleKey KEY_TANK_FULL = FluidUnit.duel("fluid.tank_full");
    static final LsLocaleKey KEY_TANK_PARTIAL = FluidUnit.duel("fluid.tank_partial");
    static final LsLocaleKey KEY_TANK_MULTI_UNIT = FluidUnit.duel("fluid.tank_multi_unit");
    static final String KEY_MULTI_UNIT_2 = FluidUnit.key("fluid.multi_unit.2");
    static final String KEY_MULTI_UNIT_3 = FluidUnit.key("fluid.multi_unit.3");
    static final String KEY_MULTI_UNIT_4 = FluidUnit.key("fluid.multi_unit.4");
    static final String KEY_MULTI_UNIT_COMBINER = FluidUnit.key("fluid.multi_unit.combiner");
    static final String KEY_MULTI_UNIT_END = FluidUnit.key("fluid.multi_unit.end");
    static final SpsLocaleKey KEY_TICK = FluidUnit.triple("time_unit.tick");
    static final SpsLocaleKey KEY_SECOND = FluidUnit.triple("time_unit.second");
    final FluidAmount unitAmount;
    final SpsLocaleKey unitKey;

    @Deprecated(since="0.6.4", forRemoval=true)
    public FluidUnit(int unitAmount, String key) {
        this(FluidAmount.of1620(unitAmount), key);
    }

    public FluidUnit(FluidAmount unitAmount, String key) {
        if (!unitAmount.isPositive()) {
            throw new IllegalArgumentException("Unit Amount must be a positive number!");
        }
        this.unitAmount = unitAmount;
        this.unitKey = new SpsLocaleKey(LOCALE_KEY_PREFIX + key);
    }

    @Override
    public String localizeAmount(FluidAmount amount, boolean forceSingular, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        String str = this.localize(KEY_AMOUNT, forceSingular ? true : amount.equals(this.unitAmount), amount, ctx);
        if (fluidName != null && ctx.shouldJoinNameWithAmount()) {
            str = FluidUnit.localizeDirect(KEY_NAME, str, FluidUnit.textToString(fluidName));
        }
        return str;
    }

    @Override
    public class_2561 getAmount(FluidAmount amount, boolean forceSingular, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        class_2561 txt = this.get(KEY_AMOUNT, forceSingular || amount.equals(this.unitAmount), amount, ctx);
        if (fluidName != null && ctx.shouldJoinNameWithAmount()) {
            txt = FluidUnit.getDirect(KEY_NAME, txt, ctx.stripFluidColours(fluidName));
        }
        return txt;
    }

    @Override
    public String localizeEmptyTank(FluidAmount capacity, FluidTooltipContext ctx) {
        return FluidUnit.localizeDirect(KEY_TANK_EMPTY.get(ctx), this.localizeAmount(capacity, !ctx.shouldUseShortDescription(), ctx));
    }

    @Override
    public class_2561 getEmptyTank(FluidAmount capacity, FluidTooltipContext ctx) {
        return FluidUnit.getDirect(KEY_TANK_EMPTY.get(ctx), this.getAmount(capacity, !ctx.shouldUseShortDescription(), ctx));
    }

    @Override
    public String localizeFullTank(FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return FluidUnit.localizeDirect(KEY_TANK_FULL.get(ctx), this.localizeAmount(capacity, true, ctx));
    }

    @Override
    public class_2561 getFullTank(FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return FluidUnit.getDirect(KEY_TANK_FULL.get(ctx), this.getAmount(capacity, true, ctx));
    }

    @Override
    public String localizePartialTank(FluidAmount amount, FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        String strAmount = this.localizeAmount(amount, fluidName, ctx);
        String strCapacity = this.localizeAmount(capacity, true, ctx);
        return FluidUnit.localizeDirect(KEY_TANK_PARTIAL.get(ctx), strAmount, strCapacity);
    }

    @Override
    public class_2561 getPartialTank(FluidAmount amount, FluidAmount capacity, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        return FluidUnit.getDirect(KEY_TANK_PARTIAL.get(ctx), this.getAmount(amount, fluidName, ctx), this.getAmount(capacity, true, ctx));
    }

    @Override
    public String localizeFlowRate(FluidAmount amountPerTick, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        FluidAmount rate = amountPerTick.roundedDiv(ctx.getTimeGap());
        String translatedUnit = this.localizeUnit(rate.equals(this.unitAmount), ctx);
        String format = this.format(rate);
        String timeKey = (ctx.shouldUseTicks() ? KEY_TICK : KEY_SECOND).get(false, ctx);
        String time = class_2477.method_10517().method_4679(timeKey);
        return FluidUnit.localizeDirect(KEY_FLOW_RATE.get(ctx), FluidUnit.localizeDirect(KEY_AMOUNT, format, translatedUnit), time);
    }

    @Override
    public class_2561 getFlowRate(FluidAmount amountPerTick, @Nullable class_2561 fluidName, FluidTooltipContext ctx) {
        FluidAmount rate = amountPerTick.roundedDiv(ctx.getTimeGap());
        class_2561 unit = this.getUnit(rate.equals(this.unitAmount), ctx);
        String format = this.format(rate);
        String timeKey = (ctx.shouldUseTicks() ? KEY_TICK : KEY_SECOND).get(false, ctx);
        class_2561 time = FluidUnit.toText(timeKey, new Object[0]);
        return FluidUnit.getDirect(KEY_FLOW_RATE.get(ctx), FluidUnit.localizeDirect(KEY_AMOUNT, format, unit), time);
    }

    String localize(String key, boolean isSingular, FluidAmount number, FluidTooltipContext ctx) {
        String translatedUnit = this.localizeUnit(isSingular, ctx);
        String format = this.format(number);
        return FluidUnit.localizeDirect(key, format, translatedUnit);
    }

    class_2561 get(String key, boolean isSingular, FluidAmount number, FluidTooltipContext ctx) {
        class_2561 unit = this.getUnit(isSingular, ctx);
        String format = this.format(number);
        return FluidUnit.getDirect(key, format, unit);
    }

    String localizeUnit(boolean isSingular, FluidTooltipContext ctx) {
        return class_2477.method_10517().method_4679(this.unitKey.get(isSingular, ctx));
    }

    class_2561 getUnit(boolean isSingular, FluidTooltipContext ctx) {
        return FluidUnit.toText(this.unitKey.get(isSingular, ctx), new Object[0]);
    }

    static String localizeDirect(String localeKey, Object ... args) {
        String translatedKey = class_2477.method_10517().method_4679(localeKey);
        if (translatedKey == localeKey) {
            return localeKey + " " + Arrays.toString(args);
        }
        boolean check = false;
        if (!$assertionsDisabled) {
            check = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (check) {
            for (int i = 0; i < args.length; ++i) {
                Object[] arr = new Object[i];
                Arrays.fill(arr, "~ESC~");
                try {
                    String.format(translatedKey, arr);
                }
                catch (IllegalFormatException ignored) {
                    continue;
                }
                throw new IllegalStateException("The key '" + localeKey + "' doesn't use all of the arguments " + Arrays.toString(args));
            }
        }
        try {
            return String.format(translatedKey, args);
        }
        catch (IllegalFormatException ife) {
            return localeKey + " " + Arrays.toString(args) + " " + ife.getMessage();
        }
    }

    static class_2561 getDirect(String localeKey, Object ... args) {
        return FluidUnit.toText(localeKey, args);
    }

    String format(FluidAmount number) {
        return number.roundedDiv(this.unitAmount).toDisplayString();
    }

    private static class_2561 toText(String key, Object ... args) {
        return new class_2588(key, args);
    }

    @Override
    public int compareTo(FluidUnit o) {
        return o.unitAmount.compareTo(this.unitAmount);
    }

    private static String key(String suffix) {
        return "libblockattributes." + suffix;
    }

    private static LsLocaleKey duel(String suffix) {
        return new LsLocaleKey(FluidUnit.key(suffix));
    }

    private static SpsLocaleKey triple(String suffix) {
        return new SpsLocaleKey(FluidUnit.key(suffix));
    }

    static String textToString(class_2561 text) {
        StringBuilder sb = new StringBuilder();
        text.method_27657(s -> {
            sb.append(s);
            return Optional.empty();
        });
        return sb.toString();
    }

    static final class SpsLocaleKey {
        final String keySingular;
        final String keyPlural;
        final String keySymbol;

        public SpsLocaleKey(String keyPrefix) {
            this.keySingular = keyPrefix + FluidUnit.LOCALE_KEY_SUFFIX_SINGLE;
            this.keyPlural = keyPrefix + FluidUnit.LOCALE_KEY_SUFFIX_MULTIPLE;
            this.keySymbol = keyPrefix + FluidUnit.LOCALE_KEY_SUFFIX_SYMBOL;
        }

        String get(boolean singular, FluidTooltipContext ctx) {
            return ctx.shouldUseSymbols() ? this.keySymbol : (singular ? this.keySingular : this.keyPlural);
        }
    }

    static final class LsLocaleKey {
        final String keyLong;
        final String keyShort;

        LsLocaleKey(String keyPrefix) {
            this.keyLong = keyPrefix + ".long";
            this.keyShort = keyPrefix + ".short";
        }

        String get(FluidTooltipContext ctx) {
            return ctx.shouldUseShortDescription() ? this.keyShort : this.keyLong;
        }
    }
}

