/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.LbaFluidsConfig;
import alexiil.mc.lib.attributes.fluid.init.LbaFluidProxy;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2585;

public final class FluidTooltipContext {
    private static final int VALUE_FLAGS = 3;
    private static final int VALUE_USE_CONFIG = 0;
    private static final int VALUE_ENABLED = 2;
    private static final int VALUE_DISABLED = 3;
    private static final int OFFSET_ADVANCED = 0;
    private static final int OFFSET_SYMBOLS = 2;
    private static final int OFFSET_TICKS = 4;
    private static final int OFFSET_SHORT_DESC = 6;
    private static final int OFFSET_DISABLE_FLUID_COLOURS = 8;
    private static final int OFFSET_DISABLE_EMPHASIS_COLOURS = 10;
    private static final int OFFSET_JOIN_NAME_AMOUNT = 12;
    public static final FluidTooltipContext USE_CONFIG = new FluidTooltipContext(0L);
    private final long options;

    private FluidTooltipContext(long values) {
        this.options = values;
    }

    public static FluidTooltipContext fromMinecraft(class_1836 ctx) {
        return USE_CONFIG.forceAdvanced(ctx.method_8035());
    }

    public boolean isAdvanced() {
        long o = this.options >> 0 & 3L;
        if (o != 0L) {
            return o == 2L;
        }
        return LbaFluidProxy.MC_TOOLTIPS_ADVANCED.getAsBoolean();
    }

    public boolean shouldUseSymbols() {
        return this.get(2, LbaFluidsConfig.USE_SYMBOLS);
    }

    public boolean shouldUseTicks() {
        return this.get(4, LbaFluidsConfig.USE_TICKS);
    }

    public int getTimeGap() {
        return this.shouldUseTicks() ? 1 : 20;
    }

    public boolean shouldUseShortDescription() {
        return this.get(6, LbaFluidsConfig.USE_SHORT_DESC);
    }

    public boolean shouldStripFluidColours() {
        return this.get(8, LbaFluidsConfig.DISABLE_FLUID_COLOURS);
    }

    public boolean shouldDisableEmphasisColours() {
        return this.get(10, LbaFluidsConfig.DISABLE_EMPHASIS_COLOURS);
    }

    public boolean shouldJoinNameWithAmount() {
        return this.get(12, LbaFluidsConfig.TOOLTIP_JOIN_NAME_AMOUNT);
    }

    private boolean get(int offset, boolean config) {
        long o = this.options >> offset & 3L;
        if (o != 0L) {
            return o == 2L;
        }
        return config;
    }

    public FluidTooltipContext usingMcAdvanced() {
        return this.withConfig(0);
    }

    public FluidTooltipContext forceAdvanced(boolean enable) {
        return this.withForced(0, enable);
    }

    public FluidTooltipContext usingConfigForSymbols() {
        return this.withConfig(2);
    }

    public FluidTooltipContext forceSymbols(boolean enable) {
        return this.withForced(2, enable);
    }

    public FluidTooltipContext usingConfigForTicks() {
        return this.withConfig(4);
    }

    public FluidTooltipContext forceTicks(boolean enable) {
        return this.withForced(4, enable);
    }

    public FluidTooltipContext usingConfigForShortDesc() {
        return this.withConfig(6);
    }

    public FluidTooltipContext forceShortDesc(boolean enable) {
        return this.withForced(6, enable);
    }

    public FluidTooltipContext usingConfigForFluidColours() {
        return this.withConfig(8);
    }

    public FluidTooltipContext forceDisableFluidColours(boolean disable) {
        return this.withForced(8, disable);
    }

    public FluidTooltipContext usingConfigForEmphasisColours() {
        return this.withConfig(10);
    }

    public FluidTooltipContext forceDisableEmphasisColours(boolean disable) {
        return this.withForced(10, disable);
    }

    public FluidTooltipContext usingConfigForJoinedName() {
        return this.withConfig(12);
    }

    public FluidTooltipContext forceJoinedName(boolean enable) {
        return this.withForced(12, enable);
    }

    private FluidTooltipContext withConfig(int offset) {
        long newOptions = this.options & (long)(~(3 << offset));
        return this.options == newOptions ? this : new FluidTooltipContext(newOptions);
    }

    private FluidTooltipContext withForced(int offset, boolean enable) {
        long cleared = this.options & (long)(~(3 << offset));
        long newOptions = cleared | (long)((enable ? 2 : 3) << offset);
        return this.options == newOptions ? this : new FluidTooltipContext(newOptions);
    }

    public class_2561 stripFluidColours(class_2561 fluidName) {
        if (this.shouldStripFluidColours()) {
            return new class_2585(fluidName.getString());
        }
        return fluidName;
    }
}

