/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.util.List;
import net.minecraft.class_2561;

public interface FluidTemperature {
    public double getTemperature(FluidVolume var1);

    default public void addTemperatureToTooltip(FluidKey fluid, FluidTooltipContext context, List<class_2561> tooltip) {
    }

    default public void addTemperatureToTooltip(FluidVolume fluid, FluidTooltipContext context, List<class_2561> tooltip) {
        this.addTemperatureToTooltip(fluid.fluidKey, context, tooltip);
    }

    public static void validate(FluidTemperature temperature) {
        if (temperature == null) {
            return;
        }
        boolean discrete = temperature instanceof DiscreteFluidTemperature;
        boolean cont = temperature instanceof ContinuousFluidTemperature;
        if (discrete & cont) {
            throw new IllegalStateException("The temperature " + temperature.getClass() + " implements both DiscreteFluidTemperature and ContinuousFluidTemperature, which it should only implement one!");
        }
        if (discrete == cont) {
            throw new IllegalStateException("The temperature " + temperature.getClass() + " must implement one of DiscreteFluidTemperature or ContinuousFluidTemperature, but it implements neither!");
        }
    }

    public static interface DiscreteFluidTemperature
    extends FluidTemperature {
        public double getTemperature(FluidKey var1);

        @Override
        default public double getTemperature(FluidVolume fluid) {
            return this.getTemperature(fluid.fluidKey);
        }
    }

    public static interface ContinuousFluidTemperature
    extends FluidTemperature {
        @Override
        public double getTemperature(FluidVolume var1);
    }
}

