/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public final class FluidRegistryEntry<T>
extends FluidEntry {
    final class_2378<T> backingRegistry;
    final T backingObject;
    final class_2960 objId;

    public FluidRegistryEntry(class_2348<T> backingRegistry, T backingObject) {
        this((class_2378<T>)backingRegistry, backingObject);
    }

    public FluidRegistryEntry(class_2378<T> backingRegistry, T backingObject) {
        this(backingRegistry, backingObject, backingRegistry.method_10221(backingObject));
    }

    private FluidRegistryEntry(class_2378<T> backingRegistry, T backingObject, class_2960 objId) {
        super(FluidRegistryEntry.computeHash(backingRegistry, backingObject, objId));
        if (backingRegistry == null) {
            throw new NullPointerException("backingRegistry");
        }
        if (backingObject == null) {
            throw new NullPointerException("backingObject");
        }
        if (FluidRegistryEntry.getName(backingRegistry) == null) {
            throw new IllegalArgumentException("You cannot use the " + backingRegistry + " with this because it's not registered with the main registry!");
        }
        this.backingRegistry = backingRegistry;
        this.backingObject = backingObject;
        this.objId = objId;
    }

    private static <T> int computeHash(class_2378<T> backingRegistry, T obj, class_2960 objId) {
        if (objId == null) {
            throw new IllegalArgumentException("You cannot use " + obj + " with this because it's not registered with " + backingRegistry + " registry!");
        }
        return System.identityHashCode(backingRegistry) * 31 + objId.hashCode();
    }

    public static String getName(class_2378<?> registry) {
        if (registry == class_2378.field_11154) {
            return "f";
        }
        if (registry == class_2378.field_11143) {
            return "p";
        }
        return FluidRegistryEntry.getFullRegistryName(registry).toString();
    }

    public static class_2960 getFullRegistryName(class_2378<?> registry) {
        class_2960 id = class_2378.field_11144.method_10221(registry);
        if (id == null) {
            throw new IllegalArgumentException("Unregistered registry: " + registry);
        }
        return id;
    }

    @Nullable
    public static class_2348<?> getRegistryFromName(String name) {
        if ("f".equals(name)) {
            return class_2378.field_11154;
        }
        if ("p".equals(name)) {
            return class_2378.field_11143;
        }
        class_2960 id = class_2960.method_12829((String)name);
        class_2378 registry = (class_2378)class_2378.field_11144.method_10223(id);
        if (registry instanceof class_2348) {
            return (class_2348)registry;
        }
        return null;
    }

    static <T> FluidRegistryEntry<T> fromTag0(class_2348<T> registry, String name) {
        Object obj = registry.method_10223(class_2960.method_12829((String)name));
        return new FluidRegistryEntry<Object>(registry, obj);
    }

    @Override
    public void toTag(class_2487 tag) {
        if (this.objId == null) {
            return;
        }
        if (this.backingRegistry instanceof class_2348 && this.objId.equals((Object)((class_2348)this.backingRegistry).method_10137())) {
            return;
        }
        tag.method_10582("Registry", FluidRegistryEntry.getName(this.backingRegistry));
        tag.method_10582("ObjName", this.objId.toString());
    }

    @Override
    public void toMcBuffer(class_2540 buffer) {
        if (this.backingRegistry == class_2378.field_11154) {
            buffer.writeByte(1);
        } else if (this.backingRegistry == class_2378.field_11143) {
            buffer.writeByte(2);
        } else {
            buffer.writeByte(3);
            buffer.method_10812(class_2378.field_11144.method_10221(this.backingRegistry));
        }
        buffer.method_10812(this.objId);
    }

    @Override
    public boolean isEmpty() {
        class_2960 id = this.getId();
        if (id == null) {
            return true;
        }
        return this.backingRegistry instanceof class_2348 && id.equals((Object)((class_2348)this.backingRegistry).method_10137());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    protected boolean equals(FluidEntry other) {
        FluidRegistryEntry re = (FluidRegistryEntry)other;
        return this.backingRegistry == re.backingRegistry && Objects.equals(this.getId(), other.getId());
    }

    public String toString() {
        return "{RegistryEntry " + this.getRegistryInternalName() + " " + this.getId() + "}";
    }

    @Override
    public String getRegistryInternalName() {
        return FluidRegistryEntry.getName(this.backingRegistry);
    }

    @Override
    public class_2960 getId() {
        return this.objId;
    }

    public class_2378<T> getBackingRegistry() {
        return this.backingRegistry;
    }

    public T getBackingObject() {
        return this.backingObject;
    }
}

