/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidTemperature;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonSyntaxException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public abstract class FluidProperty<T> {
    static final Comparator<FluidProperty<?>> COMPARATOR = (a, b) -> a.nbtKey.compareTo(b.nbtKey);
    public final class_2960 id;
    public final Class<T> type;
    public final T defaultValue;
    @Nullable
    public final FluidTemperature.ContinuousFluidTemperature temperature;
    final String nbtKey;

    public FluidProperty(class_2960 id, Class<T> type, T defaultValue) {
        this(id, type, defaultValue, null);
    }

    public FluidProperty(class_2960 id, Class<T> type, T defaultValue, FluidTemperature.ContinuousFluidTemperature temperature) {
        Objects.requireNonNull(id, "The identifier must not be null!");
        Objects.requireNonNull(type, "The type must not be null!");
        Objects.requireNonNull(defaultValue, "The default value shouldn't be null!");
        this.id = id;
        this.type = type;
        this.defaultValue = defaultValue;
        this.nbtKey = id.toString();
        if (this instanceof FluidTemperature) {
            if (temperature != null) {
                throw new IllegalArgumentException("The FluidProperty " + this.getClass() + " shouldn't implement FluidTemperature *and* pass a FluidTemperature!");
            }
            if (!(this instanceof FluidTemperature.ContinuousFluidTemperature)) {
                throw new IllegalStateException("The FluidProperty " + this.getClass() + " should implement ContinuousFluidTemperature!");
            }
            this.temperature = (FluidTemperature.ContinuousFluidTemperature)((Object)this);
        } else {
            this.temperature = temperature;
        }
        FluidTemperature.validate(this.temperature);
    }

    public final T get(FluidVolume volume) {
        return volume.getProperty(this);
    }

    public final void set(FluidVolume volume, T value) {
        volume.setProperty(this, value);
    }

    @Nullable
    protected abstract class_2520 toTag(T var1);

    protected abstract T fromTag(class_2520 var1);

    protected void writeToBuffer(class_2540 buffer, T value) {
        class_2520 tag = this.toTag(value);
        if (tag == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            class_2487 comp = new class_2487();
            comp.method_10566("k", tag);
            buffer.method_10794(comp);
        }
    }

    @Nullable
    protected T readFromBuffer(class_2540 buffer) {
        if (buffer.readBoolean()) {
            class_2520 tag;
            class_2487 comp = buffer.method_10798();
            class_2520 class_25202 = tag = comp != null ? comp.method_10580("k") : null;
            if (tag == null) {
                return null;
            }
            return this.fromTag(tag);
        }
        return null;
    }

    protected T fromJson(JsonElement json) throws JsonSyntaxException {
        return this.defaultValue;
    }

    protected JsonElement toJson(T value) {
        return JsonNull.INSTANCE;
    }

    protected abstract T merge(FluidVolume var1, FluidVolume var2, FluidAmount var3, T var4, T var5);

    public void addTooltipExtras(FluidKey fluid, FluidTooltipContext context, List<class_2561> tooltip) {
        if (context.isAdvanced()) {
            tooltip.add((class_2561)new class_2588("libblockattributes.fluid_property.advanced_prefix_key", new Object[]{this.nbtKey}));
        }
    }

    public void addTooltipExtras(FluidVolume fluid, FluidTooltipContext context, List<class_2561> tooltip) {
        if (context.isAdvanced()) {
            tooltip.add((class_2561)new class_2588("libblockattributes.fluid_property.advanced_prefix_value", new Object[]{this.get(fluid)}));
        }
    }
}

