/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.BiomeSourcedFluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeyCustomiser;
import alexiil.mc.lib.attributes.fluid.volume.FluidRegistryEntry;
import alexiil.mc.lib.attributes.fluid.volume.PotionFluidKey;
import alexiil.mc.lib.attributes.fluid.volume.SimpleFluidKey;
import alexiil.mc.lib.attributes.fluid.volume.WaterFluidKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public final class FluidKeys {
    public static final class_2960 MISSING_SPRITE = new class_2960("minecraft", "missingno");
    public static final FluidKey EMPTY;
    public static final FluidKey LAVA;
    public static final BiomeSourcedFluidKey WATER;
    private static final Map<class_3611, FluidKey> FLUIDS;
    private static final Map<class_1842, FluidKey> POTIONS;
    private static final Map<FluidRegistryEntry<?>, FluidKey> OTHERS;
    private static final Map<FluidEntry.FluidFloatingEntry, FluidKey> FLOATING;

    private FluidKeys() {
    }

    public static synchronized void put(class_3611 fluid, FluidKey fluidKey) {
        FLUIDS.put(fluid, fluidKey);
        if (fluid instanceof class_3609) {
            FLUIDS.put(((class_3609)fluid).method_15751(), fluidKey);
            FLUIDS.put(((class_3609)fluid).method_15750(), fluidKey);
        }
    }

    public static synchronized void put(class_1842 potion, FluidKey fluidKey) {
        POTIONS.put(potion, fluidKey);
    }

    public static synchronized void put(FluidRegistryEntry<?> entry, FluidKey fluidKey) {
        if (entry.backingRegistry == class_2378.field_11154) {
            FluidKeys.put((class_3611)entry.backingObject, fluidKey);
        } else if (entry.backingObject == class_2378.field_11143) {
            FluidKeys.put((class_1842)entry.backingObject, fluidKey);
        } else {
            OTHERS.put(entry, fluidKey);
        }
    }

    public static synchronized void put(FluidEntry.FluidFloatingEntry entry, FluidKey fluidKey) {
        FLOATING.put(entry, fluidKey);
    }

    @Deprecated(forRemoval=false)
    public static synchronized void remove(class_3611 fluid) {
        FLUIDS.remove(fluid);
    }

    public static synchronized FluidKey get(class_3611 fluid) {
        if (fluid == null) {
            return null;
        }
        FluidKey fluidKey = FLUIDS.get(fluid);
        if (fluidKey == null) {
            class_3609 base;
            if (fluid instanceof class_3609 && (fluid = (base = (class_3609)fluid).method_15751()) == null) {
                throw new IllegalStateException("fluid.getStill() returned a null fluid! (from " + fluid + ")");
            }
            fluidKey = FluidKeys.createImplicitFluid(fluid);
            FluidKeys.put(fluid, fluidKey);
        }
        return fluidKey;
    }

    private static SimpleFluidKey createImplicitFluid(class_3611 fluid) {
        class_2248 block = fluid.method_15785().method_15759().method_26204();
        class_2588 name = new class_2588(block.method_9539());
        FluidKey.FluidKeyBuilder builder = new FluidKey.FluidKeyBuilder(fluid).setName((class_2561)name);
        if (fluid instanceof FluidKeyCustomiser) {
            ((FluidKeyCustomiser)fluid).customiseKey(builder);
        }
        return new SimpleFluidKey(builder);
    }

    public static synchronized FluidKey get(class_1842 potion) {
        FluidKey fluidKey = POTIONS.get(potion);
        if (fluidKey == null) {
            fluidKey = new PotionFluidKey(potion);
            FluidKeys.put(potion, fluidKey);
        }
        return fluidKey;
    }

    @Nullable
    public static synchronized FluidKey get(FluidEntry entry) {
        if (entry instanceof FluidEntry.FluidFloatingEntry) {
            return FLOATING.get(entry);
        }
        if (entry instanceof FluidRegistryEntry) {
            FluidRegistryEntry re = (FluidRegistryEntry)entry;
            if (re.backingRegistry == class_2378.field_11143) {
                class_1842 potion = (class_1842)re.backingObject;
                return FluidKeys.get(potion);
            }
            if (re.backingRegistry == class_2378.field_11154) {
                class_3611 fluid = (class_3611)re.backingObject;
                return FluidKeys.get(fluid);
            }
            return OTHERS.get(re);
        }
        throw new IllegalArgumentException("Unknown FluidEntry " + entry.getClass());
    }

    public static synchronized Set<FluidRegistryEntry<?>> getRegistryFluidIds() {
        return new HashSet(OTHERS.keySet());
    }

    public static synchronized Set<FluidEntry.FluidFloatingEntry> getFloatingFluidIds() {
        return new HashSet<FluidEntry.FluidFloatingEntry>(FLOATING.keySet());
    }

    static {
        FLUIDS = new IdentityHashMap<class_3611, FluidKey>();
        POTIONS = new IdentityHashMap<class_1842, FluidKey>();
        OTHERS = new HashMap();
        FLOATING = new HashMap<FluidEntry.FluidFloatingEntry, FluidKey>();
        EMPTY = new SimpleFluidKey(new FluidKey.FluidKeyBuilder(class_3612.field_15906).setName((class_2561)new class_2588("libblockattributes.fluid.empty")));
        LAVA = new SimpleFluidKey(new FluidKey.FluidKeyBuilder((class_3611)class_3612.field_15908).setName((class_2561)new class_2588(class_2246.field_10164.method_9539()).method_10862(class_2583.field_24360.method_10977(class_124.field_1061))).setLuminosity(15).setViscosity(FluidAmount.of(30L, 5L)).setNetherViscosity(FluidAmount.of(10L, 5L)).setCohesion(FluidAmount.ofWhole(2L)).setNetherCohesion(FluidAmount.ofWhole(4L)));
        WATER = WaterFluidKey.INSTANCE;
        ((class_5250)FluidKeys.WATER.name).method_10862(class_2583.field_24360.method_10977(class_124.field_1078));
        FluidKeys.put(class_3612.field_15906, EMPTY);
        FluidKeys.put((class_3611)class_3612.field_15908, LAVA);
        FluidKeys.put((class_3611)class_3612.field_15910, (FluidKey)WATER);
        FluidKeys.put(class_1847.field_8984, EMPTY);
        FluidKeys.put(class_1847.field_8991, (FluidKey)WATER);
    }
}

