/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidProperty;
import alexiil.mc.lib.attributes.fluid.volume.FluidRegistryEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidTemperature;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidUnit;
import alexiil.mc.lib.attributes.fluid.volume.FluidUnitSet;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntSortedMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1842;
import net.minecraft.class_2338;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3576;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;

public abstract class FluidKey {
    public static final FluidAmount DEFAULT_GAS_VISCOSITY = FluidAmount.of(1L, 24L);
    public static final FluidAmount DEFAULT_GAS_COHESION = FluidAmount.of(1L, 24L);
    public static final FluidAmount DEFAULT_GAS_DENSITY = FluidAmount.of(1L, 160L);
    private static final class_2960 MISSING_SPRITE = new class_2960("minecraft", "missingno");
    public static final JsonDeserializer<FluidKey> DESERIALIZER = (json, type, ctx) -> {
        if (json.isJsonNull()) {
            return FluidKeys.EMPTY;
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            JsonObject wrapper = new JsonObject();
            wrapper.add("fluid", json);
            return FluidKey.fromJson(wrapper);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected " + json + " to be an object or a string!");
        }
        return FluidKey.fromJson(json.getAsJsonObject());
    };
    public final FluidEntry entry;
    @Deprecated(since="0.5.0", forRemoval=true)
    public final FluidUnit unit;
    public final FluidUnitSet unitSet;
    public final class_2960 spriteId;
    public final class_2960 flowingSpriteId;
    public final int renderColor;
    final boolean useFallbackRenderColor;
    public final class_2561 name;
    public final boolean gaseous;
    public final FluidAmount viscosity;
    public final FluidAmount netherViscosity;
    public final FluidAmount cohesion;
    public final FluidAmount netherCohesion;
    public final FluidAmount density;
    public final FluidAmount thermalCapacity;
    public final int luminosity;
    @Nullable
    private FluidTemperature temperature;
    @Nullable
    private final class_3611 rawFluid;
    final List<FluidProperty<?>> properties = new ArrayList();
    final Object2IntSortedMap<FluidProperty<?>> propertyKeys = new Object2IntAVLTreeMap(FluidProperty.COMPARATOR);
    public final ExactFluidFilter exactFilter = new ExactFluidFilter(this);

    public FluidKey(FluidKeyBuilder builder) {
        if (builder.entry == null) {
            throw new NullPointerException("The builder is missing the 'entry' property! Did you forget to call either 'setRegistryEntry' or 'setIdEntry'?");
        }
        if (builder.unit == null) {
            throw new NullPointerException("The builder is missing it's primary unit!");
        }
        if (builder.name == null) {
            throw new NullPointerException("The builder is missing it's name!");
        }
        this.entry = builder.entry;
        this.unit = builder.unit;
        this.unitSet = builder.unitSet.copy();
        this.unitSet.addUnit(builder.unit);
        this.spriteId = builder.spriteId != null ? builder.spriteId : MISSING_SPRITE;
        this.flowingSpriteId = builder.flowingSpriteId != null ? builder.flowingSpriteId : this.spriteId;
        this.name = builder.name;
        this.renderColor = builder.renderColor;
        this.useFallbackRenderColor = builder.useFallbackRenderColor;
        this.luminosity = builder.luminosity;
        this.rawFluid = builder.rawFluid;
        if (this.rawFluid != null) {
            if (this.rawFluid instanceof class_3576 && this.rawFluid != class_3612.field_15906) {
                throw new IllegalArgumentException("Different empty fluid!");
            }
            if (this.rawFluid instanceof class_3609 && this.rawFluid != ((class_3609)this.rawFluid).method_15751()) {
                throw new IllegalArgumentException("Only the still version of fluids are allowed!");
            }
        }
        this.gaseous = builder.gaseous;
        this.viscosity = builder.viscosity != null ? builder.viscosity : (this.gaseous ? DEFAULT_GAS_VISCOSITY : FluidAmount.ONE);
        FluidAmount fluidAmount = this.netherViscosity = builder.netherViscosity != null ? builder.netherViscosity : this.viscosity;
        if (this.viscosity.isNegative()) {
            throw new IllegalArgumentException("Negative viscosity is not allowed (" + this.viscosity + ")");
        }
        if (this.netherViscosity.isNegative()) {
            throw new IllegalArgumentException("Negative nether viscosity is not allowed (" + this.netherViscosity + ")");
        }
        this.cohesion = builder.cohesion != null ? builder.cohesion : (this.gaseous ? DEFAULT_GAS_COHESION : FluidAmount.ONE);
        FluidAmount fluidAmount2 = this.netherCohesion = builder.netherCohesion != null ? builder.netherCohesion : this.cohesion;
        if (this.netherCohesion.isNegative()) {
            throw new IllegalArgumentException("Negative nether cohesion is not allowed (" + this.netherCohesion + ")");
        }
        if (builder.density != null) {
            this.density = builder.density;
        } else {
            FluidAmount fluidAmount3 = this.density = this.gaseous ? DEFAULT_GAS_DENSITY : FluidAmount.ONE;
        }
        if (this.density.isNegative()) {
            throw new IllegalArgumentException("Negative density is not allowed (" + this.density + ")");
        }
        this.thermalCapacity = builder.thermalCapacity != null ? builder.thermalCapacity : this.density;
        if (this.thermalCapacity.isNegative()) {
            throw new IllegalArgumentException("Negative thermal capacity is not allowed (" + this.thermalCapacity + ")");
        }
        this.temperature = this instanceof FluidTemperature ? (FluidTemperature)((Object)this) : builder.temperature;
        FluidTemperature.validate(this.temperature);
        FluidKey.validateClass(this.getClass());
    }

    public static FluidKey fromTag(class_2487 tag) {
        if (tag.method_33133()) {
            return FluidKeys.EMPTY;
        }
        FluidKey fluidKey = FluidKeys.get(FluidEntry.fromTag(tag));
        if (fluidKey == null) {
            return FluidKeys.EMPTY;
        }
        return fluidKey;
    }

    public final class_2487 toTag() {
        return this.toTag(new class_2487());
    }

    public final class_2487 toTag(class_2487 tag) {
        if (this.isEmpty()) {
            return tag;
        }
        this.entry.toTag(tag);
        return tag;
    }

    public static FluidKey fromJson(JsonObject json) throws JsonSyntaxException {
        try {
            return FluidKey.fromJsonInternal(json);
        }
        catch (JsonSyntaxException jse) {
            throw new JsonSyntaxException("Not a valid fluid key: " + json, (Throwable)jse);
        }
    }

    public final JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.toJson(json);
        return json;
    }

    public final void toJson(JsonObject json) {
        if (this.entry instanceof FluidEntry.FluidFloatingEntry) {
            json.addProperty("floating_fluid", this.entry.getId().toString());
        } else {
            FluidRegistryEntry reg = (FluidRegistryEntry)this.entry;
            if (reg.backingRegistry == class_2378.field_11154) {
                json.addProperty("fluid", reg.getId().toString());
            } else if (reg.backingRegistry == class_2378.field_11143) {
                json.addProperty("potion", reg.getId().toString());
            } else {
                JsonObject sub = new JsonObject();
                json.add("fluid", (JsonElement)sub);
                sub.addProperty("registry", reg.getRegistryInternalName());
                sub.addProperty("id", reg.getId().toString());
            }
        }
        assert (this.equals(FluidKey.fromJson(json))) : json.toString();
    }

    public static FluidKey fromMcBuffer(class_2540 buffer) {
        if (!buffer.readBoolean()) {
            return FluidKeys.EMPTY;
        }
        return FluidKeys.get(FluidEntry.fromMcBuffer(buffer));
    }

    public final void toMcBuffer(class_2540 buffer) {
        if (this.isEmpty()) {
            buffer.writeBoolean(false);
            return;
        }
        buffer.writeBoolean(true);
        this.entry.toMcBuffer(buffer);
    }

    static FluidKey fromJsonInternal(JsonObject json) throws JsonSyntaxException {
        if (json.has("floating_fluid")) {
            if (json.has("potion") || json.has("fluid")) {
                throw new JsonSyntaxException("Expected only one of 'fluid' or 'potion' or 'floating_fluid', but got multiple!");
            }
            JsonElement j = json.get("floating_fluid");
            if (!j.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected 'floating_fluid' to be a string, but got " + j);
            }
            class_2960 id = FluidKey.getAsIdentifier(json.get("floating_fluid"), "floating_fluid");
            FluidEntry.FluidFloatingEntry entry = new FluidEntry.FluidFloatingEntry(id);
            FluidKey fluidKey = FluidKeys.get(entry);
            if (fluidKey == null) {
                throw FluidKey.throwBadEntryException("floating_fluid", "floating fluid identifier", "floating fluid identifiers", id.toString(), FluidKeys.getFloatingFluidIds());
            }
            return fluidKey;
        }
        if (json.has("potion")) {
            if (json.has("fluid")) {
                throw new JsonSyntaxException("Expected 'fluid' or 'potion' or 'floating_fluid', but got both! You should use one or the other, not both");
            }
            return FluidKeys.get((class_1842)FluidKey.getRegistryEntry(json.get("potion"), "potion", "potions", class_2378.field_11143));
        }
        if (json.has("fluid")) {
            JsonElement jFluid = json.get("fluid");
            if (!jFluid.isJsonObject()) {
                return FluidKeys.get((class_3611)FluidKey.getRegistryEntry(jFluid, "fluid", "fluids", class_2378.field_11154));
            }
            JsonObject obj = jFluid.getAsJsonObject();
            class_2378 reg = (class_2378)FluidKey.getRegistryEntry(obj.get("registry"), "registry", "registries", class_2378.field_11144);
            return FluidKey.fromRegistry(obj, reg);
        }
        throw new JsonSyntaxException("Expected 'fluid' or 'potion' or 'floating_fluid', but got nothing! (" + json + ")");
    }

    private static <T> FluidKey fromRegistry(JsonObject obj, class_2378<T> reg) {
        T entry = FluidKey.getRegistryEntry((JsonElement)obj, "id", "ids", reg);
        FluidRegistryEntry<T> fluidEntry = new FluidRegistryEntry<T>(reg, entry);
        FluidKey fluidKey = FluidKeys.get(fluidEntry);
        if (fluidKey == null) {
            throw FluidKey.throwBadEntryException("id", "ids", "ids", fluidEntry.getId().toString(), FluidKeys.getRegistryFluidIds());
        }
        return fluidKey;
    }

    private static <T> T getRegistryEntry(JsonElement json, String key, String keys, class_2378<T> registry) {
        if (json == null) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a string, but got nothing!");
        }
        class_2960 id = FluidKey.getAsIdentifier(json, key);
        Object value = registry.method_10223(id);
        if (value != null) {
            if (registry instanceof class_2348) {
                if (value != registry.method_10223(((class_2348)registry).method_10137())) {
                    return (T)value;
                }
            } else {
                return (T)value;
            }
        }
        throw FluidKey.throwBadEntryException(key, key, keys, id.toString(), registry.method_10235());
    }

    private static JsonSyntaxException throwBadEntryException(String key, String name, String keys, String found, Set<?> src) {
        StringBuilder error = new StringBuilder();
        error.append("Expected '");
        error.append(key);
        error.append("' to be a valid ");
        error.append(name);
        error.append(", but got '");
        error.append(found);
        int size = src.size();
        if (size == 0) {
            error.append("'(");
            error.append("no valid ");
            error.append(keys);
            error.append("!)");
            throw new JsonSyntaxException(error.toString());
        }
        error.append("'!\n\t(");
        error.append(size);
        error.append(" valid ");
        error.append(keys);
        error.append(":");
        Object[] dest = new Object[size];
        src.toArray(dest);
        for (int i = 0; i < dest.length; ++i) {
            if (dest[i] instanceof FluidEntry) {
                dest[i] = ((FluidEntry)dest[i]).getId();
            }
            dest[i] = dest[i].toString();
        }
        Arrays.sort(dest);
        for (Object str : dest) {
            error.append("\n\t - '");
            error.append(str);
            error.append("'");
        }
        error.append("\n)");
        throw new JsonSyntaxException(error.toString());
    }

    private static class_2960 getAsIdentifier(JsonElement json, String key) {
        if (!json.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a string, but got " + json);
        }
        String str = json.getAsJsonPrimitive().getAsString();
        if (!str.contains(":")) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a string with the " + key + " identifier, but got '" + str + "'!");
        }
        class_2960 id = class_2960.method_12829((String)str);
        if (id == null) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a valid identifier, but got '" + str + "'!");
        }
        return id;
    }

    public final void register() {
        if (this.entry instanceof FluidEntry.FluidFloatingEntry) {
            FluidKeys.put((FluidEntry.FluidFloatingEntry)this.entry, this);
        } else {
            FluidKeys.put((FluidRegistryEntry)this.entry, this);
        }
    }

    @Nullable
    public class_3611 getRawFluid() {
        return this.rawFluid;
    }

    public String toString() {
        return this.entry.toString();
    }

    public final FluidTemperature getTemperature() {
        return this.temperature;
    }

    @Nullable
    @CheckReturnValue
    public final String tryRegisterProperty(FluidProperty<?> property) {
        if (this.temperature != null && property.temperature != null) {
            return "Cannot have multiple temperature sources for this fluid! (\n\tFluidKey = " + this + ",\n\tFluidKey.temperature = " + this.temperature + ",\n\tFluidProperty = " + property + ",\n\tFluidProperty.temperature = " + property.temperature;
        }
        for (FluidProperty<?> existing : this.properties) {
            if (!existing.id.equals((Object)property.id)) continue;
            return "Tried to register multiple properties with an ID of " + existing.id + "!";
        }
        this.propertyKeys.put(property, this.properties.size());
        this.properties.add(property);
        if (this.temperature != null) {
            this.temperature = property.temperature;
        }
        return null;
    }

    public final void forceRegisterProperty(FluidProperty<?> property) {
        String error = this.tryRegisterProperty(property);
        if (error != null) {
            throw new IllegalStateException(error);
        }
    }

    public final SortedSet<FluidProperty<?>> getProperties() {
        return Collections.unmodifiableSortedSet(this.propertyKeys.keySet());
    }

    public abstract FluidVolume readVolume(class_2487 var1);

    public FluidVolume readVolume(JsonObject json) throws JsonSyntaxException {
        if (this.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        JsonElement amount = json.get("amount");
        if (amount == null) {
            return FluidVolumeUtil.EMPTY;
        }
        return this.withAmount(FluidVolume.parseAmount(amount));
    }

    public final FluidVolume readVolume(class_2540 buffer) {
        if (this.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        FluidAmount amount = FluidAmount.fromMcBuffer(buffer);
        FluidVolume volume = this.createFromMcBuffer(buffer, amount);
        volume.readProperties(buffer);
        return volume;
    }

    protected FluidVolume createFromMcBuffer(class_2540 buffer, FluidAmount amount) {
        FluidVolume volume = this.withAmount(amount);
        volume.fromMcBufferInternal(buffer);
        return volume;
    }

    public final boolean isEmpty() {
        return this == FluidKeys.EMPTY;
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public FluidVolume withAmount(int amount) {
        return this.withAmount(FluidAmount.of1620(amount));
    }

    public FluidVolume withAmount(FluidAmount amount) {
        FluidVolume vol = this.withAmount(amount.as1620());
        vol.setAmount(amount);
        return vol;
    }

    public FluidVolume fromWorld(class_4538 world, class_2338 pos) {
        return this.withAmount(FluidAmount.BUCKET);
    }

    public final List<class_2561> getFullTooltip() {
        return this.getFullTooltip(FluidTooltipContext.USE_CONFIG);
    }

    public final List<class_2561> getFullTooltip(FluidTooltipContext context) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.addFullTooltip(tooltip, context);
        return tooltip;
    }

    public final void addFullTooltip(List<class_2561> tooltip, FluidTooltipContext context) {
        if (!this.isEmpty()) {
            tooltip.add(context.stripFluidColours(this.name));
            this.addTooltipExtras(context, tooltip);
            this.addTooltipTemperature(context, tooltip);
            this.addTooltipProperties(context, tooltip);
        }
    }

    public final void addTooltipExtras(List<class_2561> tooltip) {
        this.addTooltipExtras(FluidTooltipContext.USE_CONFIG, tooltip);
    }

    public void addTooltipExtras(FluidTooltipContext context, List<class_2561> tooltip) {
        if (context.isAdvanced()) {
            tooltip.add((class_2561)new class_2585(this.entry.getRegistryInternalName()).method_27692(class_124.field_1063));
            tooltip.add((class_2561)new class_2585(this.entry.getId().toString()).method_27692(class_124.field_1063));
        }
    }

    public final void addTooltipTemperature(FluidTooltipContext context, List<class_2561> tooltip) {
        if (this.temperature != null) {
            this.temperature.addTemperatureToTooltip(this, context, tooltip);
        }
    }

    public final void addTooltipProperties(List<class_2561> tooltip) {
        this.addTooltipProperties(FluidTooltipContext.USE_CONFIG, tooltip);
    }

    public final void addTooltipProperties(FluidTooltipContext context, List<class_2561> tooltip) {
        for (FluidProperty<?> prop : this.properties) {
            prop.addTooltipExtras(this, context, tooltip);
        }
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    private static void validateClass(Class<? extends FluidKey> clazz) {
        try {
            Method amountOld = clazz.getMethod("withAmount", Integer.TYPE);
            Method amountNew = clazz.getMethod("withAmount", FluidAmount.class);
            if (amountOld.getDeclaringClass() == FluidKey.class && amountNew.getDeclaringClass() == FluidKey.class) {
                throw new IllegalStateException("The " + clazz + " must override at least 1 of {'FluidKey.withAmount(int)', or 'FluidKey.withAmount(FluidAmount)' }");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to find the methods during validation!", e);
        }
    }

    public static class FluidKeyBuilder {
        FluidEntry entry;
        class_2960 spriteId;
        class_2960 flowingSpriteId;
        class_2561 name;
        int renderColor = 0xFFFFFF;
        boolean useFallbackRenderColor = true;
        int luminosity = 0;
        FluidUnit unit = FluidUnit.BUCKET;
        final FluidUnitSet unitSet = new FluidUnitSet();
        class_3611 rawFluid;
        boolean gaseous = false;
        FluidAmount viscosity;
        FluidAmount netherViscosity;
        FluidAmount cohesion;
        FluidAmount netherCohesion;
        FluidAmount density;
        FluidAmount thermalCapacity;
        FluidTemperature temperature;

        @Deprecated(since="0.5.0", forRemoval=true)
        public FluidKeyBuilder(FluidRegistryEntry<?> registryEntry, class_2960 spriteId, class_2561 name) {
            this(registryEntry, spriteId, spriteId, name);
        }

        public FluidKeyBuilder(FluidRegistryEntry<?> registryEntry, class_2960 spriteId, class_2960 flowingSpriteId, class_2561 name) {
            this.entry = registryEntry;
            this.spriteId = spriteId;
            this.flowingSpriteId = flowingSpriteId;
            this.name = name;
        }

        public FluidKeyBuilder() {
        }

        public FluidKeyBuilder(class_2960 id) {
            this.setIdEntry(id);
        }

        public FluidKeyBuilder(class_3611 fluid) {
            this.entry = new FluidRegistryEntry<class_3611>(class_2378.field_11154, fluid);
            this.rawFluid = fluid;
        }

        public FluidKeyBuilder copyFrom(FluidKeyBuilder from) {
            this.entry = from.entry;
            this.spriteId = from.spriteId;
            this.flowingSpriteId = from.flowingSpriteId;
            this.name = from.name;
            this.renderColor = from.renderColor;
            this.unit = from.unit;
            this.unitSet.units.clear();
            this.unitSet.copyFrom(from.unitSet);
            this.rawFluid = from.rawFluid;
            this.gaseous = from.gaseous;
            this.viscosity = from.viscosity;
            this.netherViscosity = from.netherViscosity;
            this.cohesion = from.cohesion;
            this.netherCohesion = from.netherCohesion;
            this.density = from.density;
            this.thermalCapacity = from.thermalCapacity;
            return this;
        }

        public FluidKeyBuilder setRegistryEntry(FluidRegistryEntry<?> registryEntry) {
            this.entry = registryEntry;
            return this;
        }

        public FluidKeyBuilder setIdEntry(class_2960 id) {
            this.entry = new FluidEntry.FluidFloatingEntry(id);
            return this;
        }

        public FluidKeyBuilder setName(class_2561 name) {
            this.name = name;
            return this;
        }

        public FluidKeyBuilder setSprites(class_2960 stillSprite, class_2960 flowingSprite) {
            this.spriteId = stillSprite;
            this.flowingSpriteId = flowingSprite;
            return this;
        }

        public FluidKeyBuilder setRenderColor(int renderColor) {
            this.renderColor = renderColor;
            this.useFallbackRenderColor = false;
            return this;
        }

        public FluidKeyBuilder setLuminosity(int luminance) {
            this.luminosity = Math.max(0, Math.min(15, luminance));
            return this;
        }

        public FluidKeyBuilder setUnit(FluidUnit unit) {
            this.unit = unit;
            return this;
        }

        public FluidKeyBuilder addUnit(FluidUnit unit) {
            this.unitSet.addUnit(unit);
            return this;
        }

        public FluidKeyBuilder setRawFluid(class_3611 rawFluid) {
            this.rawFluid = rawFluid;
            return this;
        }

        public FluidKeyBuilder setGas() {
            this.gaseous = true;
            return this;
        }

        public FluidKeyBuilder setLiquid() {
            this.gaseous = false;
            return this;
        }

        public FluidKeyBuilder setViscosity(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative viscosity is not allowed! (" + to + ")");
            }
            this.viscosity = to;
            return this;
        }

        public FluidKeyBuilder setNetherViscosity(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative nether viscosity is not allowed! (" + to + ")");
            }
            this.netherViscosity = to;
            return this;
        }

        public FluidKeyBuilder setCohesion(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative cohesion is not allowed! (" + to + ")");
            }
            this.cohesion = to;
            return this;
        }

        public FluidKeyBuilder setNetherCohesion(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative nether cohesion is not allowed! (" + to + ")");
            }
            this.netherCohesion = to;
            return this;
        }

        public FluidKeyBuilder setDensity(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative density is not allowed! (" + to + ")");
            }
            this.density = to;
            return this;
        }

        public FluidKeyBuilder setThermalCapacity(FluidAmount to) {
            if (to != null && to.isNegative()) {
                throw new IllegalArgumentException("Negative thermal capacity is not allowed! (" + to + ")");
            }
            this.thermalCapacity = to;
            return this;
        }

        public FluidKeyBuilder setTemperature(FluidTemperature.DiscreteFluidTemperature temperature) {
            this.temperature = temperature;
            return this;
        }

        public FluidKeyBuilder setTemperature(FluidTemperature.ContinuousFluidTemperature temperature) {
            this.temperature = temperature;
            return this;
        }
    }
}

