/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidRegistryEntry;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public abstract class FluidEntry {
    static final String KEY_REGISTRY_TYPE = "Registry";
    static final String KEY_OBJ_IDENTIFIER = "ObjName";
    protected final int hash;

    FluidEntry(int hash) {
        this.hash = hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluidEntry other = (FluidEntry)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return this.equals(other);
    }

    protected abstract boolean equals(FluidEntry var1);

    public abstract void toTag(class_2487 var1);

    public static FluidEntry fromTag(class_2487 tag) {
        String str = tag.method_10558(KEY_REGISTRY_TYPE);
        if ("i".equals(str)) {
            class_2960 id = class_2960.method_12829((String)tag.method_10558(KEY_OBJ_IDENTIFIER));
            if (id == null) {
                return FluidKeys.EMPTY.entry;
            }
            return new FluidFloatingEntry(id);
        }
        class_2348 registry = FluidRegistryEntry.getRegistryFromName(str);
        if (registry == null) {
            registry = class_2378.field_11154;
        }
        String name = tag.method_10558(KEY_OBJ_IDENTIFIER);
        return FluidRegistryEntry.fromTag0(registry, name);
    }

    public abstract void toMcBuffer(class_2540 var1);

    public static FluidEntry fromMcBuffer(class_2540 buffer) {
        class_2348 registry;
        byte type = buffer.readByte();
        if (type == 0) {
            return new FluidFloatingEntry(buffer.method_10810());
        }
        if (type == 1) {
            registry = class_2378.field_11154;
        } else if (type == 2) {
            registry = class_2378.field_11143;
        } else {
            assert (type == 3) : "Unknown remote FluidEntry type " + type;
            class_2960 id = buffer.method_10810();
            registry = (class_2378)class_2378.field_11144.method_10223(id);
            if (registry == null) {
                throw new IllegalArgumentException("Unknown remote registry " + id);
            }
        }
        return FluidEntry.read0(buffer, registry);
    }

    private static <T> FluidEntry read0(class_2540 buffer, class_2378<T> registry) {
        class_2960 id = buffer.method_10810();
        Object obj = registry.method_10223(id);
        if (obj == null) {
            throw new IllegalArgumentException("Unknown remote object " + id + " in registry " + FluidRegistryEntry.getName(registry));
        }
        return new FluidRegistryEntry<Object>(registry, obj);
    }

    public abstract boolean isEmpty();

    public abstract String getRegistryInternalName();

    public abstract class_2960 getId();

    public static final class FluidFloatingEntry
    extends FluidEntry {
        public final class_2960 id;

        public FluidFloatingEntry(class_2960 id) {
            super(id.hashCode());
            this.id = id;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        protected boolean equals(FluidEntry other) {
            return this.id.equals((Object)((FluidFloatingEntry)other).id);
        }

        @Override
        public void toTag(class_2487 tag) {
            tag.method_10582(FluidEntry.KEY_REGISTRY_TYPE, "i");
            tag.method_10582(FluidEntry.KEY_OBJ_IDENTIFIER, this.id.toString());
        }

        @Override
        public void toMcBuffer(class_2540 buffer) {
            buffer.writeByte(0);
            buffer.method_10812(this.id);
        }

        public String toString() {
            return "{FluidFloatingEntry " + this.getId() + "}";
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public String getRegistryInternalName() {
            return "i";
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }
    }
}

