/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.ColouredFluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidTooltipContext;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.math.RoundingMode;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class ColouredFluidVolume
extends FluidVolume {
    float red;
    float green;
    float blue;
    float alpha;

    public ColouredFluidVolume(ColouredFluidKey key, FluidAmount amount) {
        super((FluidKey)key, amount);
        this.red = this.getFluidKey().defaultRed;
        this.green = this.getFluidKey().defaultGreen;
        this.blue = this.getFluidKey().defaultBlue;
        this.alpha = this.getFluidKey().defaultAlpha;
    }

    @Deprecated
    public ColouredFluidVolume(ColouredFluidKey key, int amount) {
        super((FluidKey)key, amount);
        this.red = this.getFluidKey().defaultRed;
        this.green = this.getFluidKey().defaultGreen;
        this.blue = this.getFluidKey().defaultBlue;
        this.alpha = this.getFluidKey().defaultAlpha;
    }

    public ColouredFluidVolume(ColouredFluidKey key, class_2487 tag) {
        super((FluidKey)key, tag);
        class_2499 list;
        this.red = this.getFluidKey().defaultRed;
        this.green = this.getFluidKey().defaultGreen;
        this.blue = this.getFluidKey().defaultBlue;
        this.alpha = this.getFluidKey().defaultAlpha;
        if (tag.method_10545("colour") && (list = tag.method_10554("colour", (int)class_2494.field_21034.method_10711())).size() == 4) {
            this.red = Math.max(key.minRed, Math.min(key.maxRed, list.method_10604(0)));
            this.green = Math.max(key.minGreen, Math.min(key.maxGreen, list.method_10604(1)));
            this.blue = Math.max(key.minBlue, Math.min(key.maxBlue, list.method_10604(2)));
            this.alpha = Math.max(key.minAlpha, Math.min(key.maxAlpha, list.method_10604(3)));
        }
    }

    @Override
    public class_2487 toTag(class_2487 nbt) {
        super.toTag(nbt);
        class_2499 list = new class_2499();
        list.add((Object)class_2494.method_23244((float)this.red));
        list.add((Object)class_2494.method_23244((float)this.green));
        list.add((Object)class_2494.method_23244((float)this.blue));
        list.add((Object)class_2494.method_23244((float)this.alpha));
        nbt.method_10566("colour", (class_2520)list);
        return nbt;
    }

    public ColouredFluidVolume(ColouredFluidKey key, JsonObject json) throws JsonSyntaxException {
        super((FluidKey)key, json);
        this.red = this.getFluidKey().defaultRed;
        this.green = this.getFluidKey().defaultGreen;
        this.blue = this.getFluidKey().defaultBlue;
        this.alpha = this.getFluidKey().defaultAlpha;
        JsonArray colour = class_3518.method_15292((JsonObject)json, (String)"color", (JsonArray)class_3518.method_15292((JsonObject)json, (String)"colour", (JsonArray)new JsonArray()));
        if (colour != null && (colour.size() == 3 || colour.size() == 4)) {
            float r = ColouredFluidVolume.getColourPart(colour, 0);
            float g = ColouredFluidVolume.getColourPart(colour, 1);
            float b = ColouredFluidVolume.getColourPart(colour, 2);
            float a = 1.0f;
            if (colour.size() == 4) {
                a = ColouredFluidVolume.getColourPart(colour, 3);
            }
            this.setRgba(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f);
        }
    }

    private static float getColourPart(JsonArray array, int index) {
        JsonElement elem = array.get(index);
        if (!elem.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected a primitive, but got " + elem + " at [" + index + "]");
        }
        JsonPrimitive p = elem.getAsJsonPrimitive();
        if (p.isNumber()) {
            return p.getAsFloat();
        }
        try {
            return p.getAsFloat();
        }
        catch (NumberFormatException nfe) {
            throw new JsonSyntaxException("Expected a valid float, but got " + elem + " at [" + index + "]");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonArray colour = new JsonArray();
        colour.add((Number)Float.valueOf(this.red * 255.0f));
        colour.add((Number)Float.valueOf(this.green * 255.0f));
        colour.add((Number)Float.valueOf(this.blue * 255.0f));
        colour.add((Number)Float.valueOf(this.alpha * 255.0f));
        json.add("colour", (JsonElement)colour);
        return json;
    }

    @Override
    protected void fromMcBufferInternal(class_2540 buffer) {
        super.fromMcBufferInternal(buffer);
        int argb = buffer.readInt();
        this.red = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.green = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(argb >> 0 & 0xFF) / 255.0f;
        this.alpha = (float)(argb >>> 24 & 0xFF) / 255.0f;
    }

    @Override
    protected void toMcBufferInternal(class_2540 buffer) {
        super.toMcBufferInternal(buffer);
        buffer.writeInt(this.asArgb());
    }

    @Override
    public ColouredFluidKey getFluidKey() {
        return (ColouredFluidKey)super.getFluidKey();
    }

    @Override
    public class_2561 getName() {
        class_5250 copy = super.getName().method_27662();
        float r = this.getRed();
        float g = this.getGreen();
        float b = this.getBlue();
        float a = this.getAlpha();
        if (a < 1.0f) {
            r = 1.0f - (1.0f - r) * a;
            g = 1.0f - (1.0f - g) * a;
            b = 1.0f - (1.0f - b) * a;
        }
        int rgb = Math.round(r * 255.0f) << 16 | Math.round(g * 255.0f) << 8 | Math.round(b * 255.0f) << 0;
        copy.method_10862(copy.method_10866().method_27703(class_5251.method_27717((int)rgb)));
        return copy;
    }

    public class_2561 getNoncolouredName() {
        return super.getName();
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getRenderColor() {
        return this.asArgb();
    }

    public final int asArgb() {
        return Math.round(this.getRed() * 255.0f) << 16 | Math.round(this.getGreen() * 255.0f) << 8 | Math.round(this.getBlue() * 255.0f) << 0 | Math.round(this.getAlpha() * 255.0f) << 24;
    }

    public void setArgb(int argb) {
        this.setRgba((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb >> 0 & 0xFF) / 255.0f, (float)(argb >>> 24 & 0xFF) / 255.0f);
    }

    public void setAbgr(int abgr) {
        this.setRgba((float)(abgr >> 0 & 0xFF) / 255.0f, (float)(abgr >> 8 & 0xFF) / 255.0f, (float)(abgr >> 16 & 0xFF) / 255.0f, (float)(abgr >>> 24 & 0xFF) / 255.0f);
    }

    public void setRgb(float red, float green, float blue) {
        ColouredFluidKey key = this.getFluidKey();
        this.red = Math.max(key.minRed, Math.min(key.maxRed, red));
        this.green = Math.max(key.minGreen, Math.min(key.maxGreen, green));
        this.blue = Math.max(key.minBlue, Math.min(key.maxBlue, blue));
    }

    public void setRgba(float red, float green, float blue, float alpha) {
        ColouredFluidKey key = this.getFluidKey();
        this.red = Math.max(key.minRed, Math.min(key.maxRed, red));
        this.green = Math.max(key.minGreen, Math.min(key.maxGreen, green));
        this.blue = Math.max(key.minBlue, Math.min(key.maxBlue, blue));
        this.alpha = Math.max(key.minAlpha, Math.min(key.maxAlpha, alpha));
    }

    @Override
    protected ColouredFluidVolume copy0() {
        ColouredFluidVolume copy = (ColouredFluidVolume)super.copy0();
        copy.red = this.red;
        copy.green = this.green;
        copy.blue = this.blue;
        copy.alpha = this.alpha;
        return copy;
    }

    @Override
    protected FluidVolume split0(FluidAmount toTake, RoundingMode rounding) {
        ColouredFluidVolume split = (ColouredFluidVolume)super.split0(toTake, rounding);
        split.red = this.red;
        split.green = this.green;
        split.blue = this.blue;
        split.alpha = this.alpha;
        return split;
    }

    @Override
    protected void mergeInternal(FluidVolume other, FluidAmount.FluidMergeResult mergedAmounts) {
        double amount0 = this.getAmount_F().asInexactDouble();
        double amount1 = other.getAmount_F().asInexactDouble();
        super.mergeInternal(other, mergedAmounts);
        double total = amount0 + (amount1 -= other.getAmount_F().asInexactDouble());
        amount0 /= total;
        amount1 /= total;
        ColouredFluidVolume o = (ColouredFluidVolume)other;
        double r0 = this.red * this.red;
        double g0 = this.green * this.green;
        double b0 = this.blue * this.blue;
        double a0 = this.alpha * this.alpha;
        double r1 = o.red * o.red;
        double g1 = o.green * o.green;
        double b1 = o.blue * o.blue;
        double a1 = o.alpha * o.alpha;
        double rt = r0 * amount0 + r1 * amount1;
        double gt = g0 * amount0 + g1 * amount1;
        double bt = b0 * amount0 + b1 * amount1;
        double at = a0 * amount0 + a1 * amount1;
        this.setRgba((float)Math.sqrt(rt), (float)Math.sqrt(gt), (float)Math.sqrt(bt), (float)Math.sqrt(at));
    }

    @Override
    public void addTooltipExtras(FluidTooltipContext context, List<class_2561> tooltip) {
        super.addTooltipExtras(context, tooltip);
        if (context.isAdvanced()) {
            tooltip.add((class_2561)new class_2585("ARGB = 0x" + Integer.toHexString(this.asArgb())));
            tooltip.add((class_2561)new class_2585("red = " + this.red));
            tooltip.add((class_2561)new class_2585("green = " + this.green));
            tooltip.add((class_2561)new class_2585("blue = " + this.blue));
            tooltip.add((class_2561)new class_2585("alpha = " + this.alpha));
        }
    }
}

