/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.volume;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.ColouredFluidVolume;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidRegistryEntry;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class ColouredFluidKey
extends FluidKey {
    public final float defaultRed;
    public final float defaultGreen;
    public final float defaultBlue;
    public final float defaultAlpha;
    public final float minRed;
    public final float minGreen;
    public final float minBlue;
    public final float minAlpha;
    public final float maxRed;
    public final float maxGreen;
    public final float maxBlue;
    public final float maxAlpha;

    public ColouredFluidKey(ColouredFluidKeyBuilder builder) {
        super(builder);
        this.minRed = ColouredFluidKey.validateMin("red", builder.minRed);
        this.minGreen = ColouredFluidKey.validateMin("green", builder.minGreen);
        this.minBlue = ColouredFluidKey.validateMin("blue", builder.minBlue);
        this.minAlpha = ColouredFluidKey.validateMin("alpha", builder.minAlpha);
        this.maxRed = ColouredFluidKey.validateMax("red", this.minRed, builder.maxRed);
        this.maxGreen = ColouredFluidKey.validateMax("green", this.minGreen, builder.maxGreen);
        this.maxBlue = ColouredFluidKey.validateMax("blue", this.minBlue, builder.maxBlue);
        this.maxAlpha = ColouredFluidKey.validateMax("alpha", this.minAlpha, builder.maxAlpha);
        this.defaultRed = ColouredFluidKey.validateDefault("red", this.minRed, this.maxRed, builder.defaultRed);
        this.defaultGreen = ColouredFluidKey.validateDefault("red", this.minGreen, this.maxGreen, builder.defaultGreen);
        this.defaultBlue = ColouredFluidKey.validateDefault("blue", this.minBlue, this.maxBlue, builder.defaultBlue);
        this.defaultAlpha = ColouredFluidKey.validateDefault("alpha", this.minAlpha, this.maxAlpha, builder.defaultAlpha);
    }

    private static float validateMin(String name, float min) {
        if (min < 0.0f) {
            throw new IllegalArgumentException("Minimum " + name + " was less than 0! (Was " + min + ")");
        }
        if (min > 1.0f) {
            throw new IllegalArgumentException("Minimum " + name + " was greater than 1! (Was " + min + ")");
        }
        return min;
    }

    private static float validateMax(String name, float min, float max) {
        if (max < 0.0f) {
            throw new IllegalArgumentException("Maximum " + name + " was less than 0! (Was " + max + ")");
        }
        if (max > 1.0f) {
            throw new IllegalArgumentException("Maximum " + name + " was greater than 1! (Was " + max + ")");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum " + name + " was less than minimum! (Max = " + max + ", min = " + min + ")");
        }
        return max;
    }

    private static float validateDefault(String name, float min, float max, float value) {
        if (value < min) {
            throw new IllegalArgumentException("Default " + name + " was less than minimum! (Max = " + max + ", min = " + min + " default = " + value + ")");
        }
        if (value > max) {
            throw new IllegalArgumentException("Default " + name + " was greater than maximum! (Max = " + max + ", min = " + min + " default = " + value + ")");
        }
        return value;
    }

    @Override
    public ColouredFluidVolume readVolume(class_2487 tag) {
        return new ColouredFluidVolume(this, tag);
    }

    @Override
    public ColouredFluidVolume readVolume(JsonObject json) throws JsonSyntaxException {
        return new ColouredFluidVolume(this, json);
    }

    @Override
    public ColouredFluidVolume withAmount(FluidAmount amount) {
        return new ColouredFluidVolume(this, amount);
    }

    @Override
    protected ColouredFluidVolume createFromMcBuffer(class_2540 buffer, FluidAmount amount) {
        ColouredFluidVolume volume = this.withAmount(amount);
        volume.fromMcBufferInternal(buffer);
        return volume;
    }

    public static class ColouredFluidKeyBuilder
    extends FluidKey.FluidKeyBuilder {
        float defaultRed = 1.0f;
        float defaultGreen = 1.0f;
        float defaultBlue = 1.0f;
        float defaultAlpha = 1.0f;
        float minRed = 0.0f;
        float maxRed = 1.0f;
        float minGreen = 0.0f;
        float maxGreen = 1.0f;
        float minBlue = 0.0f;
        float maxBlue = 1.0f;
        float minAlpha = 0.003921569f;
        float maxAlpha = 1.0f;

        public ColouredFluidKeyBuilder() {
        }

        public ColouredFluidKeyBuilder(class_2960 id) {
            super(id);
        }

        public ColouredFluidKeyBuilder(class_3611 fluid) {
            super(fluid);
        }

        public ColouredFluidKeyBuilder(FluidRegistryEntry<?> registryEntry, class_2960 spriteId, class_2960 flowingSpriteId, class_2561 name) {
            super(registryEntry, spriteId, flowingSpriteId, name);
        }

        @Override
        public ColouredFluidKeyBuilder copyFrom(FluidKey.FluidKeyBuilder from) {
            super.copyFrom(from);
            if (from instanceof ColouredFluidKeyBuilder) {
                ColouredFluidKeyBuilder o = (ColouredFluidKeyBuilder)from;
                this.defaultRed = o.defaultRed;
                this.defaultGreen = o.defaultGreen;
                this.defaultBlue = o.defaultBlue;
                this.defaultAlpha = o.defaultAlpha;
            }
            return this;
        }

        public ColouredFluidKeyBuilder setDefaultColour(float red, float green, float blue) {
            return this.setDefaultColour(red, green, blue, 1.0f);
        }

        public ColouredFluidKeyBuilder setDefaultColour(float red, float green, float blue, float alpha) {
            this.defaultRed = red;
            this.defaultGreen = green;
            this.defaultBlue = blue;
            this.defaultAlpha = alpha;
            return this;
        }

        public ColouredFluidKeyBuilder setRgbBounds(float min, float max) {
            this.minGreen = this.minBlue = min;
            this.minRed = this.minBlue;
            this.maxGreen = this.maxBlue = max;
            this.maxRed = this.maxBlue;
            return this;
        }

        public ColouredFluidKeyBuilder setRedBounds(float min, float max) {
            this.minRed = min;
            this.maxRed = max;
            return this;
        }

        public ColouredFluidKeyBuilder setGreenBounds(float min, float max) {
            this.minGreen = min;
            this.maxGreen = max;
            return this;
        }

        public ColouredFluidKeyBuilder setBlueBounds(float min, float max) {
            this.minBlue = min;
            this.maxBlue = max;
            return this;
        }

        public ColouredFluidKeyBuilder setAlphaBounds(float min, float max) {
            this.minAlpha = min;
            this.maxAlpha = max;
            return this;
        }
    }
}

