/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.render;

import alexiil.mc.lib.attributes.fluid.mixin.impl.RenderLayerAccessor;
import alexiil.mc.lib.attributes.fluid.render.FluidFaceSplitter;
import alexiil.mc.lib.attributes.fluid.render.FluidRenderFace;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;

public abstract class FluidVolumeRenderer {
    public static final ExpandingVcp VCPS = new ExpandingVcp();

    public abstract void render(FluidVolume var1, List<FluidRenderFace> var2, class_4597 var3, class_4587 var4);

    public void renderGuiRectangle(FluidVolume fluid, double x0, double y0, double x1, double y1) {
        ArrayList<FluidRenderFace> faces = new ArrayList<FluidRenderFace>();
        faces.add(FluidRenderFace.createFlatFaceZ(0.0, 0.0, 0.0, x1 - x0, y1 - y0, 0.0, 0.0625, false, false));
        class_4587 matrices = new class_4587();
        matrices.method_22904(x0, y0, 0.0);
        this.render(fluid, faces, VCPS, matrices);
        VCPS.draw();
    }

    protected static List<FluidRenderFace> splitFaces(List<FluidRenderFace> faces) {
        return FluidFaceSplitter.splitFaces(faces);
    }

    protected static ComponentRenderFaces splitFacesComponent(List<FluidRenderFace> faces) {
        return FluidFaceSplitter.splitFacesComponent(faces);
    }

    protected static class_1921 getRenderLayer(FluidVolume fluid) {
        class_3611 fl = fluid.getRawFluid();
        class_1921 layer = fl == null ? class_1921.method_23583() : class_4696.method_23680((class_3610)fl.method_15785());
        return layer;
    }

    protected static class_1058[] getSprites(FluidVolume fluid) {
        class_1058 flowing;
        class_1058 still;
        class_3611 fl = fluid.getRawFluid();
        class_310 mc = class_310.method_1551();
        if (fl != null) {
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fl);
            if (handler != null) {
                class_1058[] sprites = handler.getFluidSprites(null, null, fl.method_15785());
                assert (sprites.length == 2);
                still = sprites[0];
                flowing = sprites[1];
            } else {
                class_2680 state = fl.method_15785().method_15759();
                flowing = still = mc.method_1541().method_3349(state).method_4711();
            }
        } else {
            class_1059 atlas = mc.method_1554().method_24153(class_1723.field_21668);
            still = atlas.method_4608(fluid.getStillSprite());
            flowing = atlas.method_4608(fluid.getFlowingSprite());
        }
        return new class_1058[]{still, flowing};
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    protected static void renderSimpleFluid(List<FluidRenderFace> faces, class_4588 vc, class_4587 matrices, class_1058 sprite, int colour) {
        FluidVolumeRenderer.renderSimpleFluid(faces, vc, matrices, sprite, sprite, colour);
    }

    protected static void renderSimpleFluid(List<FluidRenderFace> faces, class_4588 vc, class_4587 matrices, class_1058 still, class_1058 flowing, int colour) {
        int a = colour >>> 24 & 0xFF;
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour >> 0 & 0xFF;
        class_1058 _s = still;
        class_1058 _f = flowing;
        for (FluidRenderFace f : FluidVolumeRenderer.splitFaces(faces)) {
            FluidVolumeRenderer.vertex(vc, matrices, f.x0, f.y0, f.z0, f.getU(_s, _f, f.u0), f.getV(_s, _f, f.v0), r, g, b, a, f);
            FluidVolumeRenderer.vertex(vc, matrices, f.x1, f.y1, f.z1, f.getU(_s, _f, f.u1), f.getV(_s, _f, f.v1), r, g, b, a, f);
            FluidVolumeRenderer.vertex(vc, matrices, f.x2, f.y2, f.z2, f.getU(_s, _f, f.u2), f.getV(_s, _f, f.v2), r, g, b, a, f);
            FluidVolumeRenderer.vertex(vc, matrices, f.x3, f.y3, f.z3, f.getU(_s, _f, f.u3), f.getV(_s, _f, f.v3), r, g, b, a, f);
        }
    }

    protected static void vertex(class_4588 vc, class_4587 matrices, double x, double y, double z, float u, float v, int r, int g, int b, FluidRenderFace f) {
        FluidVolumeRenderer.vertex(vc, matrices, x, y, z, u, v, r, g, b, 255, f);
    }

    protected static void vertex(class_4588 vc, class_4587 matrices, double x, double y, double z, float u, float v, int r, int g, int b, int a, FluidRenderFace f) {
        FluidVolumeRenderer.vertex(vc, matrices, x, y, z, u, v, r, g, b, a, f.light, f.nx, f.ny, f.nz);
    }

    protected static void vertex(class_4588 vc, class_4587 matrices, double x, double y, double z, float u, float v, int r, int g, int b, int light, float nx, float ny, float nz) {
        FluidVolumeRenderer.vertex(vc, matrices, x, y, z, u, v, r, g, b, 255, light, nx, ny, nz);
    }

    protected static void vertex(class_4588 vc, class_4587 matrices, double x, double y, double z, float u, float v, int r, int g, int b, int a, int light, float nx, float ny, float nz) {
        vc.method_22918(matrices.method_23760().method_23761(), (float)x, (float)y, (float)z);
        vc.method_1336(r, g, b, a == 0 ? 255 : a);
        vc.method_22913(u, v);
        vc.method_22922(class_4608.field_21444);
        vc.method_22916(light);
        vc.method_23763(matrices.method_23760().method_23762(), nx, ny, nz);
        vc.method_1344();
    }

    public static final class ExpandingVcp
    implements class_4597 {
        private final List<class_1921> before = new ArrayList<class_1921>();
        private final List<class_1921> solid = new ArrayList<class_1921>();
        private final List<class_1921> middle = new ArrayList<class_1921>();
        private final List<class_1921> translucent = new ArrayList<class_1921>();
        private final List<class_1921> after = new ArrayList<class_1921>();
        private final List<class_287> availableBuffers = new ArrayList<class_287>();
        private final Map<class_1921, class_287> activeBuffers = new HashMap<class_1921, class_287>();
        private final Set<class_1921> knownLayers = new HashSet<class_1921>();

        public ExpandingVcp() {
            this.addLayer(class_1921.method_23577());
            this.addLayer(class_1921.method_23581());
            this.addLayer(class_1921.method_23579());
            this.addLayer(class_1921.method_23583());
            this.addLayer(class_1921.method_23585());
            this.addLayerAfter(class_1921.method_23590());
            this.addLayerAfter(class_1921.method_23591());
        }

        public void addLayer(class_1921 layer) {
            if (this.knownLayers.add(layer)) {
                if (((RenderLayerAccessor)layer).libblockattributes_isTranslucent()) {
                    this.translucent.add(layer);
                } else {
                    this.solid.add(layer);
                }
            }
        }

        public void addLayerBefore(class_1921 layer) {
            if (this.knownLayers.add(layer)) {
                this.before.add(layer);
            }
        }

        public void addLayerMiddle(class_1921 layer) {
            if (this.knownLayers.add(layer)) {
                this.middle.add(layer);
            }
        }

        public void addLayerAfter(class_1921 layer) {
            if (this.knownLayers.add(layer)) {
                this.after.add(layer);
            }
        }

        public class_4588 getBuffer(class_1921 layer) {
            this.addLayer(layer);
            class_287 buffer = this.activeBuffers.get(layer);
            if (buffer == null) {
                buffer = this.availableBuffers.isEmpty() ? new class_287(4096) : this.availableBuffers.remove(this.availableBuffers.size() - 1);
                this.activeBuffers.put(layer, buffer);
            }
            if (!buffer.method_22893()) {
                buffer.method_1328(layer.method_23033(), layer.method_23031());
            }
            return buffer;
        }

        public void draw() {
            RenderSystem.runAsFancy(this::drawDirectly);
        }

        public void drawDirectly() {
            this.draw(this.before);
            this.draw(this.solid);
            this.draw(this.middle);
            this.draw(this.translucent);
            this.draw(this.after);
            assert (this.activeBuffers.isEmpty());
        }

        private void draw(List<class_1921> layers) {
            for (class_1921 layer : layers) {
                class_287 buffer = this.activeBuffers.remove(layer);
                if (buffer == null) continue;
                layer.method_23012(buffer, 0, 0, 0);
            }
        }
    }

    public static final class ComponentRenderFaces {
        public final List<FluidRenderFace> split;
        public final List<FluidRenderFace> splitExceptTextures;

        public ComponentRenderFaces(List<FluidRenderFace> split, List<FluidRenderFace> splitExceptTextures) {
            this.split = split;
            this.splitExceptTextures = splitExceptTextures;
        }
    }
}

