/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.render;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public final class FluidRenderFace {
    public static final int FULL_LIGHT = 0xF000F0;
    public final double x0;
    public final double y0;
    public final double z0;
    public final double u0;
    public final double v0;
    public final double x1;
    public final double y1;
    public final double z1;
    public final double u1;
    public final double v1;
    public final double x2;
    public final double y2;
    public final double z2;
    public final double u2;
    public final double v2;
    public final double x3;
    public final double y3;
    public final double z3;
    public final double u3;
    public final double v3;
    public int light = 0xF000F0;
    public final float nx;
    public final float ny;
    public final float nz;
    public final boolean flowing;

    public FluidRenderFace(double _x0, double _y0, double _z0, double _u0, double _v0, double _x1, double _y1, double _z1, double _u1, double _v1, double _x2, double _y2, double _z2, double _u2, double _v2, double _x3, double _y3, double _z3, double _u3, double _v3) {
        this(_x0, _y0, _z0, _u0, _v0, _x1, _y1, _z1, _u1, _v1, _x2, _y2, _z2, _u2, _v2, _x3, _y3, _z3, _u3, _v3, false);
    }

    public FluidRenderFace(double _x0, double _y0, double _z0, double _u0, double _v0, double _x1, double _y1, double _z1, double _u1, double _v1, double _x2, double _y2, double _z2, double _u2, double _v2, double _x3, double _y3, double _z3, double _u3, double _v3, boolean flowing) {
        this.x0 = _x0;
        this.y0 = _y0;
        this.z0 = _z0;
        this.u0 = _u0;
        this.v0 = _v0;
        this.x1 = _x1;
        this.y1 = _y1;
        this.z1 = _z1;
        this.u1 = _u1;
        this.v1 = _v1;
        this.x2 = _x2;
        this.y2 = _y2;
        this.z2 = _z2;
        this.u2 = _u2;
        this.v2 = _v2;
        this.x3 = _x3;
        this.y3 = _y3;
        this.z3 = _z3;
        this.u3 = _u3;
        this.v3 = _v3;
        double ax = this.x1 - this.x0;
        double ay = this.y1 - this.y0;
        double az = this.z1 - this.z0;
        double bx = this.x2 - this.x0;
        double by = this.y2 - this.y0;
        double bz = this.z2 - this.z0;
        this.nx = (float)(ay * bz - az * by);
        this.ny = (float)(az * bx - ax * bz);
        this.nz = (float)(ax * by - ay * bx);
        this.light = 0xF000F0;
        this.flowing = flowing;
    }

    public FluidRenderFace(double _x0, double _y0, double _z0, double _u0, double _v0, double _x1, double _y1, double _z1, double _u1, double _v1, double _x2, double _y2, double _z2, double _u2, double _v2, double _x3, double _y3, double _z3, double _u3, double _v3, int light, float nx, float ny, float nz, boolean flowing) {
        this.x0 = _x0;
        this.y0 = _y0;
        this.z0 = _z0;
        this.u0 = _u0;
        this.v0 = _v0;
        this.x1 = _x1;
        this.y1 = _y1;
        this.z1 = _z1;
        this.u1 = _u1;
        this.v1 = _v1;
        this.x2 = _x2;
        this.y2 = _y2;
        this.z2 = _z2;
        this.u2 = _u2;
        this.v2 = _v2;
        this.x3 = _x3;
        this.y3 = _y3;
        this.z3 = _z3;
        this.u3 = _u3;
        this.v3 = _v3;
        this.light = light;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.flowing = flowing;
    }

    public static void appendCuboid(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, EnumSet<class_2350> faces, List<FluidRenderFace> to) {
        FluidRenderFace.appendCuboid(x0, y0, z0, x1, y1, z1, textureScale, faces, to, false);
    }

    public static void appendCuboid(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, EnumSet<class_2350> faces, List<FluidRenderFace> to, boolean flowing) {
        for (class_2350 face : faces) {
            to.add(FluidRenderFace.createFlatFace(x0, y0, z0, x1, y1, z1, textureScale, face, flowing));
        }
    }

    public static FluidRenderFace createFlatFaceX(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive) {
        return FluidRenderFace.createFlatFaceX(x0, y0, z0, x1, y1, z1, textureScale, positive, false);
    }

    public static FluidRenderFace createFlatFaceX(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive, boolean flowing) {
        double s = textureScale;
        if (positive) {
            return new FluidRenderFace(x1, y0, z0, z0 * s, y0 * s, x1, y1, z0, z0 * s, y1 * s, x1, y1, z1, z1 * s, y1 * s, x1, y0, z1, z1 * s, y0 * s, 0xF000F0, 1.0f, 0.0f, 0.0f, flowing);
        }
        return new FluidRenderFace(x0, y0, z0, z0 * s, y0 * s, x0, y0, z1, z1 * s, y0 * s, x0, y1, z1, z1 * s, y1 * s, x0, y1, z0, z0 * s, y1 * s, 0xF000F0, -1.0f, 0.0f, 0.0f, flowing);
    }

    public static FluidRenderFace createFlatFaceY(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive) {
        return FluidRenderFace.createFlatFaceY(x0, y0, z0, x1, y1, z1, textureScale, positive, false);
    }

    public static FluidRenderFace createFlatFaceY(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive, boolean flowing) {
        double s = textureScale;
        if (positive) {
            return new FluidRenderFace(x0, y1, z0, x0 * s, z0 * s, x0, y1, z1, x0 * s, z1 * s, x1, y1, z1, x1 * s, z1 * s, x1, y1, z0, x1 * s, z0 * s, 0xF000F0, 0.0f, 1.0f, 0.0f, flowing);
        }
        return new FluidRenderFace(x0, y0, z0, x0 * s, z0 * s, x1, y0, z0, x1 * s, z0 * s, x1, y0, z1, x1 * s, z1 * s, x0, y0, z1, x0 * s, z1 * s, 0xF000F0, 0.0f, -1.0f, 0.0f, flowing);
    }

    public static FluidRenderFace createFlatFaceZ(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive) {
        return FluidRenderFace.createFlatFaceZ(x0, y0, z0, x1, y1, z1, textureScale, positive, false);
    }

    public static FluidRenderFace createFlatFaceZ(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, boolean positive, boolean flowing) {
        double s = textureScale;
        if (positive) {
            return new FluidRenderFace(x0, y0, z1, x0 * s, y0 * s, x1, y0, z1, x1 * s, y0 * s, x1, y1, z1, x1 * s, y1 * s, x0, y1, z1, x0 * s, y1 * s, 0xF000F0, 0.0f, 0.0f, 1.0f, flowing);
        }
        return new FluidRenderFace(x0, y0, z0, x0 * s, y0 * s, x0, y1, z0, x0 * s, y1 * s, x1, y1, z0, x1 * s, y1 * s, x1, y0, z0, x1 * s, y0 * s, 0xF000F0, 0.0f, 0.0f, -1.0f, flowing);
    }

    public static FluidRenderFace createFlatFace(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, class_2350 face) {
        return FluidRenderFace.createFlatFace(x0, y0, z0, x1, y1, z1, textureScale, face, false);
    }

    public static FluidRenderFace createFlatFace(double x0, double y0, double z0, double x1, double y1, double z1, double textureScale, class_2350 face, boolean flowing) {
        switch (face) {
            case field_11033: {
                return FluidRenderFace.createFlatFaceY(x0, y0, z0, x1, y1, z1, textureScale, false, flowing);
            }
            case field_11036: {
                return FluidRenderFace.createFlatFaceY(x0, y0, z0, x1, y1, z1, textureScale, true, flowing);
            }
            case field_11043: {
                return FluidRenderFace.createFlatFaceZ(x0, y0, z0, x1, y1, z1, textureScale, false, flowing);
            }
            case field_11035: {
                return FluidRenderFace.createFlatFaceZ(x0, y0, z0, x1, y1, z1, textureScale, true, flowing);
            }
            case field_11039: {
                return FluidRenderFace.createFlatFaceX(x0, y0, z0, x1, y1, z1, textureScale, false, flowing);
            }
            case field_11034: {
                return FluidRenderFace.createFlatFaceX(x0, y0, z0, x1, y1, z1, textureScale, true, flowing);
            }
        }
        throw new IllegalStateException("Unknown Direction " + face);
    }

    public String toString() {
        return "FluidRenderFace { " + (this.flowing ? "flowing" : "still") + "\n  " + this.x0 + " " + this.y0 + " " + this.z0 + " " + this.u0 + " " + this.v0 + "\n  " + this.x1 + " " + this.y1 + " " + this.z1 + " " + this.u1 + " " + this.v1 + "\n  " + this.x2 + " " + this.y2 + " " + this.z2 + " " + this.u2 + " " + this.v2 + "\n  " + this.x3 + " " + this.y3 + " " + this.z3 + " " + this.u3 + " " + this.v3 + "\n}";
    }

    public float getU(class_1058 still, class_1058 flowing, double u) {
        class_1058 s = still;
        if (this.flowing) {
            s = flowing;
            u = 0.25 + u * 0.5;
        }
        return class_3532.method_16439((float)((float)u), (float)s.method_4594(), (float)s.method_4577());
    }

    public float getV(class_1058 still, class_1058 flowing, double v) {
        class_1058 s = still;
        if (this.flowing) {
            s = flowing;
            v = 0.25 + v * 0.5;
        }
        return class_3532.method_16439((float)((float)v), (float)s.method_4593(), (float)s.method_4575());
    }
}

