/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.render;

import alexiil.mc.lib.attributes.fluid.render.FluidRenderFace;
import alexiil.mc.lib.attributes.fluid.render.FluidVolumeRenderer;
import java.util.ArrayList;
import java.util.List;

final class FluidFaceSplitter {
    FluidFaceSplitter() {
    }

    static List<FluidRenderFace> splitFaces(List<FluidRenderFace> faces) {
        return FluidFaceSplitter.splitFacesComponent(faces).split;
    }

    static FluidVolumeRenderer.ComponentRenderFaces splitFacesComponent(List<FluidRenderFace> faces) {
        ArrayList<FluidRenderFace> splitFull = new ArrayList<FluidRenderFace>();
        ArrayList<FluidRenderFace> splitTex = new ArrayList<FluidRenderFace>();
        splitFull.addAll(faces);
        splitTex.addAll(faces);
        FluidFaceSplitter.separateFaces(true, splitFull, splitTex);
        FluidFaceSplitter.separateFaces(false, splitFull, splitTex);
        return new FluidVolumeRenderer.ComponentRenderFaces(splitFull, splitTex);
    }

    private static void separateFaces(boolean u, List<FluidRenderFace> splitFull, List<FluidRenderFace> splitTex) {
        FluidRenderFace[] inputFull = splitFull.toArray(new FluidRenderFace[0]);
        FluidRenderFace[] inputTex = splitTex.toArray(new FluidRenderFace[0]);
        splitFull.clear();
        splitTex.clear();
        for (int i = 0; i < inputFull.length; ++i) {
            FluidRenderFace face = inputFull[i];
            FluidRenderFace faceT = inputTex[i];
            new Quad(face, faceT).split(u, splitFull, splitTex);
        }
    }

    private static boolean doesCrossTextureBound(double a, double b) {
        if (a == b) {
            return false;
        }
        if (a > b) {
            double t = a;
            a = b;
            b = t;
        }
        int ra = (int)Math.floor(a);
        int rb = (int)Math.floor(b);
        if ((double)rb == b) {
            return rb - 1 != ra;
        }
        return rb == ra;
    }

    static final class Quad {
        final Vertex v0;
        final Vertex v1;
        final Vertex v2;
        final Vertex v3;
        final Line l0;
        final Line l1;
        final Line l2;
        final Line l3;
        final int light;
        final float nx;
        final float ny;
        final float nz;
        final boolean flowing;

        Quad(int light, float nx, float ny, float nz, boolean flowing) {
            this(new Vertex(), new Vertex(), new Vertex(), new Vertex(), light, nx, ny, nz, flowing);
        }

        Quad(FluidRenderFace rounded, FluidRenderFace normal) {
            this(rounded.light, rounded.nx, rounded.ny, rounded.nz, rounded.flowing);
            this.set(rounded, normal);
        }

        public Quad(Vertex v0, Vertex v1, Vertex v2, Vertex v3, int light, float nx, float ny, float nz, boolean flowing) {
            this.v0 = v0.l0 == null && v0.l1 == null ? v0 : new Vertex(v0);
            this.v1 = v1.l0 == null && v1.l1 == null ? v1 : new Vertex(v1);
            this.v2 = v2.l0 == null && v2.l1 == null ? v2 : new Vertex(v2);
            this.v3 = v3.l0 == null && v3.l1 == null ? v3 : new Vertex(v3);
            this.l0 = new Line(v0, v1);
            this.l1 = new Line(v1, v2);
            this.l2 = new Line(v2, v3);
            this.l3 = new Line(v3, v0);
            this.light = light;
            this.nx = nx;
            this.ny = ny;
            this.nz = nz;
            this.flowing = flowing;
        }

        void set(FluidRenderFace rounded, FluidRenderFace normal) {
            this.v0.set(rounded, normal, 0);
            this.v1.set(rounded, normal, 1);
            this.v2.set(rounded, normal, 2);
            this.v3.set(rounded, normal, 3);
        }

        void split(boolean u, List<FluidRenderFace> splitFull, List<FluidRenderFace> splitTex) {
            Vertex lowestVertex = this.v0;
            Vertex highestVertex = this.v0;
            Vertex[] searchVertices = new Vertex[]{this.v1, this.v2, this.v3};
            double[] searchPoints = new double[]{this.v1.texN(u), this.v2.texN(u), this.v3.texN(u)};
            for (int i = 0; i < searchVertices.length; ++i) {
                Vertex v = searchVertices[i];
                double point = searchPoints[i];
                if (point < lowestVertex.texN(u)) {
                    lowestVertex = v;
                }
                if (!(point >= highestVertex.texN(u))) continue;
                highestVertex = v;
            }
            if (lowestVertex == highestVertex) {
                splitFull.add(this.toRounded(u));
                splitTex.add(this.toFace());
                return;
            }
            ArrayList<Vertex> lowToHigh0 = new ArrayList<Vertex>(4);
            ArrayList<Vertex> lowToHigh1 = new ArrayList<Vertex>(4);
            lowToHigh0.add(lowestVertex);
            lowToHigh1.add(lowestVertex);
            Vertex h = lowestVertex;
            do {
                if ((h = h.l1.v1) == lowestVertex) {
                    throw new IllegalStateException("h == lowestVertex");
                }
                lowToHigh0.add(h);
            } while (h != highestVertex);
            h = lowestVertex;
            do {
                if ((h = h.l0.v0) == lowestVertex) {
                    throw new IllegalStateException("h == lowestVertex");
                }
                lowToHigh1.add(h);
            } while (h != highestVertex);
            List<BucketedVertexList> separated0 = Quad.separateVertices(u, lowToHigh0);
            List<BucketedVertexList> separated1 = Quad.separateVertices(u, lowToHigh1);
            assert (separated0.size() == separated1.size());
            for (int i = 0; i < separated0.size(); ++i) {
                int size1;
                int size0;
                BucketedVertexList bucket0 = separated0.get(i);
                BucketedVertexList bucket1 = separated1.get(i);
                assert (bucket0.texValue == bucket1.texValue);
                List<Vertex> list0 = bucket0.list;
                List<Vertex> list1 = bucket1.list;
                while (true) {
                    Quad quad;
                    Vertex vr1;
                    Vertex vr0;
                    Vertex vl2;
                    Quad quad2;
                    Vertex vr02;
                    Vertex vl1;
                    Vertex vl0;
                    size0 = list0.size();
                    size1 = list1.size();
                    if (size0 > 1 && size1 > 1) {
                        vl0 = list0.remove(0);
                        vl1 = list0.get(0);
                        vr02 = list1.remove(0);
                        Vertex vr12 = list1.get(0);
                        quad2 = new Quad(vl0, vl1, vr12, vr02, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad2.toRounded(u, bucket0.texValue));
                        splitTex.add(quad2.toFace());
                        continue;
                    }
                    if (size0 > 2 && size1 > 0) {
                        vl0 = list0.remove(0);
                        vl1 = list0.remove(0);
                        vl2 = list0.get(0);
                        Vertex vr03 = list1.get(0);
                        quad2 = new Quad(vl0, vl1, vl2, vr03, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad2.toRounded(u, bucket0.texValue));
                        splitTex.add(quad2.toFace());
                        continue;
                    }
                    if (size0 > 0 && size1 > 2) {
                        vl0 = list0.get(0);
                        vr0 = list1.remove(0);
                        vr1 = list1.remove(0);
                        Vertex vr2 = list1.get(0);
                        quad2 = new Quad(vl0, vr2, vr1, vr0, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad2.toRounded(u, bucket0.texValue));
                        splitTex.add(quad2.toFace());
                        continue;
                    }
                    if (size0 > 1 && size1 > 0) {
                        vl0 = list0.remove(0);
                        vl1 = list0.get(0);
                        vr02 = list1.get(0);
                        quad = new Quad(vl0, vl1, vr02, vr02, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad.toRounded(u, bucket0.texValue));
                        splitTex.add(quad.toFace());
                        continue;
                    }
                    if (size0 > 0 && size1 > 1) {
                        vl0 = list0.get(0);
                        vr0 = list1.remove(0);
                        vr1 = list1.get(0);
                        quad = new Quad(vl0, vr1, vr0, vl0, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad.toRounded(u, bucket0.texValue));
                        splitTex.add(quad.toFace());
                        continue;
                    }
                    if (size0 > 2) {
                        vl0 = list0.remove(0);
                        vl1 = list0.remove(0);
                        vl2 = list0.get(0);
                        quad = new Quad(vl0, vl1, vl2, vl0, this.light, this.nx, this.ny, this.nz, this.flowing);
                        splitFull.add(quad.toRounded(u, bucket0.texValue));
                        splitTex.add(quad.toFace());
                        continue;
                    }
                    if (size1 <= 2) break;
                    Vertex vr04 = list1.remove(0);
                    Vertex vr13 = list1.remove(0);
                    Vertex vr2 = list1.get(0);
                    quad = new Quad(vr2, vr13, vr04, vr2, this.light, this.nx, this.ny, this.nz, this.flowing);
                    splitFull.add(quad.toRounded(u, bucket0.texValue));
                    splitTex.add(quad.toFace());
                }
                if (size0 + size1 <= 2) continue;
                throw new IllegalStateException("Unhandled size: [ " + size0 + ", " + size1 + " ]");
            }
        }

        private static List<BucketedVertexList> separateVertices(boolean u, List<Vertex> in) {
            ArrayList<BucketedVertexList> out = new ArrayList<BucketedVertexList>();
            BucketedVertexList prevList = null;
            for (Vertex v : in) {
                double tex_d = v.texN(u);
                int tex_i = (int)Math.floor(tex_d);
                if (prevList == null) {
                    if (tex_d == (double)tex_i) {
                        prevList = new BucketedVertexList(tex_i - 1);
                        out.add(prevList);
                        prevList.list.add(v);
                        prevList = new BucketedVertexList(tex_i);
                        out.add(prevList);
                        prevList.list.add(v);
                        continue;
                    }
                    prevList = new BucketedVertexList(tex_i);
                    out.add(prevList);
                    prevList.list.add(v);
                    continue;
                }
                if (prevList.texValue == tex_i) {
                    prevList.list.add(v);
                    continue;
                }
                Vertex vPrevious = prevList.list.get(prevList.list.size() - 1);
                prevList.list.add(Quad.interp(u, vPrevious, v, prevList.texValue + 1));
                for (int i = prevList.texValue + 1; i < tex_i; ++i) {
                    prevList = new BucketedVertexList(i);
                    out.add(prevList);
                    prevList.list.add(Quad.interp(u, vPrevious, v, i));
                    prevList.list.add(Quad.interp(u, vPrevious, v, i + 1));
                }
                if (tex_d == (double)tex_i) {
                    prevList = new BucketedVertexList(tex_i);
                    out.add(prevList);
                    prevList.list.add(v);
                    continue;
                }
                prevList = new BucketedVertexList(tex_i);
                out.add(prevList);
                prevList.list.add(Quad.interp(u, vPrevious, v, tex_i));
                prevList.list.add(v);
            }
            return out;
        }

        private static Vertex interp(boolean u, Vertex v0, Vertex v1, int newTextureCoord) {
            double t0 = v0.texN(u);
            double t1 = v1.texN(u);
            if (t0 == (double)newTextureCoord) {
                return v0;
            }
            if (t1 == (double)newTextureCoord) {
                return v1;
            }
            double interpValue = ((double)newTextureCoord - t0) / (t1 - t0);
            return new Vertex(Quad.interp(v0.x, v1.x, interpValue), Quad.interp(v0.y, v1.y, interpValue), Quad.interp(v0.z, v1.z, interpValue), Quad.interp(v0.uR, v1.uR, interpValue), Quad.interp(v0.vR, v1.vR, interpValue), Quad.interp(v0.uN, v1.uN, interpValue), Quad.interp(v0.vN, v1.vN, interpValue));
        }

        private static double interp(double a, double b, double interpValue) {
            return a * (1.0 - interpValue) + b * interpValue;
        }

        FluidRenderFace toRounded(boolean u) {
            return this.toRounded(u, (int)Math.floor(this.lowestR(u)));
        }

        FluidRenderFace toRounded(boolean u, int min) {
            double _u0 = Quad.round(u, min, this.v0.uR);
            double _u1 = Quad.round(u, min, this.v1.uR);
            double _u2 = Quad.round(u, min, this.v2.uR);
            double _u3 = Quad.round(u, min, this.v3.uR);
            double _v0 = Quad.round(!u, min, this.v0.vR);
            double _v1 = Quad.round(!u, min, this.v1.vR);
            double _v2 = Quad.round(!u, min, this.v2.vR);
            double _v3 = Quad.round(!u, min, this.v3.vR);
            return new FluidRenderFace(this.v0.x, this.v0.y, this.v0.z, _u0, _v0, this.v1.x, this.v1.y, this.v1.z, _u1, _v1, this.v2.x, this.v2.y, this.v2.z, _u2, _v2, this.v3.x, this.v3.y, this.v3.z, _u3, _v3, this.light, this.nx, this.ny, this.nz, this.flowing);
        }

        FluidRenderFace toFace() {
            return new FluidRenderFace(this.v0.x, this.v0.y, this.v0.z, this.v0.uN, this.v0.vN, this.v1.x, this.v1.y, this.v1.z, this.v1.uN, this.v1.vN, this.v2.x, this.v2.y, this.v2.z, this.v2.uN, this.v2.vN, this.v3.x, this.v3.y, this.v3.z, this.v3.uN, this.v3.vN, this.light, this.nx, this.ny, this.nz, this.flowing);
        }

        private double lowestR(boolean u) {
            return Math.min(Math.min(this.v0.texR(u), this.v1.texR(u)), Math.min(this.v2.texR(u), this.v3.texR(u)));
        }

        private static double round(boolean should, int min, double value) {
            return should ? value - (double)min : value;
        }

        public String toString() {
            return "Quad {\n  " + this.v0 + "\n  " + this.v1 + "\n  " + this.v2 + "\n  " + this.v3 + "\n}";
        }

        static class BucketedVertexList {
            final int texValue;
            final List<Vertex> list = new ArrayList<Vertex>();

            public BucketedVertexList(int texValue) {
                this.texValue = texValue;
            }
        }
    }

    static final class Line {
        final Vertex v0;
        final Vertex v1;

        Line(Vertex v0, Vertex v1) {
            this.v0 = v0;
            this.v1 = v1;
            v0.l1 = this;
            v1.l0 = this;
        }
    }

    static final class Vertex {
        double x;
        double y;
        double z;
        double uR;
        double vR;
        double uN;
        double vN;
        Line l0;
        Line l1;

        Vertex() {
        }

        Vertex(double x, double y, double z, double uR, double vR, double uN, double vN) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.uR = uR;
            this.vR = vR;
            this.uN = uN;
            this.vN = vN;
        }

        public Vertex(Vertex from) {
            this(from.x, from.y, from.z, from.uR, from.vR, from.uN, from.vN);
        }

        void set(FluidRenderFace rounded, FluidRenderFace normal, int i) {
            FluidRenderFace f = rounded;
            FluidRenderFace n = normal;
            double d = i == 0 ? f.x0 : (i == 1 ? f.x1 : (this.x = i == 2 ? f.x2 : f.x3));
            double d2 = i == 0 ? f.y0 : (i == 1 ? f.y1 : (this.y = i == 2 ? f.y2 : f.y3));
            double d3 = i == 0 ? f.z0 : (i == 1 ? f.z1 : (this.z = i == 2 ? f.z2 : f.z3));
            double d4 = i == 0 ? f.u0 : (i == 1 ? f.u1 : (this.uR = i == 2 ? f.u2 : f.u3));
            double d5 = i == 0 ? f.v0 : (i == 1 ? f.v1 : (this.vR = i == 2 ? f.v2 : f.v3));
            double d6 = i == 0 ? n.u0 : (i == 1 ? n.u1 : (this.uN = i == 2 ? n.u2 : n.u3));
            this.vN = i == 0 ? n.v0 : (i == 1 ? n.v1 : (i == 2 ? n.v2 : n.v3));
        }

        double texN(boolean _u) {
            return _u ? this.uN : this.vN;
        }

        double texR(boolean _u) {
            return _u ? this.uR : this.vR;
        }

        public String toString() {
            return this.x + " " + this.y + " " + this.z + " " + this.uN + " " + this.vN;
        }
    }
}

