/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.item;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilterUtil;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractItemBasedAttribute;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1799;

public abstract class ItemBasedSingleFluidInv
extends AbstractItemBasedAttribute
implements GroupedFluidInv {
    protected ItemBasedSingleFluidInv(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
        super(stackRef, excessStacks);
    }

    protected abstract boolean isInvalid(class_1799 var1);

    protected abstract HeldFluidInfo getInfo(class_1799 var1);

    @Nullable
    protected abstract class_1799 writeToStack(class_1799 var1, FluidVolume var2);

    @Override
    public Set<FluidKey> getStoredFluids() {
        class_1799 stack = (class_1799)this.stackRef.get();
        if (stack.method_7960() || this.isInvalid(stack)) {
            return Collections.emptySet();
        }
        HeldFluidInfo info = this.getInfo(stack);
        if (info.fluid.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(info.fluid.fluidKey);
    }

    @Override
    public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
        class_1799 stack = (class_1799)this.stackRef.get();
        if (stack.method_7960() || this.isInvalid(stack)) {
            return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
        }
        HeldFluidInfo info = this.getInfo(stack);
        if (!FluidFilterUtil.hasIntersection(filter, this.getInsertionFilter())) {
            return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
        }
        FluidAmount capacity = info.capacity;
        if (info.fluid.isEmpty()) {
            return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.ZERO, capacity, capacity);
        }
        if (filter.matches(info.fluid.fluidKey)) {
            FluidAmount spaceAddable = capacity.sub(info.fluid.getAmount_F());
            return new GroupedFluidInvView.FluidInvStatistic(filter, info.fluid.getAmount_F(), spaceAddable, capacity);
        }
        return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.ZERO, FluidAmount.ZERO, capacity);
    }

    @Override
    public FluidFilter getInsertionFilter() {
        return ConstantFluidFilter.ANYTHING;
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        if (fluid.isEmpty()) {
            return fluid;
        }
        if (!this.getInsertionFilter().matches(fluid.fluidKey)) {
            return fluid;
        }
        class_1799 stack = (class_1799)this.stackRef.get();
        if (stack.method_7960() || this.isInvalid(stack)) {
            return fluid;
        }
        HeldFluidInfo info = this.getInfo(stack);
        FluidVolumeUtil.FluidTransferResult result = FluidVolumeUtil.computeInsertion(info.fluid, info.capacity, fluid);
        if (result.inTank == info.fluid) {
            return fluid;
        }
        class_1799 oldStack = stack.method_7972();
        class_1799 newStack = oldStack.method_7971(1);
        if ((newStack = this.writeToStack(newStack, result.inTank)) == null) {
            return fluid;
        }
        if (this.setStacks(simulation, oldStack, newStack)) {
            return result.result;
        }
        return fluid;
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        class_1799 stack = (class_1799)this.stackRef.get();
        if (stack.method_7960() || this.isInvalid(stack)) {
            return FluidVolumeUtil.EMPTY;
        }
        HeldFluidInfo info = this.getInfo(stack);
        if (info.fluid.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        FluidVolumeUtil.FluidTransferResult result = FluidVolumeUtil.computeExtraction(info.fluid, filter, maxAmount);
        if (result.inTank == info.fluid) {
            return FluidVolumeUtil.EMPTY;
        }
        class_1799 oldStack = stack.method_7972();
        class_1799 newStack = oldStack.method_7971(1);
        if (this.setStacks(simulation, oldStack, newStack = this.writeToStack(newStack, result.inTank))) {
            return result.result;
        }
        return FluidVolumeUtil.EMPTY;
    }

    public static final class HeldFluidInfo {
        public final FluidVolume fluid;
        public final FluidAmount capacity;

        public HeldFluidInfo(FluidVolume fluid, FluidAmount capacity) {
            this.fluid = fluid;
            this.capacity = capacity;
        }
    }
}

