/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.impl.AbstractPartialFixedFluidInvView;

public class SubFixedFluidInvView
extends AbstractPartialFixedFluidInvView {
    private final int fromIndex;
    private final int toIndex;

    public SubFixedFluidInvView(FixedFluidInvView inv, int fromIndex, int toIndex) {
        super(inv);
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex was greater than toIndex! (" + fromIndex + " > " + toIndex + ")");
        }
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    protected int getInternalTank(int tank) {
        if ((tank += this.fromIndex) >= this.toIndex) {
            throw new IllegalArgumentException("The given tank " + (tank - this.fromIndex) + "is greater than the size of this inventory! (" + this.getTankCount() + ")");
        }
        return tank;
    }

    @Override
    public int getTankCount() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public FixedFluidInvView getFixedView() {
        if (this.getClass() == SubFixedFluidInvView.class) {
            return this;
        }
        return super.getFixedView();
    }

    @Override
    public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        SubFixedFluidInvView wrapper = this;
        return this.inv.addListener((realInv, tank, previous, current) -> {
            assert (realInv == this.inv);
            if (tank >= this.fromIndex && tank < this.toIndex) {
                int exposedTank = tank - this.fromIndex;
                listener.onChange(wrapper, exposedTank, previous, current);
            }
        }, removalToken);
    }
}

