/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.LimitedGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.DelegatingGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SimpleLimitedGroupedFluidInv
extends DelegatingGroupedFluidInv
implements LimitedGroupedFluidInv {
    private boolean isImmutable = false;
    private final List<InsertionRule> insertionRules = new ArrayList<InsertionRule>();
    private final List<ExtractionRule> extractionRules = new ArrayList<ExtractionRule>();

    public SimpleLimitedGroupedFluidInv(GroupedFluidInv delegate) {
        super(delegate);
    }

    @Override
    public LimitedGroupedFluidInv markFinal() {
        this.isImmutable = true;
        return this;
    }

    protected void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalStateException("This object has already been marked as immutable, so no further changes are permitted!");
        }
    }

    @Override
    public LimitedGroupedFluidInv copy() {
        SimpleLimitedGroupedFluidInv copy = new SimpleLimitedGroupedFluidInv(this.delegate);
        copy.extractionRules.addAll(this.extractionRules);
        copy.insertionRules.addAll(this.insertionRules);
        return copy;
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        if (filter == ConstantFluidFilter.NOTHING) {
            return FluidVolumeUtil.EMPTY;
        }
        if (this.extractionRules.isEmpty()) {
            return this.delegate.attemptExtraction(filter, maxAmount, simulation);
        }
        Set<FluidKey> keys = this.delegate.getStoredFluids();
        if (keys.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        if (filter instanceof ExactFluidFilter) {
            FluidKey key = ((ExactFluidFilter)filter).fluid;
            if (!keys.contains(key)) {
                return FluidVolumeUtil.EMPTY;
            }
            keys = Collections.singleton(key);
        }
        block0: for (FluidKey key : keys) {
            FluidAmount current;
            if (!filter.matches(key) || !(current = this.delegate.getAmount_F(key)).isPositive()) continue;
            FluidAmount minLeft = FluidAmount.ZERO;
            for (ExtractionRule rule : this.extractionRules) {
                if (!rule.filter.matches(key) || !rule.minimumAmount.isPositive() || current.isGreaterThan(minLeft = (FluidAmount)minLeft.max(rule.minimumAmount))) continue;
                continue block0;
            }
            FluidAmount allowed = current.sub(minLeft);
            return this.delegate.attemptExtraction(key.exactFilter, (FluidAmount)maxAmount.min(allowed), simulation);
        }
        return FluidVolumeUtil.EMPTY;
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        if (fluid.isEmpty()) {
            return fluid;
        }
        FluidAmount current = this.delegate.getAmount_F(fluid.fluidKey);
        FluidAmount maxAmount = FluidAmount.MAX_BUCKETS;
        for (InsertionRule rule : this.insertionRules) {
            if (!rule.filter.matches(fluid.fluidKey) || !(maxAmount = (FluidAmount)maxAmount.min(rule.maximumInsertion)).isLessThanOrEqual(current)) continue;
            return fluid;
        }
        FluidAmount allowed = maxAmount.sub(current);
        assert (allowed.isPositive());
        if (allowed.isLessThan(fluid.getAmount_F())) {
            FluidVolume original = fluid;
            FluidVolume offered = original.copy();
            FluidVolume leftover = this.delegate.attemptInsertion(offered.split(allowed), simulation);
            if (leftover.getAmount_F().equals(maxAmount)) {
                return original;
            }
            return FluidVolume.merge(offered, leftover);
        }
        return super.attemptInsertion(fluid, simulation);
    }

    @Override
    public FluidFilter getInsertionFilter() {
        if (this.insertionRules.isEmpty()) {
            return this.delegate.getInsertionFilter();
        }
        ArrayList<FluidFilter> disallowed = new ArrayList<FluidFilter>();
        for (InsertionRule rule : this.insertionRules) {
            if (rule.maximumInsertion.isPositive()) continue;
            disallowed.add(rule.filter);
        }
        FluidFilter allowed = AggregateFluidFilter.anyOf(disallowed).negate();
        return allowed.and(this.delegate.getInsertionFilter());
    }

    @Override
    public LimitedGroupedFluidInv.FluidLimitRule getRule(final FluidFilter filter) {
        if (filter == ConstantFluidFilter.NOTHING) {
            return new LimitedGroupedFluidInv.FluidLimitRule(){

                @Override
                public LimitedGroupedFluidInv.FluidLimitRule setMinimum(FluidAmount min) {
                    return this;
                }

                @Override
                public LimitedGroupedFluidInv.FluidLimitRule limitInsertionAmount(FluidAmount max) {
                    return this;
                }
            };
        }
        if (filter == ConstantFluidFilter.ANYTHING) {
            return new LimitedGroupedFluidInv.FluidLimitRule(){

                @Override
                public LimitedGroupedFluidInv.FluidLimitRule setMinimum(FluidAmount min) {
                    SimpleLimitedGroupedFluidInv.this.extractionRules.clear();
                    if (min.isPositive()) {
                        SimpleLimitedGroupedFluidInv.this.extractionRules.add(new ExtractionRule(filter, min));
                    }
                    return this;
                }

                @Override
                public LimitedGroupedFluidInv.FluidLimitRule limitInsertionAmount(FluidAmount max) {
                    SimpleLimitedGroupedFluidInv.this.insertionRules.clear();
                    if (!max.isNegative()) {
                        SimpleLimitedGroupedFluidInv.this.insertionRules.add(new InsertionRule(filter, max));
                    }
                    return this;
                }
            };
        }
        return new LimitedGroupedFluidInv.FluidLimitRule(){

            @Override
            public LimitedGroupedFluidInv.FluidLimitRule setMinimum(FluidAmount min) {
                SimpleLimitedGroupedFluidInv.this.extractionRules.add(new ExtractionRule(filter, min));
                return this;
            }

            @Override
            public LimitedGroupedFluidInv.FluidLimitRule limitInsertionAmount(FluidAmount max) {
                SimpleLimitedGroupedFluidInv.this.insertionRules.add(new InsertionRule(filter, max));
                return this;
            }
        };
    }

    static final class ExtractionRule {
        final FluidFilter filter;
        final FluidAmount minimumAmount;

        public ExtractionRule(FluidFilter filter, FluidAmount minimumAmount) {
            this.filter = filter;
            this.minimumAmount = minimumAmount;
        }
    }

    static final class InsertionRule {
        final FluidFilter filter;
        final FluidAmount maximumInsertion;

        public InsertionRule(FluidFilter filter, FluidAmount maximumInsertion) {
            this.filter = filter;
            this.maximumInsertion = maximumInsertion;
        }
    }
}

