/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.LimitedFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.DelegatingFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.DelegatingGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.math.RoundingMode;
import java.util.Arrays;

public class SimpleLimitedFixedFluidInv
extends DelegatingFixedFluidInv
implements LimitedFixedFluidInv {
    private final GroupedFluidInv groupedInv;
    private boolean isImmutable = false;
    protected final FluidFilter[] insertionFilters = new FluidFilter[this.getTankCount()];
    protected final FluidAmount[] maxInsertionAmounts = new FluidAmount[this.getTankCount()];
    protected final FluidAmount[] minimumAmounts = new FluidAmount[this.getTankCount()];

    public SimpleLimitedFixedFluidInv(FixedFluidInv delegate) {
        super(delegate);
        this.groupedInv = new DelegatingGroupedFluidInv(super.getGroupedInv()){

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                if (maxAmount.isNegative()) {
                    throw new IllegalArgumentException("maxAmount cannot be negative! (was " + maxAmount + ")");
                }
                FluidVolume volume = FluidVolumeUtil.EMPTY;
                if (maxAmount.isZero()) {
                    return volume;
                }
                SimpleLimitedFixedFluidInv inv = SimpleLimitedFixedFluidInv.this;
                for (int t = 0; t < SimpleLimitedFixedFluidInv.this.getTankCount(); ++t) {
                    FluidAmount tankMax;
                    FluidVolume tankVolume = inv.getInvFluid(t);
                    FluidAmount minimum = SimpleLimitedFixedFluidInv.this.minimumAmounts[t];
                    FluidAmount available = tankVolume.getAmount_F().roundedSub(minimum, RoundingMode.DOWN);
                    if (tankVolume.isEmpty() || !available.isPositive() || (volume = inv.extractFluid(t, filter, volume, tankMax = (FluidAmount)maxAmount.roundedSub(volume.getAmount_F(), RoundingMode.DOWN).min(available), simulation)).getAmount_F().isLessThan(maxAmount)) continue;
                    return volume;
                }
                return volume;
            }
        };
    }

    @Override
    public LimitedFixedFluidInv markFinal() {
        this.isImmutable = true;
        return this;
    }

    protected void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalStateException("This object has already been marked as immutable, so no further changes are permitted!");
        }
    }

    @Override
    public LimitedFixedFluidInv copy() {
        SimpleLimitedFixedFluidInv copy = new SimpleLimitedFixedFluidInv(this.delegate);
        System.arraycopy(this.insertionFilters, 0, copy.insertionFilters, 0, this.getTankCount());
        System.arraycopy(this.maxInsertionAmounts, 0, copy.maxInsertionAmounts, 0, this.getTankCount());
        System.arraycopy(this.minimumAmounts, 0, copy.minimumAmounts, 0, this.getTankCount());
        return copy;
    }

    @Override
    public GroupedFluidInv getGroupedInv() {
        return this.groupedInv;
    }

    @Override
    public boolean isFluidValidForTank(int tank, FluidKey fluid) {
        return this.getFilterForTank(tank).matches(fluid);
    }

    @Override
    public FluidFilter getFilterForTank(int tank) {
        FluidFilter filter = this.insertionFilters[tank];
        if (filter != null) {
            return super.getFilterForTank(tank).and(filter);
        }
        return super.getFilterForTank(tank);
    }

    @Override
    public boolean setInvFluid(int tank, FluidVolume to, Simulation simulation) {
        boolean isInserting;
        FluidVolume current = this.getInvFluid(tank);
        boolean same = current.getFluidKey().equals(to.fluidKey);
        boolean isExtracting = !current.isEmpty() && (!same || to.getAmount_F().isLessThan(current.getAmount_F()));
        boolean bl = isInserting = !to.isEmpty() && (!same || to.getAmount_F().isGreaterThan(current.getAmount_F()));
        if (isExtracting && (same ? to.getAmount_F().isLessThan(this.minimumAmounts[tank]) : this.minimumAmounts[tank] != null)) {
            return false;
        }
        if (isInserting) {
            if (!this.isFluidValidForTank(tank, to.getFluidKey())) {
                return false;
            }
            if (this.maxInsertionAmounts[tank] != null && to.getAmount_F().isGreaterThan(this.maxInsertionAmounts[tank])) {
                return false;
            }
        }
        return super.setInvFluid(tank, to, simulation);
    }

    @Override
    public FluidAmount getMaxAmount_F(int tank) {
        FluidAmount sup = super.getMaxAmount_F(tank);
        if (this.maxInsertionAmounts[tank] != null) {
            return (FluidAmount)sup.min(this.maxInsertionAmounts[tank]);
        }
        return sup;
    }

    @Override
    public LimitedFixedFluidInv.FluidTankLimitRule getRule(final int tank) {
        return new LimitedFixedFluidInv.FluidTankLimitRule(){

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule setMinimum(FluidAmount min) {
                if (min != null && !min.isPositive()) {
                    min = null;
                }
                SimpleLimitedFixedFluidInv.this.minimumAmounts[tank] = min;
                return this;
            }

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule limitInsertionAmount(FluidAmount max) {
                if (max != null && !max.isPositive()) {
                    max = FluidAmount.MAX_BUCKETS;
                }
                SimpleLimitedFixedFluidInv.this.maxInsertionAmounts[tank] = max;
                return this;
            }

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule filterInserts(FluidFilter filter) {
                if (filter == ConstantFluidFilter.ANYTHING) {
                    filter = null;
                }
                SimpleLimitedFixedFluidInv.this.insertionFilters[tank] = filter;
                return this;
            }
        };
    }

    @Override
    public LimitedFixedFluidInv.FluidTankLimitRule getSubRule(int from, int to) {
        return new LimitedFixedFluidInv.FluidTankLimitRule(){

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule setMinimum(FluidAmount min) {
                if (min != null && !min.isPositive()) {
                    min = null;
                }
                Arrays.fill(SimpleLimitedFixedFluidInv.this.minimumAmounts, min);
                return this;
            }

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule limitInsertionAmount(FluidAmount max) {
                if (max != null && !max.isPositive()) {
                    max = FluidAmount.MAX_BUCKETS;
                }
                Arrays.fill(SimpleLimitedFixedFluidInv.this.maxInsertionAmounts, max);
                return this;
            }

            @Override
            public LimitedFixedFluidInv.FluidTankLimitRule filterInserts(FluidFilter filter) {
                if (filter == ConstantFluidFilter.ANYTHING) {
                    filter = null;
                }
                Arrays.fill(SimpleLimitedFixedFluidInv.this.insertionFilters, filter);
                return this;
            }
        };
    }
}

