/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.AttributeUtil;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.FluidTransferable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.GroupedFluidInvFixedWrapper;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.Saveable;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SimpleFixedFluidInv
implements FixedFluidInv,
FluidTransferable,
Saveable {
    private static final FluidInvTankChangeListener[] NO_LISTENERS = new FluidInvTankChangeListener[0];
    private static final FluidInvTankChangeListener[] INVALIDATING_LISTENERS = new FluidInvTankChangeListener[0];
    @Deprecated(since="0.6.0", forRemoval=true)
    public final int tankCapacity;
    public final FluidAmount tankCapacity_F;
    protected final class_2371<FluidVolume> tanks;
    private final GroupedFluidInv groupedVersion = new GroupedFluidInvFixedWrapper(this);
    private FluidInvTankChangeListener ownerListener;
    private final Map<FluidInvTankChangeListener, ListenerRemovalToken> listeners = new Object2ObjectLinkedOpenCustomHashMap(class_156.method_655());
    private FluidInvTankChangeListener[] bakedListeners = NO_LISTENERS;

    @Deprecated(since="0.6.0", forRemoval=true)
    public SimpleFixedFluidInv(int invSize, int tankCapacity) {
        this(invSize, FluidAmount.of1620(tankCapacity));
    }

    public SimpleFixedFluidInv(int invSize, FluidAmount tankCapacity) {
        this.tanks = class_2371.method_10213((int)invSize, (Object)FluidVolumeUtil.EMPTY);
        this.tankCapacity = tankCapacity.as1620(RoundingMode.DOWN);
        this.tankCapacity_F = tankCapacity;
    }

    @Override
    public final int getTankCount() {
        return this.tanks.size();
    }

    @Override
    @Deprecated(since="0.6.0", forRemoval=true)
    public int getMaxAmount(int tank) {
        return this.tankCapacity;
    }

    @Override
    public FluidAmount getMaxAmount_F(int tank) {
        return this.tankCapacity_F;
    }

    @Override
    public FluidVolume getInvFluid(int tank) {
        return (FluidVolume)this.tanks.get(tank);
    }

    @Override
    public boolean isFluidValidForTank(int tank, FluidKey fluid) {
        return true;
    }

    @Override
    public FluidFilter getFilterForTank(int tank) {
        Class<?> cls;
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS && (cls = this.getClass()) != SimpleFixedFluidInv.class) {
            try {
                Method method = cls.getMethod("isFluidValidForTank", Integer.TYPE, FluidKey.class);
                if (method.getDeclaringClass() != SimpleFixedFluidInv.class) {
                    throw new IllegalStateException("The subclass " + method.getDeclaringClass() + " has overriden isFluidValidForTank() but hasn't overriden getFilterForTank()");
                }
            }
            catch (ReflectiveOperationException roe) {
                throw new Error("Failed to get the isFluidValidForTank method! I'm not sure what to do now, as this shouldn't happen normally :(", roe);
            }
        }
        return ConstantFluidFilter.ANYTHING;
    }

    @Override
    public boolean setInvFluid(int tank, FluidVolume to, Simulation simulation) {
        if (this.isFluidValidForTank(tank, to.fluidKey) && !to.amount().isGreaterThan(this.getMaxAmount_F(tank))) {
            if (simulation == Simulation.ACTION) {
                FluidVolume before = (FluidVolume)this.tanks.get(tank);
                this.tanks.set(tank, (Object)to);
                this.fireTankChange(tank, before, to);
            }
            return true;
        }
        return false;
    }

    @Override
    public GroupedFluidInv getGroupedInv() {
        return this.groupedVersion;
    }

    @Override
    public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        if (this.bakedListeners == INVALIDATING_LISTENERS) {
            return null;
        }
        ListenerRemovalToken previous = this.listeners.put(listener, removalToken);
        if (previous == null) {
            this.bakeListeners();
        } else assert (previous == removalToken) : "The same listener object must be registered with the same removal token";
        return () -> {
            ListenerRemovalToken token = this.listeners.remove(listener);
            if (token != null) {
                assert (token == removalToken);
                this.bakeListeners();
                removalToken.onListenerRemoved();
            }
        };
    }

    public void setOwnerListener(FluidInvTankChangeListener ownerListener) {
        this.ownerListener = ownerListener;
    }

    private void bakeListeners() {
        this.bakedListeners = this.listeners.keySet().toArray(new FluidInvTankChangeListener[0]);
    }

    public void invalidateListeners() {
        this.bakedListeners = INVALIDATING_LISTENERS;
        ListenerRemovalToken[] removalTokens = this.listeners.values().toArray(new ListenerRemovalToken[0]);
        this.listeners.clear();
        for (ListenerRemovalToken token : removalTokens) {
            token.onListenerRemoved();
        }
        this.bakedListeners = NO_LISTENERS;
    }

    protected final void fireTankChange(int tank, FluidVolume previous, FluidVolume current) {
        FluidInvTankChangeListener[] baked;
        if (this.ownerListener != null) {
            this.ownerListener.onChange(this, tank, previous, current);
        }
        for (FluidInvTankChangeListener listener : baked = this.bakedListeners) {
            listener.onChange(this, tank, previous, current);
        }
    }

    public final class_2487 toTag() {
        return this.toTag(new class_2487());
    }

    public class_2487 toTag(class_2487 tag) {
        class_2499 tanksTag = new class_2499();
        for (FluidVolume volume : this.tanks) {
            tanksTag.add((Object)volume.toTag());
        }
        tag.method_10566("tanks", (class_2520)tanksTag);
        return tag;
    }

    public void fromTag(class_2487 tag) {
        int i;
        class_2499 tanksTag = tag.method_10554("tanks", (int)new class_2487().method_10711());
        for (i = 0; i < tanksTag.size() && i < this.tanks.size(); ++i) {
            this.tanks.set(i, (Object)FluidVolume.fromTag(tanksTag.method_10602(i)));
        }
        for (i = tanksTag.size(); i < this.tanks.size(); ++i) {
            this.tanks.set(i, (Object)FluidVolumeUtil.EMPTY);
        }
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        return this.groupedVersion.attemptInsertion(fluid, simulation);
    }

    @Override
    public FluidAmount getMinimumAcceptedAmount() {
        return this.groupedVersion.getMinimumAcceptedAmount();
    }

    @Override
    public FluidFilter getInsertionFilter() {
        return this.groupedVersion.getInsertionFilter();
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        return this.groupedVersion.attemptExtraction(filter, maxAmount, simulation);
    }

    @Override
    public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
        return this.groupedVersion.attemptAnyExtraction(maxAmount, simulation);
    }
}

