/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.impl.AbstractPartialFixedFluidInvView;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;

public class MappedFixedFluidInvView
extends AbstractPartialFixedFluidInvView {
    private final int[] tanks;
    private final Int2IntMap inverseTankMap;

    public MappedFixedFluidInvView(FixedFluidInvView inv, int[] tanks) {
        super(inv);
        this.tanks = Arrays.copyOf(tanks, tanks.length);
        this.inverseTankMap = new Int2IntOpenHashMap(tanks.length);
        this.inverseTankMap.defaultReturnValue(-1);
        for (int i = 0; i < tanks.length; ++i) {
            int s = tanks[i];
            if (s < 0 || s >= inv.getTankCount()) {
                throw new IllegalArgumentException("Invalid tank index: " + s + ", as it must be between 0 and the tank count of " + inv.getTankCount());
            }
            int prev = this.inverseTankMap.put(s, i);
            if (prev == -1) continue;
            throw new IllegalStateException("Duplicated tank index! (" + s + " appears at both index " + prev + " and " + i + " in " + Arrays.toString(tanks) + ")");
        }
    }

    @Override
    protected int getInternalTank(int tank) {
        return this.tanks[tank];
    }

    @Override
    public int getTankCount() {
        return this.tanks.length;
    }

    @Override
    public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        MappedFixedFluidInvView wrapper = this;
        return this.inv.addListener((realInv, slot, previous, current) -> {
            assert (realInv == this.inv);
            int exposedTank = this.inverseTankMap.get(slot);
            if (exposedTank >= 0) {
                listener.onChange(wrapper, exposedTank, previous, current);
            }
        }, removalToken);
    }
}

