/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidInvAmountChangeListener_F;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilterUtil;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.OpenWrapper;
import java.util.HashSet;
import java.util.Set;

public class GroupedFluidInvViewFixedWrapper
implements GroupedFluidInvView,
OpenWrapper {
    private final FixedFluidInvView inv;

    public GroupedFluidInvViewFixedWrapper(FixedFluidInvView inv) {
        this.inv = inv;
    }

    protected FixedFluidInvView inv() {
        return this.inv;
    }

    public Object getWrapped() {
        return this.inv;
    }

    @Override
    public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
        FluidAmount amount = FluidAmount.ZERO;
        FluidAmount space = FluidAmount.ZERO;
        FluidAmount totalSpace = FluidAmount.ZERO;
        boolean totalSpaceValid = true;
        for (int t = 0; t < this.inv.getTankCount(); ++t) {
            FluidAmount max = this.inv.getMaxAmount_F(t);
            FluidVolume fluid = this.inv.getInvFluid(t);
            if (!fluid.isEmpty()) {
                if (!filter.matches(fluid.fluidKey)) continue;
                amount = amount.roundedAdd(fluid.getAmount_F());
                space = space.roundedAdd(max.roundedSub(fluid.getAmount_F()));
                continue;
            }
            if (!FluidFilterUtil.hasIntersection(filter, this.inv.getFilterForTank(t))) continue;
            totalSpace = totalSpace.roundedAdd(max);
        }
        return new GroupedFluidInvView.FluidInvStatistic(filter, amount, space, totalSpaceValid ? totalSpace : FluidAmount.NEGATIVE_ONE);
    }

    @Override
    public Set<FluidKey> getStoredFluids() {
        HashSet<FluidKey> set = new HashSet<FluidKey>();
        for (int s = 0; s < this.inv.getTankCount(); ++s) {
            FluidVolume fluid = this.inv.getInvFluid(s);
            if (fluid.isEmpty()) continue;
            set.add(fluid.fluidKey);
        }
        return set;
    }

    @Override
    public FluidAmount getTotalCapacity_F() {
        FluidAmount total = FluidAmount.ZERO;
        for (int t = 0; t < this.inv.getTankCount(); ++t) {
            total = total.roundedAdd(this.inv.getMaxAmount_F(t));
        }
        return total;
    }

    @Override
    public ListenerToken addListener_F(FluidInvAmountChangeListener_F listener, ListenerRemovalToken removalToken) {
        return this.inv.addListener((FixedFluidInvView i, int tank, FluidVolume previous, FluidVolume current) -> {
            if (previous.isEmpty()) {
                if (!current.isEmpty()) {
                    FluidAmount currentAmount = this.getAmount_F(current.fluidKey);
                    listener.onChange(this, current.fluidKey, currentAmount.sub(current.amount()), currentAmount);
                }
            } else if (current.isEmpty()) {
                FluidAmount previousAmount = this.getAmount_F(previous.fluidKey);
                FluidAmount prev = previousAmount.add(previous.amount());
                listener.onChange(this, previous.fluidKey, prev, previousAmount);
            } else if (previous.fluidKey == current.fluidKey) {
                FluidAmount currentAmount = this.getAmount_F(current.fluidKey);
                FluidAmount diff = current.amount().sub(previous.amount());
                listener.onChange(this, current.fluidKey, currentAmount.sub(diff), currentAmount);
            } else {
                FluidAmount currentAmount = this.getAmount_F(current.fluidKey);
                FluidAmount previousAmount = this.getAmount_F(previous.fluidKey);
                FluidAmount newPrev = currentAmount.sub(current.amount());
                listener.onChange(this, current.fluidKey, newPrev, currentAmount);
                FluidAmount oldPrev = previousAmount.add(previous.amount());
                listener.onChange(this, previous.fluidKey, oldPrev, previousAmount);
            }
        }, removalToken);
    }
}

