/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.GroupedFluidInvViewFixedWrapper;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.math.RoundingMode;

public class GroupedFluidInvFixedWrapper
extends GroupedFluidInvViewFixedWrapper
implements GroupedFluidInv {
    public GroupedFluidInvFixedWrapper(FixedFluidInv inv) {
        super(inv);
    }

    @Override
    protected FixedFluidInv inv() {
        return (FixedFluidInv)super.inv();
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        if (fluid.isEmpty()) {
            return FluidVolumeUtil.EMPTY;
        }
        fluid = fluid.copy();
        for (int t = 0; t < this.inv().getTankCount(); ++t) {
            fluid = this.inv().insertFluid(t, fluid, simulation);
            if (!fluid.isEmpty()) continue;
            return FluidVolumeUtil.EMPTY;
        }
        return fluid;
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        if (maxAmount.isNegative()) {
            throw new IllegalArgumentException("maxAmount cannot be negative! (was " + maxAmount + ")");
        }
        FluidVolume fluid = FluidVolumeUtil.EMPTY;
        if (maxAmount.isZero()) {
            return fluid;
        }
        for (int t = 0; t < this.inv().getTankCount(); ++t) {
            FluidAmount thisMax = maxAmount.roundedSub(fluid.getAmount_F(), RoundingMode.DOWN);
            fluid = this.inv().extractFluid(t, filter, fluid, thisMax, simulation);
            if (fluid.getAmount_F().isLessThan(maxAmount)) continue;
            return fluid;
        }
        return fluid;
    }
}

