/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidTransferable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;

public final class FilteredFluidTransferable
implements FluidTransferable {
    private final FluidTransferable real;
    public final FluidFilter filter;

    public FilteredFluidTransferable(FluidTransferable real, FluidFilter filter) {
        this.real = real;
        this.filter = filter;
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        FluidFilter realFilter = this.filter.and(filter);
        return this.real.attemptExtraction(realFilter, maxAmount, simulation);
    }

    @Override
    public FluidFilter getInsertionFilter() {
        return this.real.getInsertionFilter().and(this.filter);
    }

    @Override
    public FluidAmount getMinimumAcceptedAmount() {
        return this.real.getMinimumAcceptedAmount();
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        if (!this.filter.matches(fluid.fluidKey)) {
            return fluid;
        }
        return this.real.attemptInsertion(fluid, simulation);
    }

    @Override
    public FluidTransferable filtered(FluidFilter filter) {
        return new FilteredFluidTransferable(this.real, filter.and(this.filter));
    }
}

