/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;

public final class FilteredFluidInsertable
implements FluidInsertable {
    private final FluidInsertable real;
    public final FluidFilter filter;

    public FilteredFluidInsertable(FluidInsertable real, FluidFilter filter) {
        this.real = real;
        this.filter = filter;
    }

    @Override
    public FluidFilter getInsertionFilter() {
        return this.real.getInsertionFilter().and(this.filter);
    }

    @Override
    public FluidAmount getMinimumAcceptedAmount() {
        return this.real.getMinimumAcceptedAmount();
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        if (!this.filter.matches(fluid.fluidKey)) {
            return fluid;
        }
        return this.real.attemptInsertion(fluid, simulation);
    }

    @Override
    public FluidInsertable filtered(FluidFilter filter) {
        return new FilteredFluidInsertable(this.real, filter.and(this.filter));
    }
}

