/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FluidInvAmountChangeListener_F;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CombinedGroupedFluidInvView
extends AbstractCombined<GroupedFluidInvView>
implements GroupedFluidInvView {
    protected final List<? extends GroupedFluidInvView> inventories;

    public CombinedGroupedFluidInvView(List<? extends GroupedFluidInvView> inventories) {
        super(inventories);
        this.inventories = inventories;
    }

    @Override
    public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
        FluidAmount amount = FluidAmount.ZERO;
        FluidAmount spaceAddable = FluidAmount.ZERO;
        FluidAmount spaceTotal = FluidAmount.ZERO;
        for (GroupedFluidInvView groupedFluidInvView : this.inventories) {
            GroupedFluidInvView.FluidInvStatistic stat = groupedFluidInvView.getStatistics(filter);
            amount = amount.roundedAdd(stat.amount_F);
            spaceAddable = spaceAddable.roundedAdd(stat.spaceAddable_F);
            if (stat.spaceTotal_F.equals(FluidAmount.NEGATIVE_ONE)) {
                spaceTotal = FluidAmount.NEGATIVE_ONE;
                continue;
            }
            spaceTotal = spaceTotal.roundedAdd(stat.spaceTotal_F);
        }
        return new GroupedFluidInvView.FluidInvStatistic(filter, amount, spaceAddable, spaceTotal);
    }

    @Override
    public Set<FluidKey> getStoredFluids() {
        HashSet<FluidKey> set = new HashSet<FluidKey>();
        for (GroupedFluidInvView groupedFluidInvView : this.inventories) {
            set.addAll(groupedFluidInvView.getStoredFluids());
        }
        return set;
    }

    @Override
    public FluidAmount getTotalCapacity_F() {
        FluidAmount total = FluidAmount.ZERO;
        for (GroupedFluidInvView groupedFluidInvView : this.inventories) {
            total = total.roundedAdd(groupedFluidInvView.getTotalCapacity_F(), RoundingMode.DOWN);
        }
        return total;
    }

    @Override
    public ListenerToken addListener_F(FluidInvAmountChangeListener_F listener, final ListenerRemovalToken removalToken) {
        final ListenerToken[] tokens = new ListenerToken[this.inventories.size()];
        ListenerRemovalToken ourRemToken = new ListenerRemovalToken(){
            boolean hasAlreadyRemoved = false;

            public void onListenerRemoved() {
                for (ListenerToken token : tokens) {
                    if (token == null) {
                        return;
                    }
                    token.removeListener();
                }
                if (!this.hasAlreadyRemoved) {
                    this.hasAlreadyRemoved = true;
                    removalToken.onListenerRemoved();
                }
            }
        };
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.inventories.get(i).addListener_F((inv, fluidKey, previous, current) -> {
                FluidAmount totalCurrent = this.getAmount_F(fluidKey);
                listener.onChange(this, fluidKey, totalCurrent.roundedSub(current).roundedAdd(previous), totalCurrent);
            }, ourRemToken);
            if (tokens[i] != null) continue;
            for (int j = 0; j < i; ++j) {
                tokens[j].removeListener();
            }
            return null;
        }
        return () -> {
            for (ListenerToken token : tokens) {
                token.removeListener();
            }
        };
    }
}

