/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.CombinedFluidExtractable;
import alexiil.mc.lib.attributes.fluid.impl.CombinedGroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.util.ArrayList;
import java.util.List;

public class CombinedGroupedFluidInv
extends CombinedGroupedFluidInvView
implements GroupedFluidInv {
    public CombinedGroupedFluidInv(List<? extends GroupedFluidInv> inventories) {
        super(inventories);
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        for (GroupedFluidInvView invView : this.inventories) {
            GroupedFluidInv inv = (GroupedFluidInv)invView;
            fluid = inv.attemptInsertion(fluid, simulation);
            if (!fluid.isEmpty()) continue;
            return FluidVolumeUtil.EMPTY;
        }
        return fluid;
    }

    @Override
    public FluidFilter getInsertionFilter() {
        ArrayList<FluidFilter> filters = new ArrayList<FluidFilter>(this.inventories.size());
        for (int i = 0; i < this.inventories.size(); ++i) {
            filters.add(((GroupedFluidInv)this.inventories.get(i)).getInsertionFilter());
        }
        return AggregateFluidFilter.allOf(filters);
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        return CombinedFluidExtractable.attemptExtraction(filter, maxAmount, simulation, this.inventories);
    }
}

