/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import java.util.ArrayList;
import java.util.List;

public final class CombinedFluidInsertable
extends AbstractCombined<FluidInsertable>
implements FluidInsertable {
    public CombinedFluidInsertable(List<? extends FluidInsertable> list) {
        super(list);
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume stack, Simulation simulation) {
        for (FluidInsertable insertable : this.list) {
            stack = insertable.attemptInsertion(stack, simulation);
            if (!stack.isEmpty()) continue;
            return FluidVolumeUtil.EMPTY;
        }
        return stack;
    }

    @Override
    public FluidFilter getInsertionFilter() {
        ArrayList<FluidFilter> filters = new ArrayList<FluidFilter>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            filters.add(((FluidInsertable)this.list.get(i)).getInsertionFilter());
        }
        return AggregateFluidFilter.anyOf(filters);
    }

    @Override
    public FluidAmount getMinimumAcceptedAmount() {
        FluidAmount fa = null;
        for (FluidInsertable fi : this.list) {
            FluidAmount fa2 = fi.getMinimumAcceptedAmount();
            if (fa2 == null) {
                return null;
            }
            if (fa == null) {
                fa = fa2;
                continue;
            }
            fa = (FluidAmount)fa.min(fa2);
        }
        return fa;
    }
}

