/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import java.math.RoundingMode;
import java.util.List;

public final class CombinedFluidExtractable
extends AbstractCombined<FluidExtractable>
implements FluidExtractable {
    public CombinedFluidExtractable(List<? extends FluidExtractable> list) {
        super(list);
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        return CombinedFluidExtractable.attemptExtraction(filter, maxAmount, simulation, this.list);
    }

    static FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation, Iterable<?> iter) {
        if (maxAmount.isNegative()) {
            throw new IllegalArgumentException("maxCount cannot be negative! (was " + maxAmount + ")");
        }
        FluidVolume extracted = FluidVolumeUtil.EMPTY;
        if (maxAmount.isZero()) {
            return extracted;
        }
        for (Object obj : iter) {
            FluidExtractable extractable = (FluidExtractable)obj;
            if (extracted.isEmpty()) {
                extracted = extractable.attemptExtraction(filter, maxAmount, simulation);
                if (extracted.isEmpty()) continue;
                if (!extracted.getAmount_F().isLessThan(maxAmount)) {
                    return extracted;
                }
                filter = extracted.fluidKey.exactFilter;
                continue;
            }
            FluidAmount newMaxAmount = maxAmount.roundedSub(extracted.getAmount_F(), RoundingMode.UP);
            FluidVolume additional = extractable.attemptExtraction(filter, newMaxAmount, simulation);
            if (additional.isEmpty()) continue;
            if ((extracted = FluidVolume.merge(extracted, additional)) == null) {
                throw new IllegalStateException("bad FluidExtractable " + extractable.getClass().getName());
            }
            if (extracted.getAmount_F().isLessThan(maxAmount)) continue;
            return extracted;
        }
        return extracted;
    }
}

