/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.impl;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractCombined;
import java.util.List;

public class CombinedFixedFluidInvView<InvType extends FixedFluidInvView>
extends AbstractCombined<InvType>
implements FixedFluidInvView {
    public final List<? extends InvType> views;
    private final int[] subTankStartIndex;
    private final int invSize;

    public CombinedFixedFluidInvView(List<? extends InvType> views) {
        super(views);
        this.views = views;
        this.subTankStartIndex = new int[views.size()];
        int size = 0;
        for (int i = 0; i < views.size(); ++i) {
            this.subTankStartIndex[i] = size;
            FixedFluidInvView view = (FixedFluidInvView)views.get(i);
            int s = view.getTankCount();
            size += s;
        }
        this.invSize = size;
    }

    @Override
    public int getTankCount() {
        return this.invSize;
    }

    protected InvType getInv(int tank) {
        if (tank < 0) {
            throw new IllegalArgumentException("Tank must be non-negative! (was " + tank + ")");
        }
        for (int i = 0; i < this.subTankStartIndex.length; ++i) {
            int startIndex = this.subTankStartIndex[i];
            if (tank >= startIndex) continue;
            return (InvType)((FixedFluidInvView)this.views.get(i));
        }
        if (tank < this.invSize) {
            return (InvType)((FixedFluidInvView)this.views.get(this.views.size() - 1));
        }
        throw new IllegalArgumentException("Tank must be less than getInvSize() (was " + tank + ", maximum tank is " + (this.invSize - 1) + ")");
    }

    protected int getSubTank(int tank) {
        if (tank < 0) {
            throw new IllegalArgumentException("Tank must be non-negative! (was " + tank + ")");
        }
        for (int i = 0; i < this.subTankStartIndex.length; ++i) {
            int startIndex = this.subTankStartIndex[i];
            if (tank >= startIndex) continue;
            if (i == 0) {
                return tank;
            }
            return tank - this.subTankStartIndex[i - 1];
        }
        if (tank < this.invSize) {
            return tank - this.subTankStartIndex[this.subTankStartIndex.length - 1];
        }
        throw new IllegalArgumentException("Tank must be less than getInvSize() (was " + tank + ", maximum tank is " + (this.invSize - 1) + ")");
    }

    @Override
    public FluidVolume getInvFluid(int tank) {
        return this.getInv(tank).getInvFluid(this.getSubTank(tank));
    }

    @Override
    public boolean isFluidValidForTank(int tank, FluidKey fluid) {
        return this.getInv(tank).isFluidValidForTank(this.getSubTank(tank), fluid);
    }

    @Override
    public FluidFilter getFilterForTank(int tank) {
        return this.getInv(tank).getFilterForTank(this.getSubTank(tank));
    }

    @Override
    @Deprecated(since="0.6.0", forRemoval=true)
    public int getMaxAmount(int tank) {
        return this.getInv(tank).getMaxAmount(this.getSubTank(tank));
    }

    @Override
    public FluidAmount getMaxAmount_F(int tank) {
        return this.getInv(tank).getMaxAmount_F(this.getSubTank(tank));
    }

    @Override
    public ListenerToken addListener(FluidInvTankChangeListener listener, final ListenerRemovalToken removalToken) {
        final ListenerToken[] tokens = new ListenerToken[this.views.size()];
        ListenerRemovalToken ourRemToken = new ListenerRemovalToken(){
            boolean hasAlreadyRemoved = false;

            public void onListenerRemoved() {
                for (ListenerToken token : tokens) {
                    if (token == null) {
                        return;
                    }
                    token.removeListener();
                }
                if (!this.hasAlreadyRemoved) {
                    this.hasAlreadyRemoved = true;
                    removalToken.onListenerRemoved();
                }
            }
        };
        for (int i = 0; i < tokens.length; ++i) {
            int index = i;
            tokens[i] = ((FixedFluidInvView)this.views.get(i)).addListener((inv, subTank, previous, current) -> listener.onChange(this, this.subTankStartIndex[index] + subTank, previous, current), ourRemToken);
            if (tokens[i] != null) continue;
            for (int j = 0; j < i; ++j) {
                tokens[j].removeListener();
            }
            return null;
        }
        return () -> {
            for (ListenerToken token : tokens) {
                token.removeListener();
            }
        };
    }
}

