/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.filter;

import alexiil.mc.lib.attributes.fluid.filter.ReadableFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidRegistryEntry;
import net.minecraft.class_2378;

public abstract class FluidTypeFilter
implements ReadableFluidFilter {
    public static final FluidTypeFilter FLOATING = new FluidFloatingEntryFilter();
    public static final FluidTypeFilter RAW_FLUID = new RawFluidFilter();
    public static final FluidTypeFilter POTION = FluidTypeFilter.get(class_2378.field_11143);

    FluidTypeFilter() {
    }

    public static final FluidTypeFilter get(class_2378<?> registry) {
        return new RegisteredTypeFilter(registry);
    }

    public static final class RegisteredTypeFilter
    extends FluidTypeFilter {
        public final class_2378<?> registry;

        RegisteredTypeFilter(class_2378<?> registry) {
            this.registry = registry;
        }

        @Override
        public boolean matches(FluidKey fluid) {
            FluidEntry entry = fluid.entry;
            if (entry instanceof FluidRegistryEntry) {
                return ((FluidRegistryEntry)entry).getBackingRegistry() == this.registry;
            }
            return false;
        }

        public String toString() {
            return "FluidRegistryEntry of " + FluidRegistryEntry.getFullRegistryName(this.registry);
        }
    }

    public static final class FluidFloatingEntryFilter
    extends FluidTypeFilter {
        FluidFloatingEntryFilter() {
            if (FLOATING != null) {
                throw new Error("Don't manually construct FluidFloatingEntryFilter!");
            }
        }

        @Override
        public boolean matches(FluidKey fluid) {
            return fluid.entry instanceof FluidEntry.FluidFloatingEntry;
        }

        public String toString() {
            return "any FluidFloatingEntry";
        }
    }

    public static final class RawFluidFilter
    extends FluidTypeFilter {
        RawFluidFilter() {
            if (RAW_FLUID != null) {
                throw new Error("Don't manually construct RawFluidFilter!");
            }
        }

        @Override
        public boolean matches(FluidKey fluid) {
            return fluid.getRawFluid() != null;
        }

        public String toString() {
            return "FluidKey.getRawFluid()!=null";
        }
    }
}

