/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.filter;

import alexiil.mc.lib.attributes.AggregateFilterType;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidSetFilter;
import alexiil.mc.lib.attributes.fluid.filter.InvertedFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ReadableFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ResolvableFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public final class FluidFilterUtil {
    private FluidFilterUtil() {
    }

    public static boolean hasIntersection(FluidFilter a, FluidFilter b) {
        FluidFilter combined = a.and(b);
        return combined != ConstantFluidFilter.NOTHING;
    }

    @Nullable
    public static Set<FluidKey> decomposeFilter(FluidFilter filter) {
        if (!(filter instanceof ReadableFluidFilter)) {
            return null;
        }
        if (filter == ConstantFluidFilter.NOTHING) {
            return Collections.emptySet();
        }
        if (filter == ConstantFluidFilter.ANYTHING) {
            return null;
        }
        if (filter instanceof ExactFluidFilter) {
            return Collections.singleton(((ExactFluidFilter)filter).fluid);
        }
        if (filter instanceof AggregateFluidFilter) {
            AggregateFluidFilter aggregate = (AggregateFluidFilter)filter;
            if (aggregate.type == AggregateFilterType.ALL) {
                Set<FluidKey> soFar = null;
                for (int i = 0; i < aggregate.getFilterCount(); ++i) {
                    Set<FluidKey> decomposed = FluidFilterUtil.decomposeFilter(aggregate.getFilter(i));
                    if (decomposed == null) {
                        return null;
                    }
                    if (soFar == null) {
                        soFar = decomposed;
                        continue;
                    }
                    soFar.retainAll(decomposed);
                }
                return soFar;
            }
            HashSet<FluidKey> matches = new HashSet<FluidKey>();
            for (int i = 0; i < aggregate.getFilterCount(); ++i) {
                Set<FluidKey> decomposed = FluidFilterUtil.decomposeFilter(aggregate.getFilter(i));
                if (decomposed == null) {
                    return null;
                }
                matches.addAll(decomposed);
            }
            return matches;
        }
        ReadableFluidFilter.checkValidity((ReadableFluidFilter)filter);
        return null;
    }

    public static Set<FluidKey> findIntersection(FluidFilter filter, Set<FluidKey> set) {
        return FluidFilterUtil.findIntersection(filter, set, false);
    }

    public static Set<FluidKey> findIntersection(FluidFilter filter, Set<FluidKey> set, boolean resolve) {
        if (filter == ConstantFluidFilter.NOTHING) {
            return Collections.emptySet();
        }
        if (filter == ConstantFluidFilter.ANYTHING) {
            return set;
        }
        if (set.isEmpty()) {
            return set;
        }
        int setSize = set.size();
        if (setSize == 1) {
            FluidKey fluid = set.iterator().next();
            return set.contains(fluid) ? Collections.singleton(fluid) : Collections.emptySet();
        }
        if (setSize <= 4) {
            return FluidFilterUtil.simpleIntersectionTest(filter, set);
        }
        if (resolve && filter instanceof ResolvableFluidFilter) {
            filter = ((ResolvableFluidFilter)filter).resolve();
        }
        if (filter instanceof ReadableFluidFilter) {
            if (filter instanceof ExactFluidFilter) {
                FluidKey fluid = ((ExactFluidFilter)filter).fluid;
                return set.contains(fluid) ? Collections.singleton(fluid) : Collections.emptySet();
            }
            if (filter instanceof FluidSetFilter) {
                Set<FluidKey> filterSet = ((FluidSetFilter)filter).getFluids();
                HashSet<FluidKey> subSet = new HashSet<FluidKey>();
                Set<FluidKey> smaller = filterSet.size() < setSize ? filterSet : set;
                subSet.addAll(smaller);
                subSet.retainAll(smaller == set ? filterSet : set);
                return subSet;
            }
            if (filter instanceof InvertedFluidFilter) {
                FluidFilter not = ((InvertedFluidFilter)filter).delegate;
                if (resolve && not instanceof ResolvableFluidFilter) {
                    not = ((ResolvableFluidFilter)not).resolve();
                }
            }
            ReadableFluidFilter.checkValidity((ReadableFluidFilter)filter);
        }
        return FluidFilterUtil.simpleIntersectionTest(filter, set);
    }

    private static Set<FluidKey> simpleIntersectionTest(FluidFilter filter, Set<FluidKey> set) {
        HashSet<FluidKey> subSet = new HashSet<FluidKey>();
        for (FluidKey key : set) {
            if (!filter.matches(key)) continue;
            subSet.add(key);
        }
        return subSet;
    }
}

