/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.filter;

import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.InvertedFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import java.util.function.Predicate;

@FunctionalInterface
public interface FluidFilter {
    public boolean matches(FluidKey var1);

    default public FluidFilter negate() {
        return new InvertedFluidFilter(this);
    }

    default public FluidFilter and(FluidFilter other) {
        return AggregateFluidFilter.and(this, other);
    }

    default public FluidFilter or(FluidFilter other) {
        return AggregateFluidFilter.or(this, other);
    }

    default public Predicate<FluidKey> asPredicate() {
        final FluidFilter filter = this;
        return new Predicate<FluidKey>(){

            @Override
            public boolean test(FluidKey stack) {
                if (stack == null || stack.isEmpty()) {
                    return false;
                }
                return filter.matches(stack);
            }

            @Override
            public Predicate<FluidKey> negate() {
                return filter.negate().asPredicate();
            }

            @Override
            public Predicate<FluidKey> and(Predicate<? super FluidKey> other) {
                if (other instanceof FluidFilter) {
                    return filter.and((FluidFilter)((Object)other)).asPredicate();
                }
                return Predicate.super.and(other);
            }

            @Override
            public Predicate<FluidKey> or(Predicate<? super FluidKey> other) {
                if (other instanceof FluidFilter) {
                    return filter.or((FluidFilter)((Object)other)).asPredicate();
                }
                return Predicate.super.or(other);
            }

            public String toString() {
                return "{FluidFilterWrapper for " + filter + "}";
            }
        };
    }
}

