/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.filter;

import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ReadableFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;

public enum ConstantFluidFilter implements ReadableFluidFilter
{
    ANYTHING(true),
    NOTHING(false);

    private final boolean result;

    private ConstantFluidFilter(boolean result) {
        this.result = result;
    }

    public static ConstantFluidFilter of(boolean result) {
        return result ? ANYTHING : NOTHING;
    }

    public String toString() {
        return "ConstantFluidFilter." + this.name();
    }

    @Override
    public boolean matches(FluidKey fluid) {
        if (fluid.isEmpty()) {
            throw new IllegalArgumentException("You should never test a FluidFilter with an empty fluid!");
        }
        return this.result;
    }

    @Override
    public FluidFilter negate() {
        return ConstantFluidFilter.of(!this.result);
    }

    @Override
    public FluidFilter and(FluidFilter other) {
        if (this.result) {
            return other;
        }
        return NOTHING;
    }

    @Override
    public FluidFilter or(FluidFilter other) {
        if (this.result) {
            return ANYTHING;
        }
        return other;
    }
}

