/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.filter;

import alexiil.mc.lib.attributes.AggregateFilterType;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidSetFilter;
import alexiil.mc.lib.attributes.fluid.filter.ReadableFluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class AggregateFluidFilter
implements ReadableFluidFilter,
Iterable<FluidFilter> {
    public final AggregateFilterType type;
    private final FluidFilter[] filters;

    public AggregateFluidFilter(AggregateFilterType type, FluidFilter ... filters) {
        this(type, filters, true);
    }

    private AggregateFluidFilter(AggregateFilterType type, FluidFilter[] filters, boolean copy) {
        if (filters.length < 2) {
            throw new IllegalArgumentException("There's no reason to construct an aggregate stack filter that matches " + filters.length + " filters!");
        }
        this.type = type;
        this.filters = copy ? Arrays.copyOf(filters, filters.length) : filters;
    }

    public static FluidFilter and(FluidFilter filterA, FluidFilter filterB) {
        return AggregateFluidFilter.combine(AggregateFilterType.ALL, filterA, filterB);
    }

    public static FluidFilter or(FluidFilter filterA, FluidFilter filterB) {
        return AggregateFluidFilter.combine(AggregateFilterType.ANY, filterA, filterB);
    }

    public static FluidFilter combine(AggregateFilterType type, FluidFilter filterA, FluidFilter filterB) {
        boolean all;
        boolean bl = all = type == AggregateFilterType.ALL;
        if (filterA == filterB) {
            return filterA;
        }
        if (filterA == ConstantFluidFilter.ANYTHING) {
            return all ? filterB : ConstantFluidFilter.ANYTHING;
        }
        if (filterB == ConstantFluidFilter.ANYTHING) {
            return all ? filterA : ConstantFluidFilter.ANYTHING;
        }
        if (filterA == ConstantFluidFilter.NOTHING) {
            return all ? ConstantFluidFilter.NOTHING : filterB;
        }
        if (filterB == ConstantFluidFilter.NOTHING) {
            return all ? ConstantFluidFilter.NOTHING : filterA;
        }
        if (filterA instanceof AggregateFluidFilter && ((AggregateFluidFilter)filterA).type == type) {
            if (filterB instanceof AggregateFluidFilter && ((AggregateFluidFilter)filterB).type == type) {
                FluidFilter[] filtersA = ((AggregateFluidFilter)filterA).filters;
                FluidFilter[] filtersB = ((AggregateFluidFilter)filterB).filters;
                FluidFilter[] filters = new FluidFilter[filtersA.length + filtersB.length];
                System.arraycopy(filtersA, 0, filters, 0, filtersA.length);
                System.arraycopy(filtersB, 0, filters, filtersA.length, filtersB.length);
                return new AggregateFluidFilter(type, filters);
            }
            FluidFilter[] from = ((AggregateFluidFilter)filterA).filters;
            FluidFilter[] filters = new FluidFilter[from.length + 1];
            System.arraycopy(from, 0, filters, 0, from.length);
            filters[from.length] = filterB;
            return new AggregateFluidFilter(type, filters, false);
        }
        if (filterB instanceof AggregateFluidFilter && ((AggregateFluidFilter)filterB).type == type) {
            FluidFilter[] from = ((AggregateFluidFilter)filterB).filters;
            FluidFilter[] filters = new FluidFilter[from.length + 1];
            System.arraycopy(from, 0, filters, 0, from.length);
            filters[from.length] = filterA;
            return new AggregateFluidFilter(type, filters, false);
        }
        if (filterA instanceof ExactFluidFilter) {
            FluidKey exactA = ((ExactFluidFilter)filterA).fluid;
            if (filterB.matches(exactA)) {
                return filterA;
            }
            if (all) {
                return ConstantFluidFilter.NOTHING;
            }
            if (filterB instanceof ExactFluidFilter) {
                HashSet<FluidKey> set = new HashSet<FluidKey>();
                set.add(exactA);
                set.add(((ExactFluidFilter)filterB).fluid);
                return new FluidSetFilter(set);
            }
            if (filterB instanceof FluidSetFilter) {
                HashSet<FluidKey> set = new HashSet<FluidKey>();
                set.add(exactA);
                set.addAll(((FluidSetFilter)filterB).getFluids());
                return new FluidSetFilter(set);
            }
        }
        if (filterB instanceof ExactFluidFilter) {
            FluidKey exactB = ((ExactFluidFilter)filterB).fluid;
            if (filterA.matches(exactB)) {
                return filterB;
            }
            if (all) {
                return ConstantFluidFilter.NOTHING;
            }
            if (filterA instanceof FluidSetFilter) {
                HashSet<FluidKey> set = new HashSet<FluidKey>();
                set.add(exactB);
                set.addAll(((FluidSetFilter)filterA).getFluids());
                return new FluidSetFilter(set);
            }
        }
        return new AggregateFluidFilter(type, new FluidFilter[]{filterA, filterB}, false);
    }

    public static FluidFilter allOf(FluidFilter ... filters) {
        return AggregateFluidFilter.combine(AggregateFilterType.ALL, filters);
    }

    public static FluidFilter anyOf(FluidFilter ... filters) {
        return AggregateFluidFilter.combine(AggregateFilterType.ANY, filters);
    }

    public static FluidFilter combine(AggregateFilterType type, FluidFilter ... filters) {
        return AggregateFluidFilter.combine(type, Arrays.asList(filters));
    }

    public static FluidFilter allOf(List<? extends FluidFilter> filters) {
        return AggregateFluidFilter.combine(AggregateFilterType.ALL, filters);
    }

    public static FluidFilter anyOf(List<? extends FluidFilter> filters) {
        return AggregateFluidFilter.combine(AggregateFilterType.ANY, filters);
    }

    public static FluidFilter combine(AggregateFilterType type, List<? extends FluidFilter> filters) {
        if (!(filters instanceof RandomAccess)) {
            filters = Arrays.asList(filters.toArray(new FluidFilter[0]));
        }
        switch (filters.size()) {
            case 0: {
                return ConstantFluidFilter.ANYTHING;
            }
            case 1: {
                return filters.get(0);
            }
            case 2: {
                return AggregateFluidFilter.combine(type, filters.get(0), filters.get(1));
            }
        }
        FluidFilter filter = filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter = AggregateFluidFilter.combine(type, filter, filters.get(i));
        }
        return filter;
    }

    @Override
    public boolean matches(FluidKey fluid) {
        if (this.type == AggregateFilterType.ALL) {
            for (FluidFilter filter : this.filters) {
                if (filter.matches(fluid)) continue;
                return false;
            }
            return true;
        }
        for (FluidFilter filter : this.filters) {
            if (!filter.matches(fluid)) continue;
            return true;
        }
        return false;
    }

    public int getFilterCount() {
        return this.filters.length;
    }

    public FluidFilter getFilter(int index) {
        return this.filters[index];
    }

    @Override
    public Iterator<FluidFilter> iterator() {
        return Iterators.forArray((Object[])this.filters);
    }
}

