/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.compat.mod.vanilla;

import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidContainerRegistry;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.GroupedFluidInvFixedWrapper;
import alexiil.mc.lib.attributes.fluid.volume.BiomeSourcedFluidVolume;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.fluid.volume.PotionFluidKey;
import alexiil.mc.lib.attributes.misc.AbstractItemBasedAttribute;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_5556;

public final class VanillaFluidCompat {
    private VanillaFluidCompat() {
    }

    public static void load() {
        BiomeSourcedFluidVolume waterVolume = FluidKeys.WATER.withAmount(FluidAmount.BUCKET);
        FluidContainerRegistry.mapContainer(class_1802.field_8550, class_1802.field_8705, waterVolume);
        FluidVolume lavaVolume = FluidKeys.LAVA.withAmount(FluidAmount.BUCKET);
        FluidContainerRegistry.mapContainer(class_1802.field_8550, class_1802.field_8187, lavaVolume);
        PotionBottleFillHandler potions = PotionBottleFillHandler.INSTANCE;
        FluidContainerRegistry.registerFillHandler(class_1802.field_8469, FluidKeys.WATER, potions);
        FluidContainerRegistry.registerFillHandler(class_1802.field_8469, PotionFluidKey.class, false, (FluidContainerRegistry.FluidFillHandler)potions);
        FluidAttributes.forEachGroupedInv(attr -> attr.setItemAdder(AttributeSourceType.INSTANCE, class_1802.field_8574, (ref, excess, list) -> list.offer((Object)new PotionItemInv((Reference<class_1799>)ref, (LimitedConsumer<class_1799>)excess))));
    }

    public static void registerCauldronAttributes(class_2248 cauldron, class_3611 fluid) {
        VanillaFluidCompat.registerCauldronAttributes(cauldron, FluidKeys.get(fluid));
    }

    public static void registerCauldronAttributes(class_2248 cauldron, FluidKey fluid) {
        FluidAttributes.forEachInv(attr -> attr.setBlockAdder(AttributeSourceType.COMPAT_WRAPPER, cauldron, (w, p, state, list) -> list.offer((Object)new CauldronBlockInv(w, p, cauldron, fluid))));
    }

    static final class PotionBottleFillHandler
    extends FluidContainerRegistry.FluidFillHandler {
        static final PotionBottleFillHandler INSTANCE = new PotionBottleFillHandler();

        private PotionBottleFillHandler() {
            super(FluidAmount.BOTTLE);
        }

        @Override
        protected FluidVolume insert(class_1799 stack, FluidVolume fluid, Simulation simulation, FluidContainerRegistry.FluidFillHandler.StackReturnFunc stackReturn) {
            class_1842 potion = fluid.getFluidKey() == FluidKeys.WATER ? class_1847.field_8991 : ((PotionFluidKey)fluid.getFluidKey()).potion;
            FluidVolume newFluid = fluid.copy();
            class_1799 oldStack = stack;
            stack.method_7934(1);
            newFluid.split(FluidAmount.BOTTLE);
            class_1799 newStack = new class_1799((class_1935)class_1802.field_8574);
            class_1844.method_8061((class_1799)newStack, (class_1842)potion);
            return stackReturn.returnStacks(oldStack, newStack) ? newFluid : fluid;
        }

        @Override
        protected FluidAmount getCapacity(FluidFilter filter) {
            return FluidAmount.BOTTLE;
        }
    }

    static final class CauldronBlockInv
    implements FixedFluidInv {
        final class_1937 world;
        final class_2338 pos;
        final class_2248 cauldronBlock;
        final FluidKey cauldronFluid;
        GroupedFluidInv grouped;

        public CauldronBlockInv(class_1937 w, class_2338 p, class_2248 cauldronBlock, FluidKey fluid) {
            this.world = w;
            this.pos = p;
            this.cauldronBlock = cauldronBlock;
            this.cauldronFluid = fluid;
        }

        private boolean isValid(class_2680 state) {
            return state.method_26204() == this.cauldronBlock && state.method_28498((class_2769)class_5556.field_27206);
        }

        @Override
        public int getTankCount() {
            class_2680 state = this.world.method_8320(this.pos);
            return this.isValid(state) ? 1 : 0;
        }

        @Override
        public FluidVolume getInvFluid(int tank) {
            class_2680 state = this.world.method_8320(this.pos);
            if (this.isValid(state)) {
                int level = (Integer)state.method_11654((class_2769)class_5556.field_27206);
                return this.cauldronFluid.withAmount(FluidAmount.of(level, 3L));
            }
            return FluidVolumeUtil.EMPTY;
        }

        @Override
        public boolean isFluidValidForTank(int tank, FluidKey fluid) {
            return this.cauldronFluid == fluid;
        }

        @Override
        public FluidFilter getFilterForTank(int tank) {
            return this.cauldronFluid.exactFilter;
        }

        @Override
        public boolean setInvFluid(int tank, FluidVolume to, Simulation simulation) {
            class_2680 state = this.world.method_8320(this.pos);
            if (this.isValid(state)) {
                int level;
                if (to.amount().isZero()) {
                    level = 0;
                } else if (FluidAmount.ONE.equals(to.amount())) {
                    level = 3;
                } else if (to.amount().whole == 0L && to.amount().denominator == 3L) {
                    level = (int)to.amount().numerator;
                } else {
                    return false;
                }
                if (simulation.isAction()) {
                    this.world.method_8501(this.pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level)));
                }
            }
            return false;
        }

        @Override
        public FluidVolume insertFluid(int tank, FluidVolume volume, Simulation simulation) {
            if (volume.fluidKey != this.cauldronFluid || volume.isEmpty()) {
                return volume;
            }
            if (volume.amount().isLessThan(FluidAmount.BOTTLE)) {
                return volume;
            }
            class_2680 state = this.world.method_8320(this.pos);
            if (!this.isValid(state)) {
                return volume;
            }
            int current = (Integer)state.method_11654((class_2769)class_5556.field_27206);
            int space = 3 - current;
            if (space <= 0) {
                return volume;
            }
            int bottles = volume.amount().asInt(3, RoundingMode.DOWN);
            assert (bottles >= 1);
            FluidVolume incomingFluid = volume.copy();
            int additional = Math.min(space, bottles);
            incomingFluid.split(FluidAmount.of(additional, 3L));
            if (simulation.isAction()) {
                this.world.method_8501(this.pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(current + additional)));
            }
            return incomingFluid;
        }

        @Override
        public FluidVolume extractFluid(int tank, FluidFilter filter, FluidVolume mergeWith, FluidAmount maxAmount, Simulation simulation) {
            if (!mergeWith.isEmpty() && this.cauldronFluid != mergeWith.fluidKey) {
                return mergeWith;
            }
            if (filter != null && !filter.matches(FluidKeys.WATER)) {
                return mergeWith;
            }
            if (maxAmount.isLessThan(FluidAmount.BOTTLE)) {
                return mergeWith;
            }
            class_2680 state = this.world.method_8320(this.pos);
            if (!this.isValid(state)) {
                return mergeWith;
            }
            int current = (Integer)state.method_11654((class_2769)class_5556.field_27206);
            if (current <= 0) {
                return mergeWith;
            }
            int maxBottles = maxAmount.asInt(3, RoundingMode.DOWN);
            assert (maxBottles >= 1);
            int extractedBottles = Math.min(maxBottles, current);
            int left = current - extractedBottles;
            FluidVolume extracted = this.cauldronFluid.withAmount(FluidAmount.of(extractedBottles, 3L));
            if (simulation.isAction()) {
                this.world.method_8501(this.pos, (class_2680)state.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(left)));
            }
            if (mergeWith.isEmpty()) {
                return extracted;
            }
            mergeWith.merge(extracted, Simulation.ACTION);
            return mergeWith;
        }

        @Override
        public GroupedFluidInv getGroupedInv() {
            if (this.grouped == null) {
                this.grouped = new GroupedFluidInvFixedWrapper(this){

                    @Override
                    public FluidAmount getMinimumAcceptedAmount() {
                        return FluidAmount.BOTTLE;
                    }

                    @Override
                    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                        return this.insertFluid(0, fluid, simulation);
                    }
                };
            }
            return this.grouped;
        }
    }

    static final class PotionItemInv
    extends AbstractItemBasedAttribute
    implements GroupedFluidInv {
        public PotionItemInv(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
            super(stackRef, excessStacks);
        }

        @Override
        public Set<FluidKey> getStoredFluids() {
            class_1799 stack = (class_1799)this.stackRef.get();
            if (stack.method_7909() != class_1802.field_8574) {
                return Collections.emptySet();
            }
            FluidKey key = FluidKeys.get(class_1844.method_8063((class_1799)stack));
            return key.isEmpty() ? Collections.emptySet() : Collections.singleton(key);
        }

        @Override
        public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
            class_1799 stack = (class_1799)this.stackRef.get();
            if (stack.method_7909() != class_1802.field_8574) {
                return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
            }
            FluidKey key = FluidKeys.get(class_1844.method_8063((class_1799)stack));
            if (key.isEmpty() || !filter.matches(key)) {
                return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
            }
            return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.BOTTLE.mul(stack.method_7947()), FluidAmount.ZERO, FluidAmount.ZERO);
        }

        @Override
        public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
            return fluid;
        }

        @Override
        public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
            if (maxAmount.isLessThan(FluidAmount.BOTTLE)) {
                return FluidVolumeUtil.EMPTY;
            }
            class_1799 stack = (class_1799)this.stackRef.get();
            if (stack.method_7909() != class_1802.field_8574) {
                return FluidVolumeUtil.EMPTY;
            }
            FluidKey key = FluidKeys.get(class_1844.method_8063((class_1799)stack));
            if (key.isEmpty() || !filter.matches(key)) {
                return FluidVolumeUtil.EMPTY;
            }
            class_1799 oldStack = stack.method_7972();
            oldStack.method_7934(1);
            if (this.setStacks(simulation, oldStack, new class_1799((class_1935)class_1802.field_8469))) {
                return key.withAmount(FluidAmount.BOTTLE);
            }
            return FluidVolumeUtil.EMPTY;
        }
    }
}

