/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.compat.mod.silk;

import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import io.github.prospector.silk.fluid.FluidContainer;
import io.github.prospector.silk.fluid.FluidContainerProvider;
import io.github.prospector.silk.fluid.FluidInstance;
import io.github.prospector.silk.util.ActionType;
import java.math.RoundingMode;
import net.minecraft.class_1936;
import net.minecraft.class_2350;
import net.minecraft.class_3611;

public final class SilkFluidCompat {
    private SilkFluidCompat() {
    }

    public static void load() {
        FluidAttributes.INSERTABLE.putBlockClassAdder(AttributeSourceType.COMPAT_WRAPPER, FluidContainerProvider.class, true, (world, pos, state, list) -> {
            FluidContainerProvider provider;
            FluidContainer container;
            if (state.method_26204() instanceof FluidContainerProvider && (container = (provider = (FluidContainerProvider)state.method_26204()).getContainer(state, (class_1936)world, pos)) != null) {
                list.add((fluid, simulation) -> {
                    class_3611 mcFluid;
                    class_2350 dir = list.getSearchDirection();
                    if (dir != null) {
                        dir = dir.method_10153();
                    }
                    if ((mcFluid = fluid.fluidKey.getRawFluid()) != null) {
                        int amount = fluid.getAmount_F().as1620(RoundingMode.DOWN);
                        int amountMoved = container.tryPartialInsertFluid(dir, mcFluid, amount, SilkFluidCompat.toSilkAction(simulation));
                        fluid = fluid.copy();
                        FluidVolume removed = fluid.split(FluidAmount.of1620(amountMoved));
                        assert (removed.amount().as1620(RoundingMode.UNNECESSARY) == amountMoved);
                    }
                    return fluid;
                });
            }
        });
        FluidAttributes.EXTRACTABLE.putBlockClassAdder(AttributeSourceType.COMPAT_WRAPPER, FluidContainerProvider.class, true, (world, pos, state, list) -> {
            FluidContainerProvider provider;
            FluidContainer container;
            if (state.method_26204() instanceof FluidContainerProvider && (container = (provider = (FluidContainerProvider)state.method_26204()).getContainer(state, (class_1936)world, pos)) != null) {
                list.add((Object)new FluidExtractable(){

                    @Override
                    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                        class_2350 dir = list.getSearchDirection();
                        if (dir != null) {
                            dir = dir.method_10153();
                        }
                        for (FluidInstance containedFluid : container.getFluids(dir)) {
                            int extracted;
                            class_3611 rawFluid = containedFluid.getFluid();
                            FluidKey fluidKey = FluidKeys.get(rawFluid);
                            if (fluidKey == null || !filter.matches(fluidKey) || (extracted = container.tryPartialExtractFluid(dir, rawFluid, maxAmount.as1620(RoundingMode.DOWN), SilkFluidCompat.toSilkAction(simulation))) <= 0) continue;
                            return fluidKey.withAmount(FluidAmount.of1620(extracted));
                        }
                        return FluidVolumeUtil.EMPTY;
                    }
                });
            }
        });
    }

    private static ActionType toSilkAction(Simulation simulation) {
        return simulation == Simulation.ACTION ? ActionType.PERFORM : ActionType.SIMULATE;
    }
}

