/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.amount;

import alexiil.mc.lib.attributes.fluid.amount.BigFluidAmount;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import java.math.BigInteger;
import javax.annotation.Nullable;

abstract class FluidAmountBase<T extends FluidAmountBase<T>>
implements Comparable<T> {
    FluidAmountBase() {
    }

    public abstract boolean isZero();

    public abstract boolean isNegative();

    public abstract boolean isPositive();

    public abstract int sign();

    public abstract FluidAmount asLongIntExact();

    public abstract BigFluidAmount asBigInt();

    public abstract T getDivisor();

    @Override
    public abstract int compareTo(@Nullable T var1);

    public boolean isGreaterThan(@Nullable T other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(@Nullable T other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLessThan(@Nullable T other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqual(@Nullable T other) {
        return this.compareTo(other) <= 0;
    }

    public abstract double asInexactDouble();

    abstract BigInteger _bigWhole();

    abstract BigInteger _bigNumerator();

    abstract BigInteger _bigDenominator();

    abstract T _this();

    public abstract T negate();

    public abstract T reciprocal();

    public BigFluidAmount gcd(FluidAmount other) {
        return this._bigGcd(other);
    }

    public BigFluidAmount gcd(BigFluidAmount other) {
        return this._bigGcd(other);
    }

    public abstract T lcm(T var1);

    public T min(T other) {
        if (((FluidAmountBase)other).isLessThan(this._this())) {
            return other;
        }
        return this._this();
    }

    public T max(T other) {
        if (((FluidAmountBase)other).isGreaterThan(this._this())) {
            return other;
        }
        return this._this();
    }

    static FluidAmount _roundToSmall(BigInteger whole, BigInteger numerator, BigInteger denominator) {
        BigInteger[] divRem = numerator.divideAndRemainder(denominator);
        BigInteger div = divRem[0];
        BigInteger rem = divRem[1];
        if (div.signum() != 0) {
            whole = whole.add(div);
            numerator = rem;
        }
        BigInteger GCD = numerator.gcd(denominator);
        numerator = numerator.divide(GCD);
        denominator = denominator.divide(GCD);
        return FluidAmountBase._toSmall(whole, numerator, denominator);
    }

    static FluidAmount _toSmall(BigInteger whole, BigInteger numerator, BigInteger denominator) {
        return FluidAmount.createDirect(whole.longValueExact(), numerator.longValueExact(), denominator.longValueExact());
    }

    BigFluidAmount _bigGcd(FluidAmountBase<?> by) {
        BigInteger d1 = this._bigDenominator();
        BigInteger d2 = by._bigDenominator();
        BigInteger n1 = this._bigWhole().multiply(d1).add(this._bigNumerator());
        BigInteger n2 = by._bigWhole().multiply(d2).add(by._bigNumerator());
        BigInteger b1 = n1.multiply(d2);
        BigInteger b2 = n2.multiply(d1);
        return BigFluidAmount.of(b1.gcd(b2), d1.multiply(d2));
    }

    static BigInteger lcm(BigInteger a, BigInteger b) {
        BigInteger gcd = a.gcd(b);
        if (gcd.signum() == 0) {
            return gcd;
        }
        return a.divide(gcd).multiply(b);
    }

    BigFluidAmount _bigLcm(FluidAmountBase<?> by) {
        BigFluidAmount gcd = this._bigGcd(by);
        if (gcd.isZero()) {
            return gcd;
        }
        return this._bigDiv(gcd)._bigMul(by);
    }

    BigFluidAmount _bigAdd(FluidAmountBase<?> by) {
        BigInteger w1 = this._bigWhole();
        BigInteger w2 = by._bigWhole();
        BigInteger n1 = this._bigNumerator();
        BigInteger n2 = by._bigNumerator();
        BigInteger d1 = this._bigDenominator();
        BigInteger d2 = by._bigDenominator();
        BigInteger d = d1.multiply(d2);
        BigInteger n = n1.multiply(d2).add(n2.multiply(d1));
        return BigFluidAmount.of(w1.add(w2), n, d);
    }

    BigFluidAmount _bigSub(FluidAmountBase<?> other) {
        return this._bigAdd((FluidAmountBase<?>)other.negate());
    }

    BigFluidAmount _bigMul(FluidAmountBase<?> other) {
        BigInteger w1 = this._bigWhole();
        BigInteger w2 = other._bigWhole();
        BigInteger w3 = w1.multiply(w2);
        BigInteger n1 = this._bigNumerator();
        BigInteger n2 = other._bigNumerator();
        BigInteger d1 = this._bigDenominator();
        BigInteger d2 = other._bigDenominator();
        BigInteger d3 = d1.multiply(d2);
        BigInteger n3 = w1.multiply(n2).multiply(d1).add(w2.multiply(n1).multiply(d2)).add(n1.multiply(n2));
        return BigFluidAmount.of(w3, n3, d3);
    }

    BigFluidAmount _bigDiv(FluidAmountBase<?> other) {
        BigInteger w1 = this._bigWhole();
        BigInteger w2 = other._bigWhole();
        BigInteger n1 = this._bigNumerator();
        BigInteger n2 = other._bigNumerator();
        BigInteger d1 = this._bigDenominator();
        BigInteger d2 = other._bigDenominator();
        BigInteger numerator = n1.multiply(d2).add(w1.multiply(d1).multiply(d2));
        BigInteger denominator = n2.multiply(d1).add(w2.multiply(d1).multiply(d2));
        return BigFluidAmount.of(numerator, denominator);
    }

    BigFluidAmount _bigReciprocal() {
        return FluidAmount.ONE._bigDiv(this);
    }
}

