/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.amount;

import alexiil.mc.lib.attributes.fluid.amount.BigFluidAmount;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmountBase;
import com.google.common.math.LongMath;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public final class FluidAmount
extends FluidAmountBase<FluidAmount> {
    public static final FluidAmount ZERO = FluidAmount.ofWhole(0L);
    public static final FluidAmount ONE = FluidAmount.ofWhole(1L);
    public static final FluidAmount NEGATIVE_ONE = FluidAmount.ofWhole(-1L);
    public static final FluidAmount A_MILLION = FluidAmount.ofWhole(1000000L);
    public static final FluidAmount BUCKET = ONE;
    public static final FluidAmount BOTTLE = FluidAmount.of(1L, 3L);
    public static final FluidAmount MAX_BUCKETS = FluidAmount.createDirect(Long.MAX_VALUE, 0L, 1L);
    public static final FluidAmount MIN_BUCKETS = FluidAmount.createDirect(Long.MIN_VALUE, 0L, 1L);
    public static final FluidAmount ABSOLUTE_MAXIMUM = FluidAmount.createDirect(Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
    public static final FluidAmount ABSOLUTE_MINIMUM = FluidAmount.createDirect(Long.MIN_VALUE, -9223372036854775806L, Long.MAX_VALUE);
    @Deprecated(since="0.8.0", forRemoval=true)
    public static final FluidAmount MAX_VALUE = ABSOLUTE_MAXIMUM;
    @Deprecated(since="0.8.0", forRemoval=true)
    public static final FluidAmount MIN_VALUE = ABSOLUTE_MINIMUM;
    public static final JsonDeserializer<FluidAmount> DESERIALIZER = (json, type, ctx) -> FluidAmount.fromJson(json);
    public final long whole;
    public final long numerator;
    public final long denominator;

    @Deprecated(since="0.8.2", forRemoval=true)
    public FluidAmount(long whole) {
        this(whole, 0L, 1L);
    }

    public static FluidAmount ofWhole(long whole) {
        return FluidAmount.of(whole, 0L, 1L);
    }

    public static FluidAmount of(long numerator, long denominator) {
        return FluidAmount.of(0L, numerator, denominator);
    }

    public static FluidAmount of1620(int amount) {
        return FluidAmount.of(amount, 1620L);
    }

    public static FluidAmount of(long whole, long numerator, long denominator) {
        if (denominator <= 0L) {
            throw new IllegalArgumentException("The denominator (" + denominator + ") must be positive!");
        }
        if (whole < 0L && numerator > 0L) {
            ++whole;
            numerator -= denominator;
        } else if (whole > 0L && numerator < 0L) {
            --whole;
            numerator = denominator + numerator;
        }
        if (Math.abs(numerator) >= denominator) {
            long val = numerator / denominator;
            whole += val;
            numerator %= denominator;
        }
        if (numerator < 0L) {
            gcd = LongMath.gcd((long)(-numerator), (long)denominator);
            numerator /= gcd;
            denominator /= gcd;
        } else if (numerator > 0L) {
            gcd = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= gcd;
            denominator /= gcd;
        } else {
            denominator = 1L;
        }
        return FluidAmount.createDirect(whole, numerator, denominator);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidAmount fromDouble(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Cannot turn infinity or NaN into a FluidAmount!");
        }
        throw new AbstractMethodError("// TODO: Implement this!");
    }

    public static FluidAmount parse(String text) throws NumberFormatException {
        return (FluidAmount)FluidAmount.parse0(text, true);
    }

    public static Object tryParse(String text) {
        return FluidAmount.parse0(text, false);
    }

    /*
     * Unable to fully structure code
     */
    private static Object parse0(String text, boolean shouldThrow) throws NumberFormatException {
        if (text == null) {
            return FluidAmount.simpleError(shouldThrow, "The text was null!");
        }
        try {
            return FluidAmount.ofWhole(Long.parseLong(text.trim()));
        }
        catch (NumberFormatException var2_2) {
            sign0 = '\u0000';
            sign1 = '\u0000';
            bracket0 = false;
            bracket1 = false;
            whole = 0L;
            numerator = 0L;
            denominator = 0L;
            isDecimal = false;
            decimalLength = -1;
            stage = 0;
            numberStart = -1;
            numberEnd = -1;
            i = 0;
            while (true) {
                block66: {
                    block63: {
                        block64: {
                            block65: {
                                block61: {
                                    block62: {
                                        end = i >= text.length();
                                        badCharDesc = null;
                                        if (!end) break block61;
                                        if (stage != 3 && (stage != 7 && stage != 10 || numberStart == -1)) break block62;
                                        numberEnd = i;
                                        break block63;
                                    }
                                    if (stage == 11) break;
                                    badCharDesc = "the end";
                                    break block64;
                                }
                                c = text.charAt(i);
                                if (c >= '0' && '9' >= c || numberStart == -1) break block65;
                                numberEnd = i--;
                                break block63;
                            }
                            switch (c) {
                                case ' ': {
                                    numberEnd = i;
                                    break block63;
                                }
                                case '/': {
                                    if (stage != 6) ** GOTO lbl44
                                    stage = 7;
                                    break block66;
lbl44:
                                    // 1 sources

                                    if (stage != 3) ** GOTO lbl53
                                    stage = 7;
                                    numerator = whole;
                                    whole = 0L;
                                    sign1 = '+';
                                    if (bracket0) {
                                        bracket1 = true;
                                        bracket0 = false;
                                    }
                                    break block66;
lbl53:
                                    // 1 sources

                                    badCharDesc = "the division symbol '/'";
                                    break;
                                }
                                case '+': 
                                case '-': {
                                    if (stage != 0) ** GOTO lbl60
                                    sign0 = c;
                                    stage = 1;
                                    break block66;
lbl60:
                                    // 1 sources

                                    if (stage != 3) ** GOTO lbl64
                                    sign1 = c;
                                    stage = 4;
                                    break block66;
lbl64:
                                    // 1 sources

                                    badCharDesc = "the sign '" + c + "'";
                                    break;
                                }
                                case '(': {
                                    if (stage == 0) {
                                        sign0 = '+';
                                        stage = 1;
                                    } else if (stage == 3) {
                                        sign1 = '+';
                                        stage = 4;
                                    }
                                    if (stage != 1) ** GOTO lbl78
                                    bracket0 = true;
                                    stage = 2;
                                    break block66;
lbl78:
                                    // 1 sources

                                    if (stage != 4) ** GOTO lbl82
                                    bracket1 = true;
                                    stage = 5;
                                    break block66;
lbl82:
                                    // 1 sources

                                    badCharDesc = "the open bracket '('";
                                    break;
                                }
                                case ')': {
                                    if (!bracket1 || stage != 8) ** GOTO lbl88
                                    stage = bracket0 ? 9 : 11;
                                    break block66;
lbl88:
                                    // 1 sources

                                    if (!bracket1 || stage != 9) ** GOTO lbl91
                                    stage = 11;
                                    break block66;
lbl91:
                                    // 1 sources

                                    badCharDesc = "the closing bracket ')'";
                                    break;
                                }
                                case '.': {
                                    if (stage != 3) ** GOTO lbl98
                                    stage = 10;
                                    isDecimal = true;
                                    break block66;
lbl98:
                                    // 1 sources

                                    badCharDesc = "the decimal point '.'";
                                    break;
                                }
                                default: {
                                    if ('0' > c || c > 57) ** GOTO lbl120
                                    if (stage == 0) {
                                        sign0 = '+';
                                        bracket0 = false;
                                        stage = 2;
                                    } else if (stage == 1) {
                                        bracket0 = false;
                                        stage = 2;
                                    } else if (stage == 4) {
                                        bracket1 = false;
                                        stage = 5;
                                    }
                                    if (stage != 2 && stage != 5 && stage != 7 && stage != 10) ** GOTO lbl118
                                    if (numberStart == -1) {
                                        numberStart = i;
                                    }
                                    break block66;
lbl118:
                                    // 1 sources

                                    badCharDesc = "a number '" + c + "'";
                                    break;
lbl120:
                                    // 1 sources

                                    badCharDesc = "an unknown character '" + c + "' (" + Character.getName(c) + ")";
                                    break;
                                }
                            }
                        }
                        expected = null;
                        switch (stage) {
                            case 0: {
                                expected = "either '+', '-', '(', or a number";
                                break;
                            }
                            case 1: {
                                expected = "either '(' or a number for the whole";
                                break;
                            }
                            case 2: {
                                expected = "a number for the whole";
                                break;
                            }
                            case 3: {
                                expected = "either '+', '-', '.', '/', or a number";
                                break;
                            }
                            case 4: {
                                expected = "either '(' or a number for the numerator";
                                break;
                            }
                            case 5: {
                                expected = "a number for the numerator";
                                break;
                            }
                            case 6: {
                                expected = "the division symbol '/'";
                                break;
                            }
                            case 7: {
                                expected = "a number for the denominator";
                                break;
                            }
                            case 8: {
                                if (bracket1) {
                                    expected = "the closing bracket ')'";
                                    break;
                                }
                                throw new IllegalStateException("Bad state: bracket1 is false, but we've been moved to stage 8!");
                            }
                            case 9: {
                                if (bracket0) {
                                    expected = "the closing bracket ')'";
                                    break;
                                }
                                throw new IllegalStateException("Bad state: bracket0 is false, but we've been moved to stage 9!");
                            }
                            case 10: {
                                expected = "a number for the decimal";
                                break;
                            }
                            case 11: {
                                expected = "the end";
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Bad state: we've been moved to an unknown stage (" + stage + ")");
                            }
                        }
                        return FluidAmount.simpleError(shouldThrow, "Expected " + expected + ", but got " + (String)badCharDesc + " at index " + i + " for input '" + text + "'");
                    }
                    if (numberStart != -1) {
                        lval = 1L;
                        parseFailed = false;
                        error = null;
                        sub = text.substring(numberStart, numberEnd);
                        try {
                            lval = Long.parseLong(sub);
                        }
                        catch (NumberFormatException nfe) {
                            parseFailed = true;
                        }
                        numberStart = -1;
                        numberEnd = -1;
                        name = null;
                        switch (stage) {
                            case 2: {
                                if (parseFailed) {
                                    name = "whole";
                                    break;
                                }
                                whole = lval;
                                stage = 3;
                                break block66;
                            }
                            case 5: {
                                if (parseFailed) {
                                    name = "numerator";
                                    break;
                                }
                                numerator = lval;
                                stage = 6;
                                break block66;
                            }
                            case 7: {
                                if (!parseFailed && lval <= 0L) {
                                    error = "non-positive values are not allowed";
                                }
                                if (parseFailed) {
                                    name = "denominator";
                                    break;
                                }
                                denominator = lval;
                                stage = bracket1 ? 8 : (bracket0 ? 9 : 11);
                                break block66;
                            }
                            case 10: {
                                if (parseFailed) {
                                    name = "decimal";
                                    break;
                                }
                                numerator = lval;
                                decimalLength = sub.length();
                                stage = 11;
                                break block66;
                            }
                            default: {
                                throw new IllegalStateException("One of the stages didn't handle this correctly... " + stage);
                            }
                        }
                        return FluidAmount.simpleError(shouldThrow, "Bad " + name + ": '" + sub + "'" + (String)(error == null ? "" : ": " + error));
                    }
                }
                ++i;
            }
            if (!FluidAmount.$assertionsDisabled && stage != 11) {
                throw new AssertionError((Object)("Bad stage " + stage));
            }
            if (!FluidAmount.$assertionsDisabled && sign0 != '-' && sign0 != '+') {
                throw new AssertionError((Object)"Missing sign0");
            }
            if (isDecimal) {
                if (!FluidAmount.$assertionsDisabled && sign1 != '\u0000') {
                    throw new AssertionError((Object)"Was both decimal and sign1!");
                }
                if (!FluidAmount.$assertionsDisabled && decimalLength <= 0) {
                    throw new AssertionError((Object)"Missing decimal length");
                }
                sign1 = sign0;
                bracket0 = false;
                denominator = LongMath.pow((long)10L, (int)decimalLength);
            }
            if (!FluidAmount.$assertionsDisabled && sign1 != '-' && sign1 != '+') {
                throw new AssertionError((Object)"Missing sign1");
            }
            if (sign0 == '-') {
                whole = -whole;
                if (bracket0) {
                    numerator = -numerator;
                }
            }
            if (sign1 == '-') {
                numerator = -numerator;
            }
            return FluidAmount.of(whole, numerator, denominator);
        }
    }

    private static String simpleError(boolean shouldThrow, String error) throws NumberFormatException {
        if (!shouldThrow) {
            return error;
        }
        throw new NumberFormatException(error);
    }

    static FluidAmount createDirect(long whole, long numerator, long denominator) {
        return new FluidAmount(whole, numerator, denominator);
    }

    private FluidAmount(long whole, long numerator, long denominator) {
        this.whole = whole;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static FluidAmount fromNbt(class_2487 tag) {
        long w = tag.method_10537("w");
        long n = tag.method_10537("n");
        long d = Math.max(1L, tag.method_10537("d"));
        return FluidAmount.of(w, n, d);
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10544("w", this.whole);
        tag.method_10544("n", this.numerator);
        tag.method_10544("d", this.denominator);
        return tag;
    }

    public static FluidAmount fromStdBuffer(ByteBuf buffer) {
        long w = buffer.readLong();
        long n = buffer.readLong();
        long d = Math.max(1L, buffer.readLong());
        return FluidAmount.of(w, n, d);
    }

    public void toStdBuffer(ByteBuf buffer) {
        buffer.writeLong(this.whole);
        buffer.writeLong(this.numerator);
        buffer.writeLong(this.denominator);
    }

    public static FluidAmount fromMcBuffer(class_2540 buffer) {
        long w = buffer.method_10792();
        long n = buffer.method_10792();
        long d = Math.max(1L, buffer.method_10792());
        return FluidAmount.of(w, n, d);
    }

    public void toMcBuffer(class_2540 buffer) {
        buffer.method_10791(this.whole);
        buffer.method_10791(this.numerator);
        buffer.method_10791(this.denominator);
    }

    public static FluidAmount fromJson(JsonElement json) throws JsonSyntaxException {
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString()) {
                Object result = FluidAmount.tryParse(primitive.getAsString());
                if (result instanceof FluidAmount) {
                    return (FluidAmount)result;
                }
                throw new JsonSyntaxException((String)result);
            }
            if (primitive.isNumber()) {
                return FluidAmount.ofWhole(primitive.getAsLong());
            }
            throw new JsonSyntaxException("Cannot convert " + primitive + " to a FluidAmount!");
        }
        throw new JsonSyntaxException("Expected either a string or an integer, but got " + json + "!");
    }

    public JsonElement toJson() {
        if (this.numerator == 0L) {
            return new JsonPrimitive((Number)this.whole);
        }
        return new JsonPrimitive(this.toParseableString());
    }

    @Override
    public boolean isZero() {
        return this.whole == 0L && this.numerator == 0L;
    }

    @Override
    public boolean isNegative() {
        return this.whole < 0L || this.numerator < 0L;
    }

    @Override
    public boolean isPositive() {
        return this.whole > 0L || this.numerator > 0L;
    }

    @Override
    public int sign() {
        if (this.whole != 0L) {
            return this.whole < 0L ? -1 : 1;
        }
        if (this.numerator != 0L) {
            return this.numerator < 0L ? -1 : 1;
        }
        return 0;
    }

    public boolean isOverflow() {
        return this.whole == Long.MIN_VALUE || this.whole == Long.MAX_VALUE || this.numerator == Long.MIN_VALUE || this.numerator == Long.MAX_VALUE || this.denominator == Long.MAX_VALUE;
    }

    @Override
    public FluidAmount getDivisor() {
        if (this.denominator == 1L) {
            return ONE;
        }
        return FluidAmount.createDirect(0L, 1L, this.denominator);
    }

    public int as1620() {
        return this.asInt(1620);
    }

    public int as1620(RoundingMode rounding) {
        return this.asInt(1620, rounding);
    }

    public int asInt(int base) {
        return this.asInt(base, RoundingMode.UP);
    }

    public int asInt(int base, RoundingMode rounding) {
        long lvalue = this.asLong(base, rounding);
        if (lvalue < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (lvalue > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)lvalue;
    }

    public long asLong(long base) {
        return this.asLong(base, RoundingMode.UP);
    }

    public long asLong(long base, RoundingMode rounding) {
        if (base < 1L) {
            throw new IllegalArgumentException("Base (" + base + ") must be greater than 0!");
        }
        FluidAmount mult = this.saturatedMul(base);
        if (mult.isOverflow()) {
            return mult.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        if (mult.numerator == 0L) {
            return mult.whole;
        }
        switch (rounding) {
            case DOWN: {
                return mult.whole;
            }
            case UP: {
                return LongMath.saturatedAdd((long)mult.whole, (long)mult.sign());
            }
            case CEILING: {
                return mult.whole > 0L ? LongMath.saturatedAdd((long)mult.whole, (long)1L) : mult.whole;
            }
            case FLOOR: {
                return mult.whole < 0L ? LongMath.saturatedAdd((long)mult.whole, (long)-1L) : mult.whole;
            }
            case HALF_DOWN: {
                if (Math.abs(mult.numerator) <= mult.denominator / 2L) {
                    return mult.whole;
                }
                return LongMath.saturatedAdd((long)mult.whole, (long)mult.sign());
            }
            case HALF_UP: {
                long pnum = Math.abs(mult.numerator);
                if (pnum <= mult.denominator / 2L && pnum * 2L < mult.denominator) {
                    return mult.whole;
                }
                return LongMath.saturatedAdd((long)mult.whole, (long)mult.sign());
            }
            case HALF_EVEN: {
                long pnum = Math.abs(mult.numerator);
                if (pnum <= mult.denominator / 2L) {
                    if (pnum * 2L < mult.denominator) {
                        return mult.whole;
                    }
                    if ((mult.whole & 1L) == 0L) {
                        return mult.whole;
                    }
                }
                return LongMath.saturatedAdd((long)mult.whole, (long)mult.sign());
            }
            case UNNECESSARY: {
                throw new ArithmeticException("Rounding Mode is 'UNNECESSARY', but the fraction has a non-zero numerator! " + this);
            }
        }
        throw new IllegalArgumentException("Unknown rounding mode " + rounding);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FluidAmount)) {
            return false;
        }
        return this.equals((FluidAmount)obj);
    }

    public int hashCode() {
        return Arrays.hashCode(new long[]{this.whole, this.numerator, this.denominator});
    }

    public String toDisplayString() {
        if (this.numerator == 0L || this.denominator == 1L) {
            return "" + this.whole;
        }
        String str = "" + this.whole;
        if (this.denominator < 0x10000000000000L) {
            double fraction = (double)this.numerator / (double)this.denominator;
            int decimalPlaces = 1 + Long.toString(this.denominator - 1L).length();
            int roundingValue = (int)Math.pow(10.0, decimalPlaces);
            Object fractionStr = Long.toString((long)(fraction * (double)roundingValue));
            while (((String)fractionStr).length() < decimalPlaces) {
                fractionStr = "0" + (String)fractionStr;
            }
            while (((String)fractionStr).endsWith("0")) {
                fractionStr = ((String)fractionStr).substring(0, ((String)fractionStr).length() - 1);
            }
            return str + "." + (String)fractionStr;
        }
        return "{TODO: Display this huge fraction properly (" + this.whole + " + " + this.numerator + "/" + this.denominator + ")}";
    }

    public String toString() {
        return "{FluidAmount " + this.whole + " + " + this.numerator + "/" + this.denominator + "}";
    }

    public String toParseableString() {
        String str = this.toParseableString0();
        assert (this.equals(FluidAmount.parse(str)));
        return str;
    }

    private String toParseableString0() {
        if (this.whole == 0L) {
            if (this.numerator == 0L) {
                return "0";
            }
            return this.numerator + "/" + this.denominator;
        }
        if (this.numerator == 0L) {
            return Long.toString(this.whole);
        }
        if (this.numerator < 0L) {
            return this.whole + " " + this.numerator + "/" + this.denominator;
        }
        return this.whole + "+" + this.numerator + "/" + this.denominator;
    }

    public boolean equals(FluidAmount other) {
        return this.whole == other.whole && this.numerator == other.numerator && this.denominator == other.denominator;
    }

    @Override
    public int compareTo(@Nullable FluidAmount o) {
        if (o == null) {
            return this.sign();
        }
        if (this.whole != o.whole) {
            return Long.compare(this.whole, o.whole);
        }
        if (this.denominator == o.denominator) {
            return Long.compare(this.numerator, o.numerator);
        }
        long a = LongMath.saturatedMultiply((long)this.numerator, (long)o.denominator);
        long b = LongMath.saturatedMultiply((long)o.numerator, (long)this.denominator);
        if (!FluidAmount.didOverflow(a) && !FluidAmount.didOverflow(b)) {
            return Long.compare(a, b);
        }
        BigInteger a2 = this._bigNumerator().multiply(o._bigDenominator());
        BigInteger b2 = o._bigNumerator().multiply(this._bigDenominator());
        return a2.compareTo(b2);
    }

    @Override
    public double asInexactDouble() {
        return (double)this.whole + (double)this.numerator / (double)this.denominator;
    }

    @Override
    public FluidAmount negate() {
        return FluidAmount.createDirect(-this.whole, -this.numerator, this.denominator);
    }

    @Override
    public FluidAmount lcm(FluidAmount other) {
        return this._bigLcm(other).asLongIntExact();
    }

    public FluidAmount add(@Nullable FluidAmount other) {
        return this.roundedAdd(other);
    }

    public SafeAddResult safeAdd(@Nullable FluidAmount other, RoundingMode rounding) {
        if (other == null) {
            return new SafeAddResult(this);
        }
        return new SafeAddResult(this.bigAdd(other), rounding);
    }

    public SafeAddResult safeAdd(@Nullable FluidAmount other) {
        return this.safeAdd(other, RoundingMode.HALF_EVEN);
    }

    public FluidAmount roundedAdd(@Nullable FluidAmount other, RoundingMode rounding) {
        return this.add0(other, rounding);
    }

    public FluidAmount roundedAdd(@Nullable FluidAmount other) {
        return this.roundedAdd(other, RoundingMode.HALF_EVEN);
    }

    public FluidAmount add(long by) {
        if (by == 0L) {
            return this;
        }
        if (this.isZero()) {
            return FluidAmount.ofWhole(by);
        }
        return FluidAmount.of(by + this.whole, this.numerator, this.denominator);
    }

    public FluidAmount checkedAdd(@Nullable FluidAmount by) {
        return this.add0(by, RoundingMode.UNNECESSARY);
    }

    public FluidAmount saturatedAdd(@Nullable FluidAmount by) {
        return this.add0(by, RoundingMode.HALF_EVEN);
    }

    private FluidAmount add0(FluidAmount by, RoundingMode rounding) {
        long n2d1;
        long n1d2;
        long w;
        if (by == null || by.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return by;
        }
        if (rounding == null) {
            rounding = RoundingMode.HALF_EVEN;
        }
        if (FluidAmount.didOverflow(w = LongMath.saturatedAdd((long)this.whole, (long)by.whole))) {
            if (rounding == RoundingMode.UNNECESSARY) {
                throw new ArithmeticException("Cannot add the values " + this.whole + " and " + by.whole + " as they overflow, and the RoundingMode is UNNECESSARY!");
            }
            return w > 0L ? MAX_BUCKETS : MIN_BUCKETS;
        }
        long d = LongMath.saturatedMultiply((long)this.denominator, (long)by.denominator);
        if (!(FluidAmount.didOverflow(d) || FluidAmount.didOverflow(n1d2 = LongMath.saturatedMultiply((long)this.numerator, (long)by.denominator)) || FluidAmount.didOverflow(n2d1 = LongMath.saturatedMultiply((long)by.numerator, (long)this.denominator)))) {
            long n = LongMath.saturatedAdd((long)n1d2, (long)n2d1);
            if (!FluidAmount.didOverflow(n2d1)) {
                return FluidAmount.of(w, n, d);
            }
        }
        BigFluidAmount bigResult = this._bigAdd(by);
        return bigResult.asLongIntRounded(rounding);
    }

    public BigFluidAmount bigAdd(@Nullable FluidAmount by) {
        if (by == null || by.isZero()) {
            return this.asBigInt();
        }
        if (this.isZero()) {
            return by.asBigInt();
        }
        return this._bigAdd(by);
    }

    public BigFluidAmount add(@Nullable BigFluidAmount by) {
        if (by == null || by.isZero()) {
            return this.asBigInt();
        }
        if (this.isZero()) {
            return by;
        }
        return this._bigAdd(by);
    }

    public FluidAmount sub(long by) {
        return this.add(-by);
    }

    public FluidAmount sub(@Nullable FluidAmount other) {
        return this.roundedSub(other);
    }

    public FluidAmount checkedSub(@Nullable FluidAmount by) {
        return by == null ? this : this.checkedAdd(by.negate());
    }

    public FluidAmount saturatedSub(@Nullable FluidAmount by) {
        return by == null ? this : this.saturatedAdd(by.negate());
    }

    public SafeAddResult safeSub(@Nullable FluidAmount by, RoundingMode rounding) {
        return by == null ? new SafeAddResult(this) : this.safeAdd(by.negate(), rounding);
    }

    public SafeAddResult safeSub(@Nullable FluidAmount by) {
        return by == null ? new SafeAddResult(this) : this.safeAdd(by.negate());
    }

    public FluidAmount roundedSub(@Nullable FluidAmount by, RoundingMode rounding) {
        return by == null ? this : this.roundedAdd(by.negate(), rounding);
    }

    public FluidAmount roundedSub(@Nullable FluidAmount by) {
        return by == null ? this : this.roundedAdd(by.negate());
    }

    public BigFluidAmount sub(@Nullable BigFluidAmount by) {
        return by == null ? this.asBigInt() : this.add(by.negate());
    }

    public static FluidMergeResult merge(FluidAmount target, FluidAmount toAdd) {
        return FluidAmount.merge(target, toAdd, FluidMergeRounding.ROUND_HALF_EVEN);
    }

    public static FluidMergeResult merge(FluidAmount target, FluidAmount toAdd, FluidMergeRounding rounding) {
        switch (rounding) {
            case ROUND_UNNECESSARY: {
                return new FluidMergeResult(target.checkedAdd(toAdd), ZERO, BigFluidAmount.ZERO);
            }
            case MAXIMUM_POSSIBLE: {
                FluidAmount d2;
                SafeAddResult result = target.safeAdd(toAdd);
                if (result.getError().isZero()) {
                    return new FluidMergeResult(result.roundedResult);
                }
                FluidAmount d1 = target.getDivisor();
                FluidAmount movable = d1.lcm(d2 = toAdd.getDivisor());
                long multiple = toAdd.getCountOf(movable);
                if (multiple == 0L) {
                    return new FluidMergeResult(target, toAdd, BigFluidAmount.ZERO);
                }
                FluidAmount toMove = movable.checkedMul(multiple);
                SafeAddResult merged = target.safeAdd(toMove);
                SafeAddResult excess = toAdd.safeSub(toMove);
                if (merged.roundedResult.isOverflow() || excess.roundedResult.isOverflow()) {
                    return new FluidMergeResult(target, toAdd, BigFluidAmount.ZERO);
                }
                assert (merged.getError().isZero()) : merged;
                assert (excess.getError().isZero()) : excess;
                return new FluidMergeResult(merged.roundedResult, excess.roundedResult, BigFluidAmount.ZERO);
            }
            case FAIL: {
                SafeAddResult result = target.safeAdd(toAdd);
                if (result.getError().isZero()) {
                    return new FluidMergeResult(result.roundedResult);
                }
                return new FluidMergeResult(target, toAdd, BigFluidAmount.ZERO);
            }
        }
        assert (rounding.rounding != null) : "Unknown mode " + rounding;
        SafeAddResult result = target.safeAdd(toAdd, rounding.rounding);
        return new FluidMergeResult(result.roundedResult, ZERO, result.getError());
    }

    public static FluidMergeResult merge(FluidAmount target, FluidAmount toAdd, long denominatorTarget, long denominatorAdd) {
        long gcd;
        long rem;
        if (denominatorTarget < 0L) {
            throw new IllegalArgumentException("denominatorTarget must be >= 0!");
        }
        if (denominatorTarget > 0L) {
            if (denominatorTarget < target.denominator) {
                throw new IllegalArgumentException("The target " + target + " has a denominator greater than the required " + denominatorTarget + "!");
            }
            rem = denominatorTarget % target.denominator;
            if (rem != 0L) {
                throw new IllegalArgumentException("The target " + target + " has a denominator that's not a multiple of the required " + denominatorTarget + "!");
            }
        }
        if (denominatorAdd < 0L) {
            throw new IllegalArgumentException("denominatorAdd must be >= 0!");
        }
        if (denominatorAdd > 0L) {
            if (denominatorAdd < toAdd.denominator) {
                throw new IllegalArgumentException("The 'toAdd' " + toAdd + " has a denominator greater than the required " + denominatorAdd + "!");
            }
            rem = denominatorAdd % toAdd.denominator;
            if (rem != 0L) {
                throw new IllegalArgumentException("The 'toAdd' " + toAdd + " has a denominator that's not a multiple of the required " + denominatorAdd + "!");
            }
        }
        if ((gcd = LongMath.gcd((long)denominatorAdd, (long)denominatorTarget)) == 0L) {
            return new FluidMergeResult(target.checkedAdd(toAdd), ZERO, BigFluidAmount.ZERO);
        }
        throw new AbstractMethodError("// TODO: Implement this!");
    }

    public FluidAmount mul(FluidAmount by) {
        return this.roundedMul(by);
    }

    public FluidAmount mul(long by) {
        return this.roundedMul(by);
    }

    public FluidAmount checkedMul(long by) {
        return this.roundedMul(by, RoundingMode.UNNECESSARY);
    }

    public FluidAmount saturatedMul(long by) {
        if (by == 0L || this.isZero()) {
            return ZERO;
        }
        if (by == 1L) {
            return this;
        }
        if (by == -1L) {
            return this.negate();
        }
        long nb = LongMath.saturatedMultiply((long)this.numerator, (long)by);
        long w = LongMath.saturatedMultiply((long)this.whole, (long)by);
        if (FluidAmount.didOverflow(nb) || FluidAmount.didOverflow(w)) {
            return this.isPositive() == by > 0L ? MAX_BUCKETS : MIN_BUCKETS;
        }
        long div = nb / this.denominator;
        long rem = nb % this.denominator;
        if (FluidAmount.didOverflow(w = LongMath.saturatedAdd((long)w, (long)div))) {
            return this.isPositive() == by > 0L ? MAX_BUCKETS : MIN_BUCKETS;
        }
        return FluidAmount.of(w, rem, this.denominator);
    }

    public FluidAmount roundedMul(long by) {
        return this.roundedMul(by, RoundingMode.HALF_EVEN);
    }

    public FluidAmount roundedMul(long by, RoundingMode rounding) {
        if (by == 0L) {
            return ZERO;
        }
        if (by == 1L) {
            return this;
        }
        if (by == -1L) {
            return this.negate();
        }
        long nb = LongMath.saturatedMultiply((long)by, (long)this.numerator);
        long w = LongMath.saturatedMultiply((long)this.whole, (long)by);
        if (!FluidAmount.didOverflow(nb) && !FluidAmount.didOverflow(w)) {
            return FluidAmount.of(w, nb, this.denominator);
        }
        return this._bigMul(FluidAmount.ofWhole(by)).asLongIntRounded(rounding);
    }

    public FluidAmount checkedMul(FluidAmount by) {
        return this.mul0(by, RoundingMode.UNNECESSARY);
    }

    public FluidAmount saturatedMul(FluidAmount by) {
        return this.mul0(by, null);
    }

    public FluidAmount roundedMul(FluidAmount by) {
        return this.mul0(by, RoundingMode.HALF_EVEN);
    }

    public FluidAmount roundedMul(FluidAmount by, RoundingMode rounding) {
        return this.mul0(by, rounding);
    }

    private FluidAmount mul0(FluidAmount by, RoundingMode rounding) {
        long n3;
        long n3_a;
        long n1n2;
        long d1d2;
        long w2n1d2;
        long w2n1;
        long w1n2d1;
        long w3;
        if (by.isZero() || this.isZero()) {
            return ZERO;
        }
        if (by.equals(ONE)) {
            return this;
        }
        if (this.equals(ONE)) {
            return by;
        }
        if (by.equals(NEGATIVE_ONE)) {
            return this.negate();
        }
        if (this.equals(NEGATIVE_ONE)) {
            return by.negate();
        }
        long w1 = this.whole;
        long w2 = by.whole;
        long n1 = this.numerator;
        long n2 = by.numerator;
        long d1 = this.denominator;
        long d2 = by.denominator;
        if (rounding == RoundingMode.UNNECESSARY) {
            w3 = LongMath.checkedMultiply((long)w1, (long)w2);
        } else {
            w3 = LongMath.saturatedMultiply((long)w1, (long)w2);
            if (FluidAmount.didOverflow(w3)) {
                return w3 < 0L ? MIN_BUCKETS : MAX_BUCKETS;
            }
        }
        long w1n2 = LongMath.saturatedMultiply((long)w1, (long)n2);
        if (!(FluidAmount.didOverflow(w1n2) || FluidAmount.didOverflow(w1n2d1 = LongMath.saturatedMultiply((long)w1n2, (long)d1)) || FluidAmount.didOverflow(w2n1 = LongMath.saturatedMultiply((long)w2, (long)n1)) || FluidAmount.didOverflow(w2n1d2 = LongMath.saturatedMultiply((long)w2n1, (long)d2)) || FluidAmount.didOverflow(d1d2 = LongMath.saturatedMultiply((long)d1, (long)d2)) || FluidAmount.didOverflow(n1n2 = LongMath.saturatedMultiply((long)n1, (long)n2)) || FluidAmount.didOverflow(n3_a = LongMath.saturatedAdd((long)w1n2d1, (long)w2n1d2)) || FluidAmount.didOverflow(n3 = LongMath.saturatedAdd((long)n3_a, (long)n1n2)))) {
            return FluidAmount.of(w3, n3, d1d2);
        }
        BigFluidAmount result = this._bigMul(by);
        return rounding == null ? result.asLongIntSaturated() : result.asLongIntRounded(rounding);
    }

    public BigFluidAmount mul(BigFluidAmount by) {
        return this._bigMul(by);
    }

    public BigFluidAmount bigMul(FluidAmount by) {
        return this._bigMul(by);
    }

    private static boolean didOverflow(long value) {
        return value == Long.MIN_VALUE || value == Long.MAX_VALUE;
    }

    @Override
    public FluidAmount reciprocal() {
        return ONE.div(this);
    }

    public BigFluidAmount bigReciprocal() {
        return this._bigReciprocal();
    }

    public long getCountOf(FluidAmount by) {
        return this.saturatedDiv((FluidAmount)by).whole;
    }

    public FluidAmount div(long other) {
        return this.roundedDiv(other);
    }

    public FluidAmount div(FluidAmount other) {
        return this.roundedDiv(other);
    }

    public FluidAmount checkedDiv(long by) {
        return this.divInner(by, RoundingMode.UNNECESSARY);
    }

    public FluidAmount saturatedDiv(long by) {
        return this.divInner(by, null);
    }

    public FluidAmount roundedDiv(long by) {
        return this.divInner(by, RoundingMode.HALF_EVEN);
    }

    public FluidAmount roundedDiv(long by, RoundingMode rounding) {
        return this.divInner(by, rounding);
    }

    private FluidAmount divInner(long by, RoundingMode rounding) {
        long w2d1;
        long n1_w1d1;
        if (by == 1L) {
            return this;
        }
        if (by == -1L) {
            return this.negate();
        }
        if (by == 0L) {
            throw new ArithmeticException("divide by 0");
        }
        long w1 = this.whole;
        long w2 = by;
        long n1 = this.numerator;
        long d1 = this.denominator;
        long w1d1 = LongMath.saturatedMultiply((long)w1, (long)d1);
        if (!(FluidAmount.didOverflow(w1d1) || FluidAmount.didOverflow(n1_w1d1 = LongMath.saturatedAdd((long)n1, (long)w1d1)) || FluidAmount.didOverflow(w2d1 = LongMath.saturatedMultiply((long)w2, (long)d1)))) {
            return FluidAmount.of(n1_w1d1, w2d1);
        }
        BigFluidAmount result = this._bigDiv(FluidAmount.of(by, 0L, 1L));
        return rounding == null ? result.asLongIntSaturated() : result.asLongIntRounded(rounding);
    }

    public FluidAmount checkedDiv(FluidAmount by) {
        return this.divInner(by, RoundingMode.UNNECESSARY);
    }

    public FluidAmount saturatedDiv(FluidAmount by) {
        return this.divInner(by, null);
    }

    public FluidAmount roundedDiv(FluidAmount by) {
        return this.divInner(by, RoundingMode.HALF_EVEN);
    }

    public FluidAmount roundedDiv(FluidAmount by, RoundingMode rounding) {
        return this.divInner(by, rounding);
    }

    private FluidAmount divInner(FluidAmount by, @Nullable RoundingMode rounding) {
        long n2d1_w2d1d2;
        long w2d1d2;
        long w2d1;
        long n2d1;
        long n1d2_w1d1d2;
        long w1d1d2;
        long w1d1;
        if (by.equals(ONE)) {
            return this;
        }
        if (by.equals(NEGATIVE_ONE)) {
            return this.negate();
        }
        if (by.isZero()) {
            throw new ArithmeticException("divide by 0");
        }
        long w1 = this.whole;
        long w2 = by.whole;
        long n1 = this.numerator;
        long n2 = by.numerator;
        long d1 = this.denominator;
        long d2 = by.denominator;
        long n1d2 = LongMath.saturatedMultiply((long)n1, (long)d2);
        if (!(FluidAmount.didOverflow(n1d2) || FluidAmount.didOverflow(w1d1 = LongMath.saturatedMultiply((long)w1, (long)d1)) || FluidAmount.didOverflow(w1d1d2 = LongMath.saturatedMultiply((long)w1d1, (long)d2)) || FluidAmount.didOverflow(n1d2_w1d1d2 = LongMath.saturatedAdd((long)n1d2, (long)w1d1d2)) || FluidAmount.didOverflow(n2d1 = LongMath.saturatedMultiply((long)n2, (long)d1)) || FluidAmount.didOverflow(w2d1 = LongMath.saturatedMultiply((long)w2, (long)d1)) || FluidAmount.didOverflow(w2d1d2 = LongMath.saturatedMultiply((long)w2d1, (long)d2)) || FluidAmount.didOverflow(n2d1_w2d1d2 = LongMath.saturatedAdd((long)n2d1, (long)w2d1d2)))) {
            return FluidAmount.of(n1d2_w1d1d2, n2d1_w2d1d2);
        }
        BigFluidAmount result = this.bigDiv(by);
        return rounding == null ? result.asLongIntSaturated() : result.asLongIntRounded(rounding);
    }

    public BigFluidAmount div(BigFluidAmount by) {
        return this._bigDiv(by);
    }

    public BigFluidAmount bigDiv(FluidAmount by) {
        return this._bigDiv(by);
    }

    public FluidAmount[] splitBalanced(int count) {
        return this.splitBalanced(count, 2000L);
    }

    public FluidAmount[] splitBalanced(int count, long maxDenominator) {
        return this.splitBalanced(new FluidAmount[count], maxDenominator);
    }

    public FluidAmount[] splitBalanced(FluidAmount[] dest, long maxDenominator) {
        Object[] ret = this.splitBalanced0(dest, maxDenominator);
        boolean validate = false;
        if (!$assertionsDisabled) {
            validate = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (validate) {
            assert (ret == dest) : "ret != dest";
            FluidAmount total = ZERO;
            for (FluidAmount in : dest) {
                total = total.checkedAdd(in);
            }
            assert (this.equals(total)) : "this " + this + " != total " + total + " for " + Arrays.toString(ret);
        }
        return ret;
    }

    private FluidAmount[] splitBalanced0(FluidAmount[] dest, long maxDenominator) {
        int count = dest.length;
        if (count == 1) {
            dest[0] = this;
            return dest;
        }
        if (count == 0) {
            if (this.isZero()) {
                return dest;
            }
            throw new IllegalArgumentException("Cannot balance a FluidAmount into nothing unless we're zero!");
        }
        long realDivisor = LongMath.saturatedMultiply((long)this.denominator, (long)count);
        if (!FluidAmount.didOverflow(realDivisor) && realDivisor <= maxDenominator) {
            FluidAmount amount = this.div(count);
            Arrays.fill(dest, amount);
            return dest;
        }
        long numeratorPer = this.numerator / (long)count;
        long overflowNumerator = this.numerator % (long)count;
        long wholePer = this.whole / (long)count;
        long overflowWhole = this.whole % (long)count;
        if (overflowWhole != 0L) {
            long addToNumerator = this.denominator * overflowWhole / (long)count;
            long remainder = this.denominator * overflowWhole % (long)count;
            if (remainder >= (long)count) {
                addToNumerator += remainder / (long)count;
                remainder %= (long)count;
            }
            if ((overflowNumerator += remainder) > (long)count) {
                overflowNumerator -= (long)count;
                ++numeratorPer;
            } else if (overflowNumerator < (long)(-count)) {
                overflowNumerator += (long)count;
                --numeratorPer;
            }
            if ((numeratorPer += addToNumerator) > this.denominator) {
                numeratorPer -= this.denominator;
                ++wholePer;
            } else if (numeratorPer < -this.denominator) {
                numeratorPer += this.denominator;
                --wholePer;
            }
        }
        if (overflowNumerator == 0L) {
            FluidAmount amount = FluidAmount.of(wholePer, numeratorPer, this.denominator);
            Arrays.fill(dest, amount);
            return dest;
        }
        if (overflowNumerator < 0L) {
            --numeratorPer;
            overflowNumerator = -overflowNumerator;
        }
        FluidAmount bigger = FluidAmount.of(wholePer, numeratorPer + 1L, this.denominator);
        FluidAmount smaller = FluidAmount.of(wholePer, numeratorPer, this.denominator);
        Arrays.fill(dest, 0, (int)overflowNumerator, bigger);
        Arrays.fill(dest, (int)overflowNumerator, dest.length, smaller);
        return dest;
    }

    @Override
    BigInteger _bigWhole() {
        return BigInteger.valueOf(this.whole);
    }

    @Override
    BigInteger _bigNumerator() {
        return BigInteger.valueOf(this.numerator);
    }

    @Override
    BigInteger _bigDenominator() {
        return BigInteger.valueOf(this.denominator);
    }

    @Override
    FluidAmount _this() {
        return this;
    }

    @Override
    public FluidAmount asLongIntExact() {
        return this;
    }

    @Override
    public BigFluidAmount asBigInt() {
        return new BigFluidAmount(this);
    }

    public static final class SafeAddResult {
        public final FluidAmount roundedResult;
        public final BigFluidAmount exactValue;
        private BigFluidAmount error;

        public SafeAddResult(FluidAmount roundedResult, BigFluidAmount exactValue) {
            this.roundedResult = roundedResult;
            this.exactValue = exactValue;
        }

        public SafeAddResult(FluidAmount exactValue) {
            this.roundedResult = exactValue;
            this.exactValue = this.roundedResult.asBigInt();
        }

        public SafeAddResult(BigFluidAmount exactValue, RoundingMode rounding) {
            this.roundedResult = exactValue.asLongIntRounded(rounding);
            this.exactValue = exactValue;
        }

        public String toString() {
            return "{SafeAddResult rounded=" + this.roundedResult + " exact=" + this.exactValue + " error=" + this.getError() + " }";
        }

        public BigFluidAmount getError() {
            if (this.error == null) {
                this.error = this.exactValue.sub(this.roundedResult);
            }
            return this.error;
        }
    }

    public static final class FluidMergeRounding
    extends Enum<FluidMergeRounding> {
        public static final /* enum */ FluidMergeRounding FAIL = new FluidMergeRounding(null);
        public static final /* enum */ FluidMergeRounding MAXIMUM_POSSIBLE = new FluidMergeRounding(null);
        public static final /* enum */ FluidMergeRounding ROUND_UP = new FluidMergeRounding(RoundingMode.UP);
        public static final /* enum */ FluidMergeRounding ROUND_DOWN = new FluidMergeRounding(RoundingMode.DOWN);
        public static final /* enum */ FluidMergeRounding ROUND_CEILING = new FluidMergeRounding(RoundingMode.CEILING);
        public static final /* enum */ FluidMergeRounding ROUND_FLOOR = new FluidMergeRounding(RoundingMode.FLOOR);
        public static final /* enum */ FluidMergeRounding ROUND_HALF_UP = new FluidMergeRounding(RoundingMode.HALF_UP);
        public static final /* enum */ FluidMergeRounding ROUND_HALF_DOWN = new FluidMergeRounding(RoundingMode.HALF_DOWN);
        public static final /* enum */ FluidMergeRounding ROUND_HALF_EVEN = new FluidMergeRounding(RoundingMode.HALF_EVEN);
        public static final /* enum */ FluidMergeRounding ROUND_UNNECESSARY = new FluidMergeRounding(RoundingMode.UNNECESSARY);
        public static final FluidMergeRounding DEFAULT;
        @Nullable
        public final RoundingMode rounding;
        private static final /* synthetic */ FluidMergeRounding[] $VALUES;

        public static FluidMergeRounding[] values() {
            return (FluidMergeRounding[])$VALUES.clone();
        }

        public static FluidMergeRounding valueOf(String name) {
            return Enum.valueOf(FluidMergeRounding.class, name);
        }

        private FluidMergeRounding(RoundingMode rounding) {
            this.rounding = rounding;
        }

        public static FluidMergeRounding fromRounding(@Nullable RoundingMode rounding) {
            if (rounding == null) {
                return FAIL;
            }
            FluidMergeRounding r = FluidMergeRounding.values()[rounding.ordinal() + 2];
            assert (r.rounding == rounding);
            return r;
        }

        private static /* synthetic */ FluidMergeRounding[] $values() {
            return new FluidMergeRounding[]{FAIL, MAXIMUM_POSSIBLE, ROUND_UP, ROUND_DOWN, ROUND_CEILING, ROUND_FLOOR, ROUND_HALF_UP, ROUND_HALF_DOWN, ROUND_HALF_EVEN, ROUND_UNNECESSARY};
        }

        static {
            $VALUES = FluidMergeRounding.$values();
            DEFAULT = ROUND_HALF_EVEN;
        }
    }

    public static final class FluidMergeResult {
        public final FluidAmount merged;
        public final FluidAmount excess;
        public final BigFluidAmount roundingError;

        public FluidMergeResult(FluidAmount merged) {
            this.merged = merged;
            this.excess = ZERO;
            this.roundingError = BigFluidAmount.ZERO;
        }

        public FluidMergeResult(FluidAmount merged, FluidAmount excess, BigFluidAmount error) {
            this.merged = merged;
            this.excess = excess;
            this.roundingError = error;
        }
    }
}

