/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid.amount;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmountBase;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class BigFluidAmount
extends FluidAmountBase<BigFluidAmount> {
    public static final BigFluidAmount ZERO = FluidAmount.ZERO.asBigInt();
    public static final BigFluidAmount ONE = FluidAmount.ONE.asBigInt();
    public static final BigFluidAmount NEGATIVE_ONE = FluidAmount.NEGATIVE_ONE.asBigInt();
    public static final BigFluidAmount BUCKET = ONE;
    public static final BigFluidAmount BOTTLE = FluidAmount.BOTTLE.asBigInt();
    public final BigInteger whole;
    public final BigInteger numerator;
    public final BigInteger denominator;

    BigFluidAmount(BigInteger whole, BigInteger numerator, BigInteger denominator) {
        this.whole = whole;
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public BigFluidAmount(FluidAmount from) {
        this.whole = from._bigWhole();
        this.numerator = from._bigNumerator();
        this.denominator = from._bigDenominator();
    }

    public static BigFluidAmount of(BigInteger numerator, BigInteger denominator) {
        return BigFluidAmount.of(BigInteger.ZERO, numerator, denominator);
    }

    public static BigFluidAmount of(BigInteger whole, BigInteger numerator, BigInteger denominator) {
        if (denominator.signum() <= 0) {
            throw new IllegalArgumentException("The denominator (" + denominator + ") must be positive!");
        }
        if (whole.signum() < 0 && numerator.signum() > 0) {
            whole = whole.add(BigInteger.valueOf(1L));
            numerator = numerator.subtract(denominator);
        } else if (whole.signum() > 0 && numerator.signum() < 0) {
            whole = whole.subtract(BigInteger.valueOf(1L));
            numerator = denominator.add(numerator);
        }
        if (numerator.abs().compareTo(denominator) >= 0) {
            BigInteger[] divRem = numerator.divideAndRemainder(denominator);
            whole = whole.add(divRem[0]);
            numerator = divRem[1];
        }
        if (numerator.signum() < 0) {
            gcd = numerator.negate().gcd(denominator);
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        } else if (numerator.signum() > 0) {
            gcd = numerator.gcd(denominator);
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
        } else {
            denominator = BigInteger.ONE;
        }
        return new BigFluidAmount(whole, numerator, denominator);
    }

    @Override
    public boolean isZero() {
        return this.whole.equals(BigInteger.ZERO) && this.numerator.equals(BigInteger.ZERO);
    }

    @Override
    public boolean isNegative() {
        return this.whole.signum() < 0 || this.numerator.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.whole.signum() > 0 || this.numerator.signum() > 0;
    }

    @Override
    public int sign() {
        if (this.whole.signum() != 0) {
            return this.whole.signum();
        }
        return this.numerator.signum();
    }

    @Override
    public BigFluidAmount getDivisor() {
        if (this.denominator.equals(BigInteger.ONE)) {
            return ONE;
        }
        return new BigFluidAmount(BigInteger.ZERO, BigInteger.ONE, this.denominator);
    }

    @Override
    public BigFluidAmount lcm(BigFluidAmount other) {
        return this._bigLcm(other);
    }

    @Override
    public BigFluidAmount negate() {
        return new BigFluidAmount(this.whole.negate(), this.numerator.negate(), this.denominator);
    }

    @Override
    public BigFluidAmount reciprocal() {
        return this._bigReciprocal();
    }

    @Override
    public FluidAmount asLongIntExact() {
        return BigFluidAmount._toSmall(this.whole, this.numerator, this.denominator);
    }

    public boolean fitsInLongInt() {
        return this.whole.bitLength() < 64 && this.numerator.bitLength() < 64 && this.denominator.bitLength() < 64;
    }

    public FluidAmount asLongIntSaturated() {
        if (this.fitsInLongInt()) {
            return this.asLongIntExact();
        }
        return this.isNegative() ? FluidAmount.MIN_BUCKETS : FluidAmount.MAX_BUCKETS;
    }

    public FluidAmount asLongIntRounded() {
        return this.asLongIntRounded(RoundingMode.HALF_EVEN);
    }

    public FluidAmount asLongIntRounded(RoundingMode rounding) {
        if (this.fitsInLongInt()) {
            return this.asLongIntExact();
        }
        if (rounding == null) {
            rounding = RoundingMode.HALF_EVEN;
        }
        if (rounding == RoundingMode.UNNECESSARY) {
            throw new ArithmeticException(this + " doesn't fit into a normal FluidAmount, and the rounding mode is specified as UNNECESSARY!");
        }
        if (this.whole.bitLength() >= 64) {
            return this.isNegative() ? FluidAmount.MIN_BUCKETS : FluidAmount.MAX_BUCKETS;
        }
        long w = this.whole.longValue();
        int bits = this.denominator.bitLength();
        assert (bits > 63);
        BigInteger shiftedD = this.denominator.shiftRight(bits - 63);
        BigInteger shiftedN = this.numerator.shiftRight(bits - 63);
        assert (shiftedD.bitLength() <= 63);
        assert (shiftedN.bitLength() <= 63);
        return FluidAmount.of(w, shiftedN.longValue(), shiftedD.longValue());
    }

    @Override
    public BigFluidAmount asBigInt() {
        return this;
    }

    public BigFluidAmount add(long by) {
        if (by == 0L) {
            return this;
        }
        return BigFluidAmount.of(this.whole.add(BigInteger.valueOf(by)), this.numerator, this.denominator);
    }

    public BigFluidAmount add(@Nullable BigFluidAmount by) {
        if (by == null || by.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return by;
        }
        return this._bigAdd(by);
    }

    public BigFluidAmount add(@Nullable FluidAmount by) {
        if (by == null || by.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return by.asBigInt();
        }
        return this._bigAdd(by);
    }

    public BigFluidAmount sub(long by) {
        return this.add(-by);
    }

    public BigFluidAmount sub(@Nullable BigFluidAmount by) {
        return this._bigSub(by);
    }

    public BigFluidAmount sub(@Nullable FluidAmount by) {
        return this._bigSub(by);
    }

    public BigFluidAmount mul(long by) {
        if (by == 1L) {
            return this;
        }
        if (by == -1L) {
            return this.negate();
        }
        if (by == 0L || this.isZero()) {
            return ZERO;
        }
        return this._bigMul(FluidAmount.of(by, 0L, 1L));
    }

    public BigFluidAmount mul(BigFluidAmount by) {
        if (this.isZero() || by.isZero()) {
            return ZERO;
        }
        if (by.equals(ONE)) {
            return this;
        }
        if (by.equals(NEGATIVE_ONE)) {
            return this.negate();
        }
        if (this.equals(ONE)) {
            return by;
        }
        if (this.equals(NEGATIVE_ONE)) {
            return by.negate();
        }
        return this._bigMul(by);
    }

    public BigFluidAmount mul(FluidAmount by) {
        if (this.isZero() || by.isZero()) {
            return ZERO;
        }
        if (by.equals(FluidAmount.ONE)) {
            return this;
        }
        if (by.equals(FluidAmount.NEGATIVE_ONE)) {
            return this.negate();
        }
        if (this.equals(ONE)) {
            return by.asBigInt();
        }
        if (this.equals(NEGATIVE_ONE)) {
            return by.negate().asBigInt();
        }
        return this._bigMul(by);
    }

    public BigFluidAmount div(long by) {
        if (by == 1L) {
            return this;
        }
        if (by == -1L) {
            return this.negate();
        }
        if (by == 0L) {
            throw new ArithmeticException("divide by 0");
        }
        return this._bigDiv(FluidAmount.of(by, 0L, 1L));
    }

    public BigFluidAmount div(BigFluidAmount by) {
        if (by.equals(ONE)) {
            return this;
        }
        if (by.equals(NEGATIVE_ONE)) {
            return this.negate();
        }
        if (by.isZero()) {
            throw new ArithmeticException("divide by 0");
        }
        return this._bigDiv(by);
    }

    public BigFluidAmount div(FluidAmount by) {
        if (by.equals(FluidAmount.ONE)) {
            return this;
        }
        if (by.equals(FluidAmount.NEGATIVE_ONE)) {
            return this.negate();
        }
        if (by.isZero()) {
            throw new ArithmeticException("divide by 0");
        }
        return this._bigDiv(by);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigFluidAmount)) {
            return false;
        }
        return this.equals((BigFluidAmount)obj);
    }

    public int hashCode() {
        return Arrays.hashCode(new BigInteger[]{this.whole, this.numerator, this.denominator});
    }

    public String toString() {
        return "{BigFluidAmount " + this.whole + " + " + this.numerator + "/" + this.denominator + "}";
    }

    public boolean equals(BigFluidAmount other) {
        return this.whole.equals(other.whole) && this.numerator.equals(other.numerator) && this.denominator.equals(other.denominator);
    }

    @Override
    public int compareTo(BigFluidAmount o) {
        if (o == null) {
            return this.sign();
        }
        if (!this.whole.equals(o.whole)) {
            return this.whole.compareTo(o.whole);
        }
        if (this.denominator.equals(o.denominator)) {
            return this.numerator.compareTo(o.numerator);
        }
        BigInteger a = this.numerator.multiply(o.denominator);
        BigInteger b = o.numerator.multiply(this.denominator);
        return a.compareTo(b);
    }

    @Override
    public double asInexactDouble() {
        return this.whole.doubleValue() + this.numerator.doubleValue() / this.denominator.doubleValue();
    }

    @Override
    BigInteger _bigWhole() {
        return this.whole;
    }

    @Override
    BigInteger _bigNumerator() {
        return this.numerator;
    }

    @Override
    BigInteger _bigDenominator() {
        return this.denominator;
    }

    @Override
    BigFluidAmount _this() {
        return this;
    }
}

