/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;

public class SingleFluidTankView {
    final FixedFluidInvView backingView;
    final int tank;

    SingleFluidTankView(FixedFluidInvView backingView, int tank) {
        this.backingView = backingView;
        this.tank = tank;
        if (tank < 0) {
            throw new IllegalArgumentException(tank + " is negative! This will never work!");
        }
    }

    public FixedFluidInvView getBackingInv() {
        return this.backingView;
    }

    public final int getIndex() {
        return this.tank;
    }

    public final FluidVolume get() {
        return this.backingView.getInvFluid(this.tank);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public final int getMaxAmount() {
        return this.backingView.getMaxAmount(this.tank);
    }

    public final FluidAmount getMaxAmount_F() {
        return this.backingView.getMaxAmount_F(this.tank);
    }

    public final FluidAmount getSpace() {
        return this.getMaxAmount_F().sub(this.get().amount());
    }

    public final boolean isValid(FluidKey fluid) {
        return this.backingView.isFluidValidForTank(this.tank, fluid);
    }

    public final FluidFilter getFilter() {
        return this.backingView.getFilterForTank(this.tank);
    }

    public final ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        return this.backingView.addListener((realInv, s, previous, current) -> {
            assert (realInv == this.backingView);
            if (this.tank == s) {
                listener.onChange(realInv, this.tank, previous, current);
            }
        }, removalToken);
    }
}

