/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidTransferable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.SingleFluidTankView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.function.Function;

public final class SingleFluidTank
extends SingleFluidTankView
implements FluidTransferable,
Reference<FluidVolume> {
    SingleFluidTank(FixedFluidInv backingView, int tank) {
        super(backingView, tank);
    }

    @Override
    public final FixedFluidInv getBackingInv() {
        return (FixedFluidInv)this.backingView;
    }

    public final boolean set(FluidVolume to, Simulation simulation) {
        return this.getBackingInv().setInvFluid(this.tank, to, simulation);
    }

    public final void forceSet(FluidVolume to) {
        this.getBackingInv().forceSetInvFluid(this.tank, to);
    }

    public final void modify(Function<FluidVolume, FluidVolume> function) {
        this.getBackingInv().modifyTank(this.tank, function);
    }

    @Override
    public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
        return this.getBackingInv().insertFluid(this.tank, fluid, simulation);
    }

    @Override
    @Deprecated(since="0.6.0", forRemoval=true)
    public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
        return this.getBackingInv().extractFluid(this.tank, filter, FluidVolumeUtil.EMPTY, FluidAmount.of1620(maxAmount), simulation);
    }

    @Override
    public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        return this.getBackingInv().extractFluid(this.tank, filter, FluidVolumeUtil.EMPTY, maxAmount, simulation);
    }

    @Override
    public FluidFilter getInsertionFilter() {
        return this.getBackingInv().getFilterForTank(this.tank);
    }

    public boolean set(FluidVolume value) {
        return this.set(value, Simulation.ACTION);
    }

    public boolean isValid(FluidVolume value) {
        return super.isValid(value.getFluidKey());
    }
}

