/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.DelegatingGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;

public interface LimitedGroupedFluidInv
extends GroupedFluidInv {
    public LimitedGroupedFluidInv markFinal();

    public LimitedGroupedFluidInv copy();

    default public LimitedGroupedFluidInv reset() {
        this.getAllRule().reset();
        return this;
    }

    default public GroupedFluidInv asUnmodifiable() {
        return new DelegatingGroupedFluidInv(this);
    }

    default public FluidLimitRule getAllRule() {
        return this.getRule(ConstantFluidFilter.ANYTHING);
    }

    default public FluidLimitRule getRule(FluidKey key) {
        return this.getRule(key.exactFilter);
    }

    public FluidLimitRule getRule(FluidFilter var1);

    public static interface FluidLimitRule {
        default public FluidLimitRule disallowTransfer() {
            return this.disallowInsertion().disallowExtraction();
        }

        default public FluidLimitRule reset() {
            return this.allowExtraction().allowInsertion();
        }

        default public FluidLimitRule disallowInsertion() {
            return this.limitInsertionAmount(FluidAmount.ZERO);
        }

        default public FluidLimitRule allowInsertion() {
            return this.limitInsertionAmount(FluidAmount.NEGATIVE_ONE);
        }

        @Deprecated(since="0.6.4", forRemoval=true)
        default public FluidLimitRule limitInsertionCount(int max) {
            return this.limitInsertionAmount(FluidAmount.of1620(max));
        }

        public FluidLimitRule limitInsertionAmount(FluidAmount var1);

        default public FluidLimitRule disallowExtraction() {
            return this.setMinimum(FluidAmount.MAX_BUCKETS);
        }

        default public FluidLimitRule allowExtraction() {
            return this.setMinimum(FluidAmount.ZERO);
        }

        @Deprecated(since="0.6.4", forRemoval=true)
        default public FluidLimitRule setMinimum(int min) {
            return this.setMinimum(FluidAmount.of1620(min));
        }

        public FluidLimitRule setMinimum(FluidAmount var1);
    }
}

