/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public final class LbaFluidsConfig {
    private static final String FILE_NAME = "libblockattributes_fluids.txt";
    public static final boolean USE_SYMBOLS;
    public static final boolean USE_TICKS;
    public static final boolean USE_SHORT_DESC;
    public static final boolean DISABLE_FLUID_COLOURS;
    public static final boolean DISABLE_EMPHASIS_COLOURS;
    public static final boolean TOOLTIP_JOIN_NAME_AMOUNT;

    static {
        FabricLoader fabric = FabricLoader.getInstance();
        Path gameDir = fabric.getGameDir();
        Path cfgDir = gameDir == null ? Paths.get("config", new String[0]) : fabric.getConfigDir();
        if (!Files.isDirectory(cfgDir, new LinkOption[0])) {
            try {
                Files.createDirectories(cfgDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create the config directory! (" + cfgDir + ")", e);
            }
        }
        Path cfgFile = cfgDir.resolve(FILE_NAME);
        Properties props = new Properties();
        boolean didFileExist = Files.exists(cfgFile, new LinkOption[0]);
        if (gameDir != null) {
            Path oldConfigFile = gameDir.resolve(FILE_NAME);
            if (!didFileExist && Files.exists(oldConfigFile, new LinkOption[0])) {
                didFileExist = true;
                try {
                    Files.move(oldConfigFile, cfgFile, new CopyOption[0]);
                }
                catch (IOException e) {
                    LibBlockAttributes.LOGGER.error("Failed to move the old config file to the new one!", (Throwable)e);
                }
            }
        }
        if (didFileExist) {
            try (BufferedReader reader = Files.newBufferedReader(cfgFile, StandardCharsets.UTF_8);){
                props.load(reader);
            }
            catch (IOException e) {
                LibBlockAttributes.LOGGER.error("Failed to read the config file!", (Throwable)e);
            }
        }
        boolean hasAll = true;
        hasAll &= props.containsKey("symbols");
        USE_SYMBOLS = "true".equalsIgnoreCase(props.getProperty("symbols", "false"));
        hasAll &= props.containsKey("ticks");
        USE_TICKS = "true".equalsIgnoreCase(props.getProperty("ticks", "false"));
        hasAll &= props.containsKey("short_desc");
        USE_SHORT_DESC = "true".equalsIgnoreCase(props.getProperty("short_desc", "false"));
        hasAll &= props.containsKey("disable_fluid_colours");
        DISABLE_FLUID_COLOURS = "true".equalsIgnoreCase(props.getProperty("disable_fluid_colours", "false"));
        hasAll &= props.containsKey("disable_emphasis_colours");
        DISABLE_EMPHASIS_COLOURS = "true".equalsIgnoreCase(props.getProperty("disable_emphasis_colours", "false"));
        TOOLTIP_JOIN_NAME_AMOUNT = "true".equalsIgnoreCase(props.getProperty("tooltip_join_name_amount", "false"));
        if (!(hasAll &= props.containsKey("tooltip_join_name_amount"))) {
            try (BufferedWriter fw = Files.newBufferedWriter(cfgFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                if (!didFileExist) {
                    fw.append("# LibBlockAttributes options file (fluids module)\n");
                    fw.append("# Removing an option will reset it back to the default value\n");
                    fw.append("# Removing or altering comments doesn't replace them.\n\n");
                }
                if (!props.containsKey("symbols")) {
                    fw.append("# False to use long names (buckets, ticks) or true to use symbols (B, t)\n");
                    fw.append("symbols=false\n\n");
                }
                if (!props.containsKey("ticks")) {
                    fw.append("# False to use seconds or true to use ticks (1/20th of a second)\n");
                    fw.append("ticks=false\n\n");
                }
                if (!props.containsKey("short_desc")) {
                    fw.append("# False to use long descriptions, or true to use shorter ones. For example:\n");
                    fw.append("#  false: '3 Buckets of Water in a 16 Bucket Tank'\n");
                    fw.append("#  true:  '3 / 16 Buckets of Water'\n");
                    fw.append("short_desc=false\n\n");
                }
                if (!props.containsKey("disable_fluid_colours")) {
                    fw.append("# False to allow fluids to use their own text colour, true to remove it.\n");
                    fw.append("disable_fluid_colours=false\n\n");
                }
                if (!props.containsKey("disable_emphasis_colours")) {
                    fw.append("# True to colour tooltips to emphasise numbers, false to use the default colour.\n");
                    fw.append("disable_emphasis_colours=false\n\n");
                }
                if (!props.containsKey("tooltip_join_name_amount")) {
                    fw.append("# True to join the name with the amount in tooltips. For example:\n");
                    fw.append("# 'true':\n");
                    fw.append("#   '3 Buckets of Water in a 16 Bucket Tank'\n");
                    fw.append("# 'false':\n");
                    fw.append("#   'Water'\n");
                    fw.append("#   '3 Buckets in a 16 Bucket Tank'\n");
                    fw.append("tooltip_join_name_amount=false\n\n");
                }
            }
            catch (IOException e) {
                LibBlockAttributes.LOGGER.warn("[config] Failed to write the config file!", (Throwable)e);
            }
        }
    }
}

