/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.AttributeUtil;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FluidInvAmountChangeListener;
import alexiil.mc.lib.attributes.fluid.FluidInvAmountChangeListener_F;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Set;

public interface GroupedFluidInvView {
    public Set<FluidKey> getStoredFluids();

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getAmount(FluidKey fluid) {
        FluidInvStatistic stats = this.getStatistics(fluid.exactFilter);
        if (!2.$assertionsDisabled && stats.spaceTotal < 0) {
            throw new AssertionError();
        }
        return stats.amount;
    }

    default public FluidAmount getAmount_F(FluidKey fluid) {
        FluidInvStatistic stats = this.getStatistics(fluid.exactFilter);
        if (!2.$assertionsDisabled && stats.spaceTotal_F.isNegative()) {
            throw new AssertionError();
        }
        return stats.amount_F;
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getCapacity(FluidKey fluid) {
        FluidInvStatistic stats = this.getStatistics(fluid.exactFilter);
        if (!2.$assertionsDisabled && stats.spaceTotal < 0) {
            throw new AssertionError();
        }
        return stats.amount + stats.spaceAddable + stats.spaceTotal;
    }

    default public FluidAmount getCapacity_F(FluidKey fluid) {
        FluidInvStatistic stats = this.getStatistics(fluid.exactFilter);
        if (!2.$assertionsDisabled && stats.spaceTotal_F.isNegative()) {
            throw new AssertionError();
        }
        return stats.amount_F.roundedAdd(stats.spaceAddable_F).roundedAdd(stats.spaceTotal_F);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getTotalCapacity() {
        return this.getTotalCapacity_F().as1620(RoundingMode.DOWN);
    }

    default public FluidAmount getTotalCapacity_F() {
        return FluidAmount.of1620(this.getTotalCapacity());
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getSpace(FluidKey fluid) {
        return this.getCapacity(fluid) - this.getAmount(fluid);
    }

    default public FluidAmount getSpace_F(FluidKey fluid) {
        return this.getCapacity_F(fluid).roundedSub(this.getAmount_F(fluid));
    }

    public FluidInvStatistic getStatistics(FluidFilter var1);

    default public FluidInvStatistic getStatistics(FluidKey filter) {
        return this.getStatistics(filter.exactFilter);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getAmount(FluidFilter filter) {
        return this.getStatistics((FluidFilter)filter).amount;
    }

    default public FluidAmount getAmount_F(FluidFilter filter) {
        return this.getStatistics((FluidFilter)filter).amount_F;
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public ListenerToken addListener(FluidInvAmountChangeListener listener, ListenerRemovalToken removalToken) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            GroupedFluidInvView.validateGroupedFluidInvView(this);
        }
        return this.addListener_F(FluidInvAmountChangeListener.asNew(listener), removalToken);
    }

    default public ListenerToken addListener_F(FluidInvAmountChangeListener_F listener, ListenerRemovalToken removalToken) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            GroupedFluidInvView.validateGroupedFluidInvView(this);
        }
        return this.addListener(FluidInvAmountChangeListener_F.asOld(listener), removalToken);
    }

    public static void validateGroupedFluidInvView(GroupedFluidInvView instance) {
        Class<?> c = instance.getClass();
        try {
            Method m0 = c.getDeclaredMethod("addListener", FluidInvAmountChangeListener.class, ListenerRemovalToken.class);
            Method m1 = c.getDeclaredMethod("addListener_F", FluidInvAmountChangeListener_F.class, ListenerRemovalToken.class);
            if (m0.getDeclaringClass() == GroupedFluidInvView.class && m1.getDeclaringClass() == GroupedFluidInvView.class) {
                throw new Error("The " + c + " needs to override either addListener() or addListener_F()!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    default public GroupedFluidInvView getGroupedView() {
        final GroupedFluidInvView real = this;
        return new GroupedFluidInvView(){

            @Override
            public GroupedFluidInvView getGroupedView() {
                return this;
            }

            @Override
            public int getAmount(FluidKey fluid) {
                return real.getAmount(fluid);
            }

            @Override
            public int getAmount(FluidFilter filter) {
                return real.getAmount(filter);
            }

            @Override
            public int getCapacity(FluidKey fluid) {
                return real.getCapacity(fluid);
            }

            @Override
            public int getSpace(FluidKey fluid) {
                return real.getSpace(fluid);
            }

            @Override
            public int getTotalCapacity() {
                return real.getTotalCapacity();
            }

            @Override
            public Set<FluidKey> getStoredFluids() {
                return Collections.unmodifiableSet(real.getStoredFluids());
            }

            @Override
            public FluidInvStatistic getStatistics(FluidFilter filter) {
                return real.getStatistics(filter);
            }

            @Override
            public ListenerToken addListener_F(FluidInvAmountChangeListener_F listener, ListenerRemovalToken removalToken) {
                1 view = this;
                return real.addListener_F((inv, stack, prev, curr) -> listener.onChange(view, stack, prev, curr), removalToken);
            }
        };
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class FluidInvStatistic {
        public final FluidFilter filter;
        @Deprecated(since="0.6.0", forRemoval=true)
        public final int amount;
        public final FluidAmount amount_F;
        @Deprecated(since="0.6.0", forRemoval=true)
        public final int spaceAddable;
        public final FluidAmount spaceAddable_F;
        @Deprecated(since="0.6.0", forRemoval=true)
        public final int spaceTotal;
        public final FluidAmount spaceTotal_F;

        @Deprecated(since="0.6.0", forRemoval=true)
        public FluidInvStatistic(FluidFilter filter, int amount, int spaceAddable, int spaceTotal) {
            this.filter = filter;
            this.amount = amount;
            this.spaceAddable = spaceAddable;
            this.spaceTotal = spaceTotal;
            this.amount_F = FluidAmount.of1620(amount);
            this.spaceAddable_F = FluidAmount.of1620(spaceAddable);
            this.spaceTotal_F = FluidAmount.of1620(spaceTotal);
        }

        public FluidInvStatistic(FluidFilter filter, FluidAmount amount, FluidAmount spaceAddable, FluidAmount spaceTotal) {
            this.filter = filter;
            this.amount = amount.as1620();
            this.spaceAddable = amount.as1620();
            this.spaceTotal = amount.as1620();
            this.amount_F = amount;
            this.spaceAddable_F = spaceAddable;
            this.spaceTotal_F = spaceTotal;
        }

        public static FluidInvStatistic emptyOf(FluidFilter filter) {
            return new FluidInvStatistic(filter, FluidAmount.ZERO, FluidAmount.ZERO, FluidAmount.ZERO);
        }
    }
}

